/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.vod;

import android.content.Context;
import com.gensee.common.GenseeConfig;
import com.gensee.entity.VodObject;
import com.gensee.utils.FileUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import java.util.HashMap;

public class VodMr {
    private static final String TAG = "VodMr";
    private HashMap<String, VodObject> mHashVod = new HashMap(0);
    private String cachDir;
    private static VodMr ins;

    private VodMr() {
    }

    public void initCachDir(Context c) {
        if (this.cachDir == null) {
            this.cachDir = FileUtil.getCachDir((Context)c, (String)"vodplayer");
        }
    }

    public String getCachDir() {
        return this.cachDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VodMr getIns() {
        if (ins != null) return ins;
        Class<VodMr> clazz = VodMr.class;
        synchronized (VodMr.class) {
            if (ins != null) return ins;
            ins = new VodMr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    public VodObject getVodObjById(String vodId) {
        if (vodId == null || "".equals(vodId)) {
            GenseeLog.w((String)TAG, (String)("getVodObjById vodId = " + vodId));
            return null;
        }
        if (this.mHashVod.containsKey(vodId)) {
            VodObject o = this.mHashVod.get(vodId);
            if (o == null) {
                GenseeLog.w((String)TAG, (String)"getVodObjById VodObject = null");
            }
            return o;
        }
        GenseeLog.w((String)TAG, (String)("getVodObjById uncontain vodId = " + vodId));
        return null;
    }

    public VodObject putVodObj(VodObject vodObject) {
        if (vodObject == null || StringUtil.isEmpty((String)vodObject.getVodId())) {
            GenseeLog.w((String)TAG, (String)"putVodObj put fail");
            return null;
        }
        return this.mHashVod.put(vodObject.getVodId(), vodObject);
    }

    public static String getClientApiUrl(VodObject vodObject) {
        if (vodObject == null) {
            return "";
        }
        String url = String.format("http://%s/clientapi/apichannel", vodObject.getDomain(), vodObject.getSc());
        return GenseeConfig.isNeedChatMsg ? url : "";
    }
}

