/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.vod;

import android.content.Context;
import com.gensee.common.GenseeConstant;
import com.gensee.common.PlayerEnv;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.InitParam;
import com.gensee.entity.QAMsg;
import com.gensee.entity.VodObject;
import com.gensee.entity.VodParam;
import com.gensee.entity.VodPlayParam;
import com.gensee.entity.VoteMsg;
import com.gensee.net.IHttpHandler;
import com.gensee.offline.GSOLComp;
import com.gensee.offline.OnHistoryErrCodeListener;
import com.gensee.parse.VodAttrParse;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.vod.VodMr;
import java.io.InputStream;
import java.util.List;

public class VodSite
implements GSOLComp.OnVodListener {
    public static long startTime = 0L;
    private OnVodListener mListener;
    private GSOLComp mComp;

    public VodSite(Context context) {
        this.mComp = new GSOLComp(context, true);
        this.mComp.setVodListener(this);
    }

    public static boolean init(Context context, OnTaskRet ret) {
        return GSOLComp.initOfflineComp(context, ret);
    }

    @Deprecated
    public static void release() {
    }

    public static void setTcpProxy(PlayerEnv.IProxy proxy) {
        PlayerEnv.setTcpProxy((PlayerEnv.IProxy)proxy);
    }

    public void setVodListener(OnVodListener l) {
        this.mListener = l;
    }

    public void getVodObject(InitParam initParam) {
        this.mComp.initVod(initParam);
    }

    public void getVodDetail(String vodId) {
        final VodObject vodParam = VodMr.getIns().getVodObjById(vodId);
        if (vodParam == null || StringUtil.isEmpty((String)vodParam.getXmlUrl())) {
            if (this.mListener != null) {
                this.mListener.onVodErr(-201);
            }
            return;
        }
        GSOLComp.getStream((String)vodParam.getXmlUrl(), (IHttpHandler.StreamResponse)new IHttpHandler.StreamResponse(){

            public void onConnectError(int errorType, String errorInfo) {
                if (VodSite.this.mListener != null) {
                    VodSite.this.mListener.onVodDetail(vodParam);
                }
            }

            public void onRes(InputStream inputStream) {
                if (inputStream != null) {
                    VodAttrParse parse = new VodAttrParse();
                    parse.vodParse(inputStream, (VodParam)vodParam);
                    if (VodSite.this.mListener != null) {
                        VodSite.this.mListener.onVodDetail(vodParam);
                    }
                }
            }
        });
    }

    public void getQaHistory(String vodId, int pageIndex, OnHistoryErrCodeListener errCodeListener) {
        VodObject vodObj = VodMr.getIns().getVodObjById(vodId);
        if (vodObj != null) {
            this.mComp.getQaHistory((VodParam)vodObj, pageIndex, errCodeListener);
        } else {
            if (this.mListener != null) {
                this.mListener.onVodErr(-201);
            }
            if (null != errCodeListener) {
                errCodeListener.onErrCode(-201);
            }
        }
    }

    public void getQaHistory(String vodId, int pageIndex) {
        this.getQaHistory(vodId, pageIndex, null);
    }

    @Deprecated
    public void getChatHistory(String vodId) {
        this.getChatHistory(vodId, 1);
    }

    public void getChatHistory(String vodId, int pageIndex) {
        VodObject vodObj = VodMr.getIns().getVodObjById(vodId);
        if (vodObj != null) {
            this.mComp.getChatHistory((VodParam)vodObj, pageIndex);
        } else if (this.mListener != null) {
            this.mListener.onVodErr(-201);
        }
    }

    public int answerVote(Context context, String vodId, VoteMsg vote) {
        VodObject vodObj = VodMr.getIns().getVodObjById(vodId);
        if (vodObj == null) {
            return -1;
        }
        return this.mComp.answerVote(context, (VodPlayParam)vodObj, vote);
    }

    public void setBox(boolean isBox) {
        this.mComp.setBox(isBox);
    }

    @Override
    public void onChatHistory(String vodId, List<ChatMsg> chatMsgs, int pageIndex, boolean more) {
        if (this.mListener != null) {
            this.mListener.onChatHistory(vodId, chatMsgs, pageIndex, more);
        }
    }

    @Override
    public void onQaHistory(String vodId, List<QAMsg> chatMsgs, int pageIndex, boolean more) {
        if (this.mListener != null) {
            this.mListener.onQaHistory(vodId, chatMsgs, pageIndex, more);
        }
    }

    @Override
    public void onOlErr(int err) {
        if (this.mListener != null) {
            this.mListener.onVodErr(err);
        }
    }

    @Override
    public void onVodInited(VodParam param) {
        GenseeLog.d((String)"onVodInited", (String)("vodId = " + (param == null ? "" : param.getVodId())));
        if (this.mListener != null) {
            VodMr.getIns().putVodObj((VodObject)param);
            this.mListener.onVodObject(param.getVodId());
        }
    }

    public static interface OnVodListener
    extends GenseeConstant.CommonErrCode {
        public static final int ERR_UN_INVOKE_GETOBJECT = -201;
        public static final int ERR_VOD_INTI_FAIL = 14;
        public static final int ERR_VOD_NUM_UNEXIST = 15;
        public static final int ERR_VOD_PWD_ERR = 16;
        public static final int ERR_VOD_ACC_PWD_ERR = 17;
        public static final int ERR_UNSURPORT_MOBILE = 18;
        public static final int ERR_VOD_NUM_OR_ID = 19;

        public void onChatHistory(String var1, List<ChatMsg> var2, int var3, boolean var4);

        public void onQaHistory(String var1, List<QAMsg> var2, int var3, boolean var4);

        public void onVodErr(int var1);

        public void onVodObject(String var1);

        public void onVodDetail(VodObject var1);
    }
}

