/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import com.gensee.pdu.AbsAnno;

public class AnnoText
extends AbsAnno {
    private int color;
    private byte fontsize;
    private String text;
    private float left;
    private float right;
    private float top;
    private float bottom;
    Paint mPaint;
    String[] texts = null;
    int mFontHeight = 0;

    public AnnoText() {
        this.setType(4);
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        if (this.text == null || "".equals(this.text)) {
            return;
        }
        if (this.mPaint == null) {
            if (this.argbColor == -1) {
                this.argbColor = this.agbrToArgb(this.color);
            }
            this.mPaint = new Paint();
            this.mPaint.setColor(this.argbColor);
            this.mPaint.setTextSize((float)this.fontsize);
            this.mPaint.setAntiAlias(true);
            this.mPaint.setDither(true);
            this.mPaint.setStyle(Paint.Style.FILL);
            Paint.FontMetrics fm = this.mPaint.getFontMetrics();
            this.mFontHeight = (int)Math.ceil(fm.bottom - fm.descent - fm.ascent);
            this.texts = this.text.split(String.valueOf('\n'));
        }
        if (this.texts != null) {
            float[] values = new float[9];
            matrix.getValues(values);
            float nScale = values[0];
            if (nScale > values[4]) {
                nScale = values[4];
            }
            this.mPaint.setTextSize((float)this.fontsize * nScale);
            Paint.FontMetrics fm = this.mPaint.getFontMetrics();
            this.mFontHeight = (int)Math.ceil(fm.bottom - fm.descent - fm.ascent);
            long tleft = (long)(this.left * values[0] + values[2]);
            long ttop = (long)(this.top * values[4] + values[5]);
            int len = this.texts.length;
            for (int i = 0; i < len; ++i) {
                String t = this.texts[i];
                if (t == null || "".equals(t)) continue;
                canvas.drawText(this.text == null ? "" : t, (float)tleft, (float)(ttop + (long)((i + 1) * this.mFontHeight)), this.mPaint);
            }
        }
    }

    @Override
    public boolean contain(float x, float y) {
        float tl = this.left;
        float tt = this.top;
        float tr = this.right;
        float tb = this.bottom;
        if (this.left > this.right) {
            tl = this.right;
            tr = this.left;
        }
        if (this.top > this.bottom) {
            tt = this.bottom;
            tb = this.top;
        }
        return x >= tl && x <= tr && y >= tt && y <= tb;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int setArgbColor(int argb) {
        this.argbColor = argb;
        this.color = super.setArgbColor(argb);
        return this.color;
    }

    public byte getFontsize() {
        return this.fontsize;
    }

    public void setFontsize(byte fontsize) {
        this.fontsize = fontsize;
    }

    public float getLeft() {
        return this.left;
    }

    public void setLeft(float left) {
        this.left = left;
    }

    public float getRight() {
        return this.right;
    }

    public void setRight(float right) {
        this.right = right;
    }

    public float getTop() {
        return this.top;
    }

    public void setTop(float top) {
        this.top = top;
    }

    public float getBottom() {
        return this.bottom;
    }

    public void setBottom(float bottom) {
        this.bottom = bottom;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnoText other = (AnnoText)obj;
        return this.id == other.id;
    }

    @Override
    public String toString() {
        return "AnnoText [color=" + this.color + ", fontsize=" + this.fontsize + ", text=" + this.text + ", left=" + this.left + ", right=" + this.right + ", top=" + this.top + ", bottom=" + this.bottom + "," + super.toString() + "]";
    }
}

