/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.TextureView;
import com.gensee.doc.AnnoInputMode;
import com.gensee.doc.CtrlMode;
import com.gensee.doc.DrawMode;
import com.gensee.doc.LINE_SIZE;
import com.gensee.doc.OnAnnoDataListener;
import com.gensee.doc.OnAnnoEraseUserIdListener;
import com.gensee.doc.OnDocViewEventListener;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.AnnoAction;
import com.gensee.pdu.DocViewImpl;
import com.gensee.pdu.IGSDocView;
import com.gensee.pdu.OnReAndUndoListener;
import com.gensee.pdu.PduPage;
import com.gensee.utils.GenseeLog;

public class GSDocTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
IGSDocView,
DocViewImpl.onDocViewImplListener {
    protected static final String TAG = "GSDocTextureView";
    private boolean isDestroyed;
    protected DocViewImpl docViewImpl;

    public GSDocTextureView(Context context) {
        this(context, null);
    }

    public GSDocTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSDocTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.setSurfaceTextureListener(this);
        this.docViewImpl = new DocViewImpl(context, this);
        this.docViewImpl.setOnDocViewImplListener(this);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.isDestroyed = false;
        this.sizeChanged(width, height);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        this.sizeChanged(width, height);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.isDestroyed = true;
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    @Override
    public void setOnAnnoEraseUserIdListener(OnAnnoEraseUserIdListener onAnnoEraseUserIdListener) {
        this.docViewImpl.setOnAnnoEraseUserIdListener(onAnnoEraseUserIdListener);
    }

    @Override
    public void setOnAnnoDataListener(OnAnnoDataListener onAnnoDataListener) {
        this.docViewImpl.setOnAnnoDataListener(onAnnoDataListener);
    }

    private void sizeChanged(int w, int h) {
        this.docViewImpl.sizeChanged(w, h);
        this.drawAnnos();
    }

    protected synchronized void drawAnnos() {
        Canvas canvas = null;
        if (!this.isDestroyed) {
            canvas = this.lockCanvas();
        }
        if (canvas != null) {
            canvas.save();
            this.docViewImpl.drawAnnos(canvas);
            canvas.restore();
            if (!this.isDestroyed) {
                try {
                    this.unlockCanvasAndPost(canvas);
                }
                catch (Exception e) {
                    GenseeLog.w((String)TAG, (String)e.getMessage());
                }
            }
        }
    }

    public void setBackgroundColor(int color) {
        this.docViewImpl.setBackgroundColor(color);
        super.setBackgroundColor(color);
    }

    @Override
    public void setOnDocViewClickedListener(OnDocViewEventListener l) {
        this.docViewImpl.setOnDocViewClickedListener(l);
    }

    @Override
    public void forbidZoomGestrue(boolean isFobid) {
        this.docViewImpl.forbidZoomGestrue(isFobid);
    }

    @Override
    public void setTouchforbidden(boolean isTouchforbidden) {
        this.docViewImpl.setTouchforbidden(isTouchforbidden);
    }

    @Override
    public void setThirdPartyMotionEvent(MotionEvent event) {
        this.onTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int nValue = this.docViewImpl.onTouchEvent(event, true);
        if (nValue == -1) {
            return super.onTouchEvent(event);
        }
        return nValue != 0;
    }

    @Override
    public void onDocBound(RectF rectF, int w, int h) {
    }

    public void setBlurMaskFilter() {
        this.docViewImpl.setBlurMaskFilter();
    }

    public void setEmbossmMaskFilter() {
        this.docViewImpl.setEmbossmMaskFilter();
    }

    @Override
    public void setPaintColor(int color) {
        this.docViewImpl.setPaintColor(color);
    }

    public void setErase() {
        this.docViewImpl.setErase();
    }

    @Override
    public void eraseAll() {
        this.docViewImpl.eraseAll();
    }

    @Override
    public void undo(long ownerId) {
        this.docViewImpl.undo(ownerId);
    }

    public void setIndicate() {
        this.docViewImpl.setIndicate();
    }

    @Override
    public void setStrokeWidth(LINE_SIZE width) {
        this.docViewImpl.setStrokeWidth(width);
    }

    @Override
    public void setAnnoMakeType(DrawMode mode) {
        this.docViewImpl.setAnnoMakeType(mode);
    }

    public void setHLType(int type) {
        this.docViewImpl.setHLType(type);
    }

    @Override
    public void setCtrlMode(CtrlMode mode) {
        this.docViewImpl.setCtrlMode(mode);
    }

    @Override
    public void setAnnoAction(AnnoAction action) {
        this.docViewImpl.setAnnoAction(action);
    }

    public void setDocPage(PduPage docPage) {
        this.docViewImpl.setDocPage(docPage);
    }

    public PduPage getDocPage() {
        return this.docViewImpl.getDocPage();
    }

    @Override
    public void showAdaptViewWidthAlignTop() {
        this.docViewImpl.showAdaptViewWidthAlignTop();
    }

    @Override
    public void showAdaptViewHeightAlignLeft() {
        this.docViewImpl.showAdaptViewHeightAlignLeft();
    }

    @Override
    public void showAdaptViewWidth() {
        this.docViewImpl.showAdaptViewWidth();
    }

    @Override
    public void showAdaptViewHeight() {
        this.docViewImpl.showAdaptViewHeight();
    }

    @Override
    public void showFillView() {
        this.docViewImpl.showFillView();
    }

    @Override
    public void showAdaptView() {
        this.docViewImpl.showAdaptView();
    }

    @Override
    public void showSourceScall() {
        this.docViewImpl.showSourceScall();
    }

    @Override
    public int getShowMode() {
        return this.docViewImpl.getShowMode();
    }

    @Override
    public void clear() {
        this.docViewImpl.clear();
    }

    @Override
    public void reset() {
        this.docViewImpl.reset();
    }

    public void onAnnoAdd(AbsAnno anno) {
        this.docViewImpl.onAnnoAdd(anno);
    }

    public void onAnnoDel(AbsAnno anno) {
        this.docViewImpl.onAnnoDel(anno);
    }

    @Override
    public void onUpdate() {
        this.docViewImpl.onUpdate();
    }

    @Override
    public void drawDocPage(PduPage docPage, Canvas mCanvas, int bgColor) {
        docPage.drawBitmap(mCanvas, this.getContext(), bgColor);
    }

    @Override
    public boolean isDrawAnnos() {
        return true;
    }

    @Override
    public void setDefImg(Bitmap bitmap, boolean isFillView) {
        this.docViewImpl.setDefImg(bitmap, isFillView);
    }

    @Override
    public boolean isDragScale() {
        return this.docViewImpl.isDragScale();
    }

    @Override
    public Handler getHandler() {
        return this.docViewImpl.getHandler();
    }

    @Override
    public void invalidateDraw() {
        this.drawAnnos();
    }

    @Override
    public void postinvalidateDraw() {
        this.drawAnnos();
    }

    @Override
    public void setOnDocLabelListener(DocViewImpl.OnDocLabelListener onDocLabelListener) {
    }

    @Override
    public void redoStep() {
        this.docViewImpl.redoStep();
    }

    @Override
    public void undoStep() {
        this.docViewImpl.undoStep();
    }

    @Override
    public int getRedoStackSize() {
        return this.docViewImpl.getRedoStackSize();
    }

    @Override
    public int getUndoStackSize() {
        return this.docViewImpl.getUndoStackSize();
    }

    @Override
    public void setOnReAndUndoListener(OnReAndUndoListener onReAndUndoListener) {
        this.docViewImpl.setOnReAndUndoListener(onReAndUndoListener);
    }

    @Override
    public void resetStatus() {
        this.docViewImpl.resetStatus();
    }

    @Override
    public void setEndAnimation(boolean endAnimation) {
        this.docViewImpl.setEndAnimation(endAnimation);
    }

    @Override
    public void setAnnoInputMode(AnnoInputMode annoInputMode) {
        this.docViewImpl.setAnnoInputMode(annoInputMode);
    }
}

