/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import com.gensee.doc.OnAnnoDataListener;
import com.gensee.doc.OnAnnoDataStatus;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.AnnoAction;
import com.gensee.pdu.AnnoFPoint;
import com.gensee.pdu.AnnoFreepenEx;
import com.gensee.pdu.DocViewImpl;
import com.gensee.pdu.OnReAndUndoListener;
import com.gensee.taskret.OnTaskRet;
import java.util.Arrays;
import java.util.Stack;

class ReAndUndoAnnoImpl
implements OnAnnoDataListener {
    private DocViewImpl docViewImpl;
    private AnnoAction mAnnoAction;
    protected Stack<AnnoData> annoDataPreStack;
    protected Stack<AnnoData> annoDataNextStack;
    private boolean bNextStep = false;
    private boolean bPreStep = false;
    private int nCurDocId = -1;
    private int nCurPageId = -1;
    private int MAX_STACK_SIZE = 20;
    private OnReAndUndoListener onReAndUndoListener;

    public void setOnReAndUndoListener(OnReAndUndoListener onReAndUndoListener) {
        this.onReAndUndoListener = onReAndUndoListener;
    }

    public ReAndUndoAnnoImpl(DocViewImpl docViewImpl) {
        this.docViewImpl = docViewImpl;
        docViewImpl.setOnAnnoDataListener(this);
    }

    public void setAnnoAction(AnnoAction action) {
        this.mAnnoAction = action;
    }

    @Override
    public void onAnnoData(AbsAnno absAnno, OnAnnoDataStatus annoDataStatus) {
        if (null == this.annoDataPreStack) {
            this.annoDataPreStack = new Stack();
        }
        if (null != this.annoDataNextStack) {
            this.annoDataNextStack.clear();
        }
        this.processNextStepStatus(false);
        this.bNextStep = false;
        if (this.annoDataPreStack.size() <= 0) {
            this.processPreStepStatus(true);
        } else if (this.annoDataPreStack.size() >= this.MAX_STACK_SIZE) {
            this.annoDataPreStack.remove(0);
        }
        AnnoData annoData = new AnnoData(absAnno, annoDataStatus);
        this.annoDataPreStack.push(annoData);
    }

    private void processNextStepStatus(boolean bEnable) {
        if (null != this.onReAndUndoListener) {
            this.onReAndUndoListener.onNextStepEnable(bEnable);
        }
    }

    private void processPreStepStatus(boolean bEnable) {
        if (null != this.onReAndUndoListener) {
            this.onReAndUndoListener.onPreStepEnable(bEnable);
        }
    }

    protected void resetStatus() {
        if (null != this.annoDataPreStack) {
            this.annoDataPreStack.clear();
        }
        if (null != this.annoDataNextStack) {
            this.annoDataNextStack.clear();
        }
        this.bNextStep = false;
        this.bPreStep = false;
    }

    private void restoreData(AnnoData annoData) {
        final AbsAnno anno = annoData.absAnno;
        if (anno instanceof AnnoFreepenEx) {
            AnnoFPoint[] points = ((AnnoFreepenEx)anno).getPoints();
            if (null != points && points.length > 0) {
                AnnoFPoint[] beginPoints = new AnnoFPoint[]{points[0]};
                final AnnoFreepenEx newEx = this.sendFreepenEx(beginPoints, 1, (AnnoFreepenEx)anno);
                this.mAnnoAction.sendAnno(newEx, new OnTaskRet(){

                    public void onTaskRet(boolean ret, int id, String desc) {
                        anno.setId(newEx.getId());
                        ReAndUndoAnnoImpl.this.mAnnoAction.onDocReceiveAnno(anno.getDocId(), anno.getPageId(), anno);
                    }
                });
                if (points.length >= 3) {
                    for (int i = 1; i < points.length - 1; ++i) {
                        AnnoFPoint[] addPoints = new AnnoFPoint[]{points[i]};
                        AnnoFreepenEx addEx = this.sendFreepenEx(addPoints, 2, (AnnoFreepenEx)anno);
                        this.mAnnoAction.sendAnno(addEx, null);
                    }
                }
                AnnoFPoint[] endPoints = new AnnoFPoint[]{points[points.length - 1]};
                AnnoFreepenEx endEx = this.sendFreepenEx(endPoints, 3, (AnnoFreepenEx)anno);
                this.mAnnoAction.sendAnno(endEx, null);
            }
        } else {
            this.mAnnoAction.sendAnno(anno, null);
            this.mAnnoAction.onDocReceiveAnno(annoData.absAnno.getDocId(), annoData.absAnno.getPageId(), annoData.absAnno);
        }
    }

    private AnnoFreepenEx sendFreepenEx(AnnoFPoint[] points, int step, AnnoFreepenEx anno) {
        AnnoFreepenEx freepenEx = new AnnoFreepenEx();
        freepenEx.setDocId(anno.getDocId());
        freepenEx.setPageId(anno.getPageId());
        freepenEx.setPoints(Arrays.asList(points));
        freepenEx.setColor(anno.getColor());
        freepenEx.setHighLight(anno.isHighLight());
        freepenEx.setLinesize((byte)anno.getLinesize());
        freepenEx.setStepType(step);
        return freepenEx;
    }

    public void redoStep() {
        if (null == this.annoDataNextStack) {
            return;
        }
        if (this.annoDataNextStack.size() > 0) {
            this.bNextStep = true;
            AnnoData annoData = this.annoDataNextStack.pop();
            if (annoData.annoDataStatus == OnAnnoDataStatus.DEL) {
                this.mAnnoAction.onDocRemoveAnno(annoData.absAnno.getDocId(), annoData.absAnno.getPageId(), annoData.absAnno.getId());
                this.mAnnoAction.deleteAnno(annoData.absAnno, false);
            } else {
                this.restoreData(annoData);
            }
            if (this.annoDataNextStack.size() <= 0) {
                this.processNextStepStatus(false);
            }
            if (this.annoDataPreStack.size() <= 0) {
                this.processPreStepStatus(true);
            }
            this.annoDataPreStack.push(annoData);
        }
    }

    public void undoStep() {
        if (null == this.annoDataPreStack) {
            return;
        }
        if (this.annoDataPreStack.size() >= 1) {
            AnnoData annoData;
            this.bPreStep = true;
            if (this.annoDataPreStack.size() <= 1) {
                this.processPreStepStatus(false);
            }
            if ((annoData = this.annoDataPreStack.pop()).annoDataStatus == OnAnnoDataStatus.DEL) {
                this.restoreData(annoData);
            } else {
                this.mAnnoAction.onDocRemoveAnno(annoData.absAnno.getDocId(), annoData.absAnno.getPageId(), annoData.absAnno.getId());
                this.mAnnoAction.deleteAnno(annoData.absAnno, false);
            }
            if (null == this.annoDataNextStack) {
                this.annoDataNextStack = new Stack();
            }
            if (this.annoDataNextStack.size() <= 0) {
                this.processNextStepStatus(true);
            }
            this.annoDataNextStack.push(annoData);
        } else {
            this.processPreStepStatus(false);
        }
    }

    public void onSwitchDocOrPage(int docId, int pageId) {
        if (docId != this.nCurDocId || pageId != this.nCurPageId) {
            this.nCurDocId = docId;
            this.nCurPageId = pageId;
            this.resetStatus();
            if (null != this.onReAndUndoListener) {
                this.onReAndUndoListener.onSwitchDocOrPage();
            }
        }
    }

    public int getUndoStackSize() {
        return null == this.annoDataPreStack ? 0 : this.annoDataPreStack.size();
    }

    public int getRedoStackSize() {
        return null == this.annoDataNextStack ? 0 : this.annoDataNextStack.size();
    }

    private class AnnoData {
        private AbsAnno absAnno;
        private OnAnnoDataStatus annoDataStatus;

        public AnnoData(AbsAnno absAnno, OnAnnoDataStatus annoDataStatus) {
            this.absAnno = absAnno;
            this.annoDataStatus = annoDataStatus;
        }
    }
}

