/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.swf;

import android.graphics.RectF;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import com.gensee.pdu.IGSDocZoom;
import com.gensee.swf.ISwfCallback;
import com.gensee.swf.SwfPlayer;
import com.gensee.utils.GenseeLog;
import java.io.File;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GLSwfRender
implements GLSurfaceView.Renderer,
IGSDocZoom {
    private static final String TAG = "GLSwfRender";
    private SwfPlayer swfPlayer;
    private String szSwfUrl;
    private String szXmlUrl;
    private int fileID;
    private int aniStep;
    private long jniSwfPlayer = 0L;
    private OnOpenFileListener onOpenFileListener;
    private OnOpenglRenderMaxListener onOpenglRenderMaxListener;

    public GLSwfRender(ISwfCallback callback) {
        this.init(callback);
    }

    public void setDocPage(String szSwfUrl, String szXmlUrl, int aniStep, int fileID) {
        File f = new File(szXmlUrl);
        this.szSwfUrl = szSwfUrl;
        this.szXmlUrl = f.exists() ? szXmlUrl : "";
        this.aniStep = aniStep;
        this.fileID = fileID;
    }

    public boolean reOpenFile() {
        GenseeLog.i((String)TAG, (String)("reOpenFile swfPlayer = " + this.swfPlayer + " szSwfurl = " + this.szSwfUrl + " swfPlayer = " + this.jniSwfPlayer));
        boolean ret = false;
        if (this.jniSwfPlayer != 0L && (ret = this.openFile()) && this.aniStep >= 0) {
            this.goToAnimation(this.aniStep, false);
        }
        return ret;
    }

    public void closeFile() {
        GenseeLog.d((String)TAG, (String)"closeFile 0");
        if (this.jniSwfPlayer != 0L && this.swfPlayer.isFileLoad(this.jniSwfPlayer)) {
            GenseeLog.d((String)TAG, (String)"closeFile 1");
            this.swfPlayer.closeFile(this.jniSwfPlayer);
        }
    }

    private boolean openFile() {
        if (this.szSwfUrl == null || "".equals(this.szSwfUrl) || this.jniSwfPlayer == 0L) {
            return false;
        }
        String swfUrl = this.szSwfUrl;
        swfUrl = swfUrl == null ? "" : swfUrl;
        String animUrl = this.szXmlUrl;
        animUrl = animUrl == null ? "" : animUrl;
        GenseeLog.d((String)TAG, (String)("openFile swf = " + swfUrl + " anim = " + animUrl));
        boolean bOpenFile = false;
        if (this.jniSwfPlayer != 0L) {
            bOpenFile = this.swfPlayer.openFile(this.jniSwfPlayer, swfUrl, animUrl, this.fileID);
        }
        if (!bOpenFile) {
            if (null != this.onOpenFileListener) {
                this.onOpenFileListener.onOpenFileFailure(this.fileID);
            }
            GenseeLog.i((String)TAG, (String)"openFile failure");
        }
        return bOpenFile;
    }

    public void setBackgroundColor(int argb) {
        try {
            if (this.jniSwfPlayer != 0L) {
                this.swfPlayer.setBkColor(this.jniSwfPlayer, (argb & 0xFF0000) >> 16, (argb & 0xFF00) >> 8, argb & 0xFF);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void goToAnimation(int iFrame, boolean bAnimation) {
        this.aniStep = iFrame;
        GenseeLog.d((String)TAG, (String)("goToAnimation aniStep = " + this.aniStep + "  bAnimation = " + bAnimation));
        if (this.jniSwfPlayer != 0L && SwfPlayer.isLibLoaded()) {
            try {
                this.swfPlayer.gotoAnimation(this.jniSwfPlayer, iFrame, bAnimation);
            }
            catch (Throwable e) {
                e.printStackTrace();
                GenseeLog.w((String)TAG, (String)("goToAnimation " + e.getMessage()));
            }
        }
    }

    public void lockAspectRatio(boolean bLock) {
        this.swfPlayer.lockAspectRatio(this.jniSwfPlayer, bLock);
    }

    public void callOnTimer() {
        this.swfPlayer.callOnTimer(this.jniSwfPlayer);
    }

    private void init(ISwfCallback callback) {
        this.swfPlayer = new SwfPlayer();
        if (SwfPlayer.isLibLoaded()) {
            try {
                this.jniSwfPlayer = this.swfPlayer.createSwfPlayer(callback);
                GenseeLog.i((String)TAG, (String)"init createSwfPlayer swfplayer = 0");
                if (this.jniSwfPlayer != 0L) {
                    this.swfPlayer.initRender(this.jniSwfPlayer);
                    this.swfPlayer.enableBitmapFont(this.jniSwfPlayer, true);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                GenseeLog.i((String)TAG, (String)"createSwfPlayer failure");
            }
        }
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        GenseeLog.d((String)TAG, (String)("onSurfaceCreated swfPlayer = " + this.swfPlayer));
        int[] viewport = new int[2];
        GLES20.glGetIntegerv((int)3386, (int[])viewport, (int)0);
        if (null != this.onOpenglRenderMaxListener) {
            this.onOpenglRenderMaxListener.onOpenGlRenderMax(viewport[0], viewport[1]);
        }
        this.reOpenFile();
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        GenseeLog.d((String)TAG, (String)("onSurfaceChanged w = " + width + " h = " + height));
    }

    public void onDrawFrame(GL10 gl) {
        this.doDrawFrame();
    }

    @Override
    public void onDocBound(RectF rectF, int w, int h) {
        if (this.jniSwfPlayer != 0L) {
            this.swfPlayer.setViewPort(this.jniSwfPlayer, rectF.left, (float)h - rectF.top - rectF.height(), rectF.width(), rectF.height());
        }
    }

    public void doDrawFrame() {
        if (this.jniSwfPlayer != 0L) {
            this.swfPlayer.draw(this.jniSwfPlayer);
        }
    }

    public void destroy() {
        if (this.jniSwfPlayer != 0L) {
            this.swfPlayer.destorySwfPlayer(this.jniSwfPlayer);
            this.jniSwfPlayer = 0L;
        }
    }

    public int getFrameCount() {
        if (this.jniSwfPlayer != 0L) {
            return this.swfPlayer.getFrameCount(this.jniSwfPlayer);
        }
        return 0;
    }

    public int nextAnimation() {
        if (this.jniSwfPlayer != 0L) {
            return this.swfPlayer.nextAnimation(this.jniSwfPlayer);
        }
        return -1;
    }

    public void setLimitTextureCount(int val) {
        if (this.jniSwfPlayer != 0L) {
            this.swfPlayer.setLimitTextureCount(this.jniSwfPlayer, val);
        }
    }

    public void setOnOpenglRenderMaxListener(OnOpenglRenderMaxListener onOpenglRenderMaxListener) {
        this.onOpenglRenderMaxListener = onOpenglRenderMaxListener;
    }

    public void setOnOpenFileListener(OnOpenFileListener onOpenFileListener) {
        this.onOpenFileListener = onOpenFileListener;
    }

    public static interface OnOpenglRenderMaxListener {
        public void onOpenGlRenderMax(int var1, int var2);
    }

    public static interface OnOpenFileListener {
        public void onOpenFileFailure(int var1);
    }
}

