/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.RectF;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import com.gensee.pdu.IGSDocZoom;
import com.gensee.pdu.PduPage;
import com.gensee.swf.GLSwfRender;
import com.gensee.swf.ISwfCallback;
import com.gensee.utils.GenseeLog;
import java.lang.ref.WeakReference;

public class GSDocViewEx
extends GLSurfaceView
implements IGSDocZoom,
ISwfCallback,
GLSwfRender.OnOpenFileListener,
GLSwfRender.OnOpenglRenderMaxListener {
    private static final String TAG = "GSDocViewEx";
    private PduPage docPage;
    private GLSwfRender glViewRender;
    private DocViewExHanlder handler;
    private IDocExInterface docExInterface;
    private OnPageOpenListener onPageOpenListener;
    private OnOpenglRenderMaxListener onOpenglRenderMaxListener;

    public void setOnPageOpenListener(OnPageOpenListener onPageOpenListener) {
        this.onPageOpenListener = onPageOpenListener;
    }

    public GSDocViewEx(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public GSDocViewEx(Context context) {
        super(context);
        this.init(context);
    }

    public void setDocExInterface(IDocExInterface docExInterface) {
        this.docExInterface = docExInterface;
    }

    private void init(Context context) {
        this.handler = new DocViewExHanlder(this);
        if (!this.isInEditMode()) {
            this.glViewRender = new GLSwfRender(this);
            this.setEGLConfigChooser(8, 8, 8, 8, 8, 8);
            this.setRenderer(this.glViewRender);
            this.setRenderMode(0);
            this.glViewRender.setOnOpenFileListener(this);
            this.glViewRender.setOnOpenglRenderMaxListener(this);
        }
    }

    private void docPageAnimation(final PduPage pduPage) {
        if (pduPage == null || !pduPage.isPrepare()) {
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GSDocViewEx.this.glViewRender.goToAnimation(pduPage.getAniStep(), true);
            }
        });
    }

    private void setDocPage(PduPage d) {
        if (d == null || !d.isPrepare()) {
            GenseeLog.w((String)"GSDocViewEx setDocPage page is unPrepared");
            return;
        }
        this.docPage = d;
        d.setRefreshAnnos(false);
        GenseeLog.d((String)TAG, (String)("setDocPage aniStep = " + d.getAniStep() + " fileId = " + d.hashCode()));
        this.glViewRender.setDocPage(d.getPath(), d.getAnimationPath(), d.getAniStep(), d.hashCode());
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (GSDocViewEx.this.docPage != null) {
                    GSDocViewEx.this.glViewRender.reOpenFile();
                    GSDocViewEx.this.requestRender();
                }
            }
        });
    }

    private void callOnTimer() {
        this.glViewRender.callOnTimer();
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void onResume() {
        super.onResume();
        if (null != this.docPage && null != this.glViewRender) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    PduPage p = GSDocViewEx.this.docPage;
                    if (p != null) {
                        GSDocViewEx.this.glViewRender.goToAnimation(p.getAniStep(), false);
                    }
                }
            });
        }
    }

    public void setBackgroundColor(final int argb) {
        super.setBackgroundColor(argb);
        if (!this.isInEditMode()) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    GSDocViewEx.this.glViewRender.setBackgroundColor(argb);
                    GSDocViewEx.this.requestRender();
                }
            });
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0 && null != this.docPage && null != this.glViewRender) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    PduPage p = GSDocViewEx.this.docPage;
                    if (p != null && GSDocViewEx.this.glViewRender != null) {
                        GSDocViewEx.this.glViewRender.goToAnimation(p.getAniStep(), false);
                    }
                }
            });
        }
    }

    public void destroy() {
        this.setOnPageOpenListener(null);
        this.glViewRender.destroy();
    }

    public void closeDoc() {
        this.glViewRender.closeFile();
        this.docPage = null;
    }

    @Override
    public void onDocBound(final RectF rectF, final int w, final int h) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GSDocViewEx.this.glViewRender.onDocBound(rectF, w, h);
                GSDocViewEx.this.requestRender();
            }
        });
    }

    @Override
    public void onBeginDraw() {
    }

    @Override
    public void onEndDraw() {
    }

    @Override
    public void onSetTimer() {
        this.handler.sendEmptyMessage(143);
    }

    @Override
    public void onKillTimer() {
        this.handler.removeMessages(143);
    }

    @Override
    public void onNeedDraw() {
        this.requestRender();
    }

    @Override
    public void onOpenComplete(int fileID) {
        PduPage p = this.docPage;
        if (p != null) {
            GenseeLog.d((String)TAG, (String)("onOpenComplete hasCode = " + p.hashCode() + " fileId = " + fileID));
            if (p.hashCode() == fileID) {
                p.setFrameCount(this.glViewRender.getFrameCount());
                p.setRefreshAnnos(true);
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        PduPage page = GSDocViewEx.this.docPage;
                        if (page != null) {
                            GSDocViewEx.this.glViewRender.goToAnimation(page.getAniStep(), true);
                        }
                    }
                });
            }
        }
        if (null != this.docExInterface) {
            this.docExInterface.onDocOpenComplete();
        }
        if (null != this.onPageOpenListener) {
            this.onPageOpenListener.onPageOpenComplete(fileID, this.glViewRender.getFrameCount());
        }
    }

    public int nextAnimation() {
        return this.glViewRender.nextAnimation();
    }

    public void setLimitTextureCount(int val) {
        this.glViewRender.setLimitTextureCount(val);
    }

    @Override
    public void onOpenFileFailure(int fileId) {
        if (null != this.onPageOpenListener) {
            this.onPageOpenListener.onPageOpenFileFailure(fileId);
        }
    }

    public void resetDocPage() {
        this.docPage = null;
    }

    @Override
    public void onOpenGlRenderMax(int maxWidth, int maxHeight) {
        if (null != this.onOpenglRenderMaxListener) {
            this.onOpenglRenderMaxListener.onOpenGlRenderMax(maxWidth, maxHeight);
        }
    }

    public void setOnOpenglRenderMaxListener(OnOpenglRenderMaxListener onOpenglRenderMaxListener) {
        this.onOpenglRenderMaxListener = onOpenglRenderMaxListener;
    }

    public static interface OnOpenglRenderMaxListener {
        public void onOpenGlRenderMax(int var1, int var2);
    }

    private static class DocViewExHanlder
    extends Handler {
        private WeakReference<GSDocViewEx> docViewEx;

        public DocViewExHanlder(GSDocViewEx docView) {
            this.docViewEx = new WeakReference<GSDocViewEx>(docView);
        }

        public void handleMessage(Message msg) {
            final GSDocViewEx view = (GSDocViewEx)this.docViewEx.get();
            if (view == null) {
                GenseeLog.w((String)GSDocViewEx.TAG, (String)("handleMessage view = " + view));
                return;
            }
            switch (msg.what) {
                case 140: {
                    PduPage p1 = view.docPage;
                    GenseeLog.i((String)GSDocViewEx.TAG, (String)("DOC_CMD_CONTENT_REC pdupage = " + msg.obj + " docPage = " + (null == p1 ? "null" : p1.toString())));
                }
                case 138: {
                    PduPage p = view.docPage;
                    if (!msg.obj.equals(p)) {
                        view.setDocPage((PduPage)msg.obj);
                        break;
                    }
                    GenseeLog.e((String)GSDocViewEx.TAG, (String)("handleMessage obj equal p pdupage = " + p));
                    break;
                }
                case 142: {
                    view.docPageAnimation((PduPage)msg.obj);
                    break;
                }
                case 143: {
                    view.queueEvent(new Runnable(){

                        @Override
                        public void run() {
                            view.callOnTimer();
                            DocViewExHanlder.this.sendEmptyMessageDelayed(143, 33L);
                        }
                    });
                }
            }
        }
    }

    public static interface OnPageOpenListener {
        public void onPageOpenFileFailure(int var1);

        public void onPageOpenComplete(int var1, int var2);
    }

    public static interface IDocExInterface {
        public void onDocOpenComplete();
    }
}

