/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.gensee.doc.AnnoInputMode;
import com.gensee.doc.CtrlMode;
import com.gensee.doc.DrawMode;
import com.gensee.doc.LINE_SIZE;
import com.gensee.doc.OnAnnoDataListener;
import com.gensee.doc.OnAnnoEraseUserIdListener;
import com.gensee.doc.OnDocViewEventListener;
import com.gensee.pdu.AnnoAction;
import com.gensee.pdu.DocViewImpl;
import com.gensee.pdu.IGSDocView;
import com.gensee.pdu.OnReAndUndoListener;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewEx;
import com.gensee.view.GSPduTextureView;
import com.gensee.view.GSPduView;
import java.lang.ref.SoftReference;

public class GSDocViewGx
extends FrameLayout
implements GSDocViewEx.OnOpenglRenderMaxListener {
    private static int PDU_VIEW_TYPE = 0;
    private static final String TAG = "GSDocViewGx";
    private GSDocViewEx glDocView;
    private IGSDocView pduView;
    private Handler docViewHandler;
    private Handler glDocViewHandler;
    private MyHandler handler;

    public Handler getHandler() {
        return this.handler;
    }

    public GSDocViewGx(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public GSDocViewGx(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public GSDocViewGx(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.handler = new MyHandler(this);
        this.removeAllViews();
        this.glDocView = new GSDocViewEx(context);
        this.addView((View)this.glDocView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.glDocViewHandler = this.glDocView.getHandler();
        if (PDU_VIEW_TYPE == 0) {
            this.pduView = new GSPduView(context);
            ((GSPduView)this.pduView).setDocZoomer(this.glDocView);
        } else {
            this.pduView = new GSPduTextureView(context);
            ((GSPduTextureView)this.pduView).setDocZoomer(this.glDocView);
        }
        this.addView((View)this.pduView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.glDocView.setDocExInterface((GSDocViewEx.IDocExInterface)((Object)this.pduView));
        this.docViewHandler = this.pduView.getHandler();
        this.glDocView.setOnOpenglRenderMaxListener(this);
    }

    public void setBackgroundColor(int argb) {
        super.setBackgroundColor(argb);
        this.glDocView.setBackgroundColor(argb);
    }

    public void forbidZoomGestrue(boolean isFobid) {
        this.pduView.forbidZoomGestrue(isFobid);
    }

    public void setTouchforbidden(boolean isTouchforbidden) {
        this.pduView.setTouchforbidden(isTouchforbidden);
    }

    public void setOnDocViewClickedListener(OnDocViewEventListener l) {
        this.pduView.setOnDocViewClickedListener(l);
    }

    public void showAdaptViewWidth() {
        this.pduView.showAdaptViewWidth();
    }

    public void showAdaptViewHeight() {
        this.pduView.showAdaptViewHeight();
    }

    public void showFillView() {
        this.pduView.showFillView();
    }

    public void showAdaptView() {
        this.pduView.showAdaptView();
    }

    public void showSourceScall() {
        this.pduView.showSourceScall();
    }

    public void showAdaptViewWidthAlignTop() {
        this.pduView.showAdaptViewWidthAlignTop();
    }

    public void showAdaptViewHeightAlignLeft() {
        this.pduView.showAdaptViewHeightAlignLeft();
    }

    public void onResume() {
        this.glDocView.onResume();
    }

    public void onPause() {
        this.glDocView.onPause();
    }

    public void onUpdate() {
        this.pduView.onUpdate();
    }

    public void destroy() {
        this.glDocView.setDocExInterface(null);
        this.glDocView.setOnPageOpenListener(null);
        if (PDU_VIEW_TYPE == 0) {
            ((GSPduView)this.pduView).setDocZoomer(null);
        } else {
            ((GSPduTextureView)this.pduView).setDocZoomer(null);
        }
        this.glDocView.destroy();
    }

    public void setDefImg(Bitmap bitmap, boolean isFillView) {
        this.pduView.setDefImg(bitmap, isFillView);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.glDocView.setVisibility(visibility);
    }

    public void setGlVisible(boolean bVisible) {
        if (bVisible) {
            this.glDocView.setVisibility(0);
        } else {
            this.glDocView.setVisibility(4);
        }
    }

    public void closeDoc() {
        this.glDocView.closeDoc();
        this.pduView.clear();
        this.pduView.reset();
    }

    public void resetDocPage() {
        this.glDocView.resetDocPage();
    }

    public void setZOrderOnTop(boolean onTop) {
        this.glDocView.setZOrderOnTop(onTop);
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.glDocView.setZOrderMediaOverlay(isMediaOverlay);
    }

    public void setOnPageOpenListener(GSDocViewEx.OnPageOpenListener onPageOpenListener) {
        this.glDocView.setOnPageOpenListener(onPageOpenListener);
    }

    public boolean isDragScale() {
        return this.pduView.isDragScale();
    }

    public void setPaintColor(int color) {
        this.pduView.setPaintColor(color);
    }

    public void undo(long ownerId) {
        this.pduView.undo(ownerId);
    }

    public void setStrokeWidth(LINE_SIZE width) {
        this.pduView.setStrokeWidth(width);
    }

    public void setAnnoMakeType(DrawMode mode) {
        this.pduView.setAnnoMakeType(mode);
    }

    public void eraseAll() {
        this.pduView.eraseAll();
    }

    public void setCtrlMode(CtrlMode mode) {
        this.pduView.setCtrlMode(mode);
    }

    public void setAnnoAction(AnnoAction action) {
        this.pduView.setAnnoAction(action);
    }

    public int nextAnimation() {
        return this.glDocView.nextAnimation();
    }

    public void setLimitTextureCount(int val) {
        this.glDocView.setLimitTextureCount(val);
    }

    public void setOnAnnoDataListener(OnAnnoDataListener onAnnoDataListener) {
        this.pduView.setOnAnnoDataListener(onAnnoDataListener);
    }

    public void setOnAnnoEraseUserIdListener(OnAnnoEraseUserIdListener onAnnoEraseUserIdListener) {
        this.pduView.setOnAnnoEraseUserIdListener(onAnnoEraseUserIdListener);
    }

    @Override
    public void onOpenGlRenderMax(int maxWidth, int maxHeight) {
        if (null != this.pduView && this.pduView instanceof GSPduView) {
            ((GSPduView)this.pduView).setMaxRectWidth(maxWidth);
            ((GSPduView)this.pduView).setMaxRectHeight(maxHeight);
        }
    }

    public void setOnDocLabelListener(DocViewImpl.OnDocLabelListener onDocLabelListener) {
        this.pduView.setOnDocLabelListener(onDocLabelListener);
    }

    public void redoStep() {
        this.pduView.redoStep();
    }

    public void undoStep() {
        this.pduView.undoStep();
    }

    public int getRedoStackSize() {
        return this.pduView.getRedoStackSize();
    }

    public int getUndoStackSize() {
        return this.pduView.getUndoStackSize();
    }

    public void setOnReAndUndoListener(OnReAndUndoListener onReAndUndoListener) {
        this.pduView.setOnReAndUndoListener(onReAndUndoListener);
    }

    public void resetStatus() {
        this.pduView.resetStatus();
    }

    public void setEndAnimation(boolean endAnimation) {
        this.pduView.setEndAnimation(endAnimation);
    }

    public void setThirdPartyMotionEvent(MotionEvent motionEvent) {
        this.pduView.setThirdPartyMotionEvent(motionEvent);
    }

    public void setAnnoInputMode(AnnoInputMode annoInputMode) {
        this.pduView.setAnnoInputMode(annoInputMode);
    }

    private static class MyHandler
    extends Handler {
        private SoftReference<GSDocViewGx> docViewGxRef;

        public MyHandler(GSDocViewGx gsDocViewGx) {
            this.docViewGxRef = new SoftReference<GSDocViewGx>(gsDocViewGx);
        }

        public void handleMessage(Message msg) {
            GSDocViewGx docViewGx = this.docViewGxRef.get();
            if (docViewGx == null) {
                GenseeLog.w((String)GSDocViewGx.TAG, (String)("docViewGx is null,but handle msg " + msg == null ? "null" : "" + msg.what));
                return;
            }
            Handler glDocViewHandler = docViewGx.glDocViewHandler;
            Handler docViewHandler = docViewGx.docViewHandler;
            switch (msg.what) {
                case 140: {
                    glDocViewHandler.sendMessage(glDocViewHandler.obtainMessage(140, msg.obj));
                    docViewHandler.sendMessage(docViewHandler.obtainMessage(140, msg.obj));
                    break;
                }
                case 138: {
                    glDocViewHandler.sendMessage(glDocViewHandler.obtainMessage(138, msg.obj));
                    docViewHandler.sendMessage(docViewHandler.obtainMessage(138, msg.obj));
                    break;
                }
                case 135: {
                    docViewHandler.sendEmptyMessage(135);
                    break;
                }
                case 136: {
                    docViewHandler.sendMessage(docViewHandler.obtainMessage(136, msg.obj));
                    break;
                }
                case 141: {
                    docViewHandler.sendEmptyMessage(141);
                    break;
                }
                case 142: {
                    glDocViewHandler.sendMessage(glDocViewHandler.obtainMessage(142, msg.obj));
                    break;
                }
                case 144: {
                    docViewHandler.sendEmptyMessage(144);
                    break;
                }
                case 145: {
                    docViewHandler.sendEmptyMessage(145);
                    break;
                }
                case 146: {
                    GSDocViewGx gx = this.docViewGxRef.get();
                    if (null == gx || null == gx.glDocView) break;
                    gx.glDocView.closeDoc();
                }
            }
        }
    }
}

