/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.as;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.WindowManager;
import com.gensee.as.AsDataInfo;
import com.gensee.as.AsSendImpl;
import com.gensee.as.OnAsServiceListener;
import com.gensee.callback.IAsCallBack;
import com.gensee.room.AbsModule;
import com.gensee.room.RTRoom;
import com.gensee.routine.IRTEvent;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.RTLog;

public class AsEventImpl
extends AbsModule
implements IRTEvent.IAsEvent,
OnAsServiceListener {
    private static final String TAG = AsEventImpl.class.getSimpleName();
    private boolean isAsPlaying = false;
    private IAsCallBack asCallBack;
    private AsDataInfo sendDataInfo;
    private AsSendImpl mAsSendImpl;
    private boolean isSelfAsPlaying = false;
    private Bitmap mBitmapVideoPng;
    private int nVideoPngMarginTop;
    private int nVideoPngMarginRight;
    private int nWidth;
    private int nHeight;
    private long asSinkHandle;
    private OnAsServiceListener mOnAsServiceListener;

    public void setAsCallBack(IAsCallBack asCallBack) {
        this.asCallBack = asCallBack;
    }

    @Override
    public void onAsJoinConfirm(boolean ok) {
        RTLog.i((String)TAG, (String)("onAsJoinConfirm bRet " + ok));
        if (null != this.asCallBack) {
            this.asCallBack.onAsJoinConfirm(ok);
        }
        this.onAsRePublish();
    }

    @Override
    public void onAsBegin(long owner) {
        RTLog.i((String)TAG, (String)("onAsBegin owner " + owner));
        if (this.isSelfAsPlaying && owner == -1L) {
            return;
        }
        this.isSelfAsPlaying = owner == RTRoom.getIns().getUserId();
        this.isAsPlaying = true;
        if (null != this.asCallBack) {
            this.asCallBack.onAsBegin(owner);
        }
        if (null != this.mAsSendImpl && this.isSelfAsPlaying) {
            this.mAsSendImpl.onAsBegin();
        }
    }

    @Override
    public void onAsEnd() {
        RTLog.i((String)TAG, (String)"onAsEnd ");
        this.isSelfAsPlaying = false;
        this.isAsPlaying = false;
        if (null != this.asCallBack) {
            this.asCallBack.onAsEnd();
        }
    }

    @Override
    public void onAsData(byte[] data, int width, int height) {
        if (width > 0 && height > 0) {
            this.nWidth = width;
            this.nHeight = height;
        }
        if (this.asCallBack != null) {
            this.asCallBack.onAsData(data, this.nWidth, this.nHeight);
        }
    }

    public AsDataInfo onAsCapture() {
        GenseeLog.d((String)TAG, (String)"onAsCapture ");
        return this.sendDataInfo;
    }

    public boolean sendAsData(byte[] rgb16, int width, int height) {
        GenseeLog.d((String)TAG, (String)"sendAsData ");
        if (this.sendDataInfo == null) {
            this.sendDataInfo = new AsDataInfo(width, height, rgb16, 0);
        } else {
            this.sendDataInfo.update(width, height, rgb16, 0);
        }
        return true;
    }

    @Override
    protected String onGetLogTag() {
        return TAG;
    }

    @Override
    public boolean isAsPlaying() {
        return this.isAsPlaying;
    }

    @Override
    public boolean isSelfAsPlaying() {
        return this.isSelfAsPlaying;
    }

    @Override
    public void onAsPushModeBegin(long asSinkHandle) {
        GenseeLog.d((String)TAG, (String)("onAsPushModeBegin asSinkHandle = " + asSinkHandle));
        this.asSinkHandle = asSinkHandle;
        if (null != this.mAsSendImpl) {
            this.mAsSendImpl.onAsPushModeBegin();
        }
    }

    @Override
    public void onAsPushModeEnd(long asSinkHandle) {
        GenseeLog.d((String)TAG, (String)("onAsPushModeEnd asSinkHandle = " + asSinkHandle));
        this.asSinkHandle = 0L;
        if (null != this.mAsSendImpl) {
            this.mAsSendImpl.onAsPushModeEnd();
        }
    }

    @Override
    public void onAsPushModeForceKey(long asSinkHandle) {
        GenseeLog.d((String)TAG, (String)("onAsPushModeForceKey asSinkHandle = " + asSinkHandle));
    }

    public boolean pushAsData(byte[] data, int fps, int fmtType, int width, int height, OnTaskRet taskRet) {
        if (this.asSinkHandle != 0L) {
            RTRoom.getIns().getRoutine().asPushModeData(data, fmtType, width, height, fps, this.asSinkHandle, taskRet);
            return true;
        }
        return false;
    }

    public void asBegin(Activity activity) {
        if (null == this.mAsSendImpl) {
            this.mAsSendImpl = new AsSendImpl();
            this.mAsSendImpl.setOnAsServiceListener(this);
        }
        if (null != this.mBitmapVideoPng && !this.mBitmapVideoPng.isRecycled()) {
            this.mAsSendImpl.setVideoDataPng(this.mBitmapVideoPng, this.nVideoPngMarginTop, this.nVideoPngMarginRight);
        }
        this.mAsSendImpl.startAsProjection(activity);
    }

    public void asEnd() {
        if (this.isSelfAsPlaying) {
            if (null != this.mAsSendImpl) {
                this.mAsSendImpl.stopAsProjection();
            }
            this.isSelfAsPlaying = false;
        } else {
            RTRoom.getIns().getRoutine().asEnd(null);
        }
    }

    public void asEndConfirm() {
        if (null != this.mAsSendImpl) {
            this.mAsSendImpl.stopAsConfirm();
        }
    }

    public void asAddFloatWindowView(View windowView, WindowManager.LayoutParams wLayoutParams) {
        if (null == this.mAsSendImpl) {
            this.mAsSendImpl = new AsSendImpl();
            this.mAsSendImpl.setOnAsServiceListener(this);
        }
        this.mAsSendImpl.asAddFloatWindowView(windowView, wLayoutParams);
    }

    public void asDestroy() {
        if (null != this.mAsSendImpl) {
            this.mAsSendImpl.destroyAsProjection();
        }
        this.mBitmapVideoPng = null;
        this.mAsSendImpl = null;
    }

    public void setVideoDataPng(Bitmap mBitmap, int desVideoLogoMarginTop, int desVideoLogoMarginRight) {
        this.mBitmapVideoPng = mBitmap;
        this.nVideoPngMarginTop = desVideoLogoMarginTop;
        this.nVideoPngMarginRight = desVideoLogoMarginRight;
        if (null != this.mAsSendImpl) {
            this.mAsSendImpl.setVideoDataPng(mBitmap, desVideoLogoMarginTop, desVideoLogoMarginRight);
        }
    }

    public void setAsHardEncode(boolean bAsHardEncode) {
        if (null == this.mAsSendImpl) {
            this.mAsSendImpl = new AsSendImpl();
            this.mAsSendImpl.setOnAsServiceListener(this);
        }
        this.mAsSendImpl.setAsHardEncode(bAsHardEncode);
    }

    public void onRoomReconnecting() {
        this.asSinkHandle = 0L;
        GenseeLog.d((String)TAG, (String)("onRoomReconnecting asSinkHandle = " + this.asSinkHandle));
        if (null != this.mAsSendImpl) {
            this.mAsSendImpl.onAsPushModeEnd();
        }
    }

    public void onAsRePublish() {
        if (null != this.mAsSendImpl && this.isSelfAsPlaying) {
            this.mAsSendImpl.startAsProjection(null);
        }
    }

    public void setOnAsServiceListener(OnAsServiceListener mOnAsServiceListener) {
        this.mOnAsServiceListener = mOnAsServiceListener;
    }

    @Override
    public void showAsStopConfirmDialog(Context mServiceContext) {
        if (null != this.mOnAsServiceListener) {
            this.mOnAsServiceListener.showAsStopConfirmDialog(mServiceContext);
        }
    }

    @Override
    public void onAsRotationChanged(int rotation) {
        if (null != this.mOnAsServiceListener) {
            this.mOnAsServiceListener.onAsRotationChanged(rotation);
        }
    }

    public void leave() {
        if (this.isSelfAsPlaying) {
            this.asEnd();
        }
    }
}

