/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.audio;

import android.content.Context;
import com.gensee.callback.IAudioCallBack;
import com.gensee.common.GenseeConfig;
import com.gensee.media.BlueToother;
import com.gensee.room.AbsModule;
import com.gensee.routine.IRTEvent;
import com.gensee.routine.IRoutine;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.ThreadPool;

public class AudioEventImpl
extends AbsModule
implements IRTEvent.IAudioEvent {
    private static final String TAG = "AudioEventImpl";
    private Context appContext;
    private IAudioCallBack audioCallBack;

    public void setAudioCallBack(IAudioCallBack audioCallBack) {
        this.audioCallBack = audioCallBack;
    }

    @Override
    public void onRoomData(String key, long value, long userId) {
        this.localUserId = userId;
    }

    private void onAudioLevel(long userId, int level) {
        if (null != this.audioCallBack) {
            this.audioCallBack.onAudioLevel(level, userId);
        }
    }

    @Override
    public void onAudioJoinConfirm(boolean ok) {
        GenseeLog.d((String)TAG, (String)("onAudioJoinConfirm ok = " + ok));
        if (null != this.audioCallBack) {
            this.audioCallBack.onAudioJoinConfirm(ok);
        }
    }

    @Override
    public void onAudioMicAvailable(boolean isAvailable) {
        GenseeLog.d((String)TAG, (String)("onAudioMicAvailable isAvailable = " + isAvailable));
        if (null != this.audioCallBack) {
            this.audioCallBack.onAudioMicAvailable(isAvailable);
        }
    }

    @Override
    public void onAudioMicOpened() {
        GenseeLog.d((String)TAG, (String)"onAudioMicOpened");
        if (null != this.audioCallBack) {
            this.audioCallBack.onAudioMicOpened();
        }
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                BlueToother.getIns().init(AudioEventImpl.this.appContext.getApplicationContext(), 2);
            }
        });
    }

    @Override
    public void onAudioMicClosed() {
        GenseeLog.d((String)TAG, (String)"onAudioMicClosed ");
        if (null != this.audioCallBack) {
            this.audioCallBack.onAudioMicClosed();
        }
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                BlueToother.getIns().release(2);
            }
        });
    }

    @Override
    public void onAudioMicLevel(short level) {
        GenseeLog.v((String)TAG, (String)("onAudioMicLevel level = " + level));
        this.onAudioLevel(this.localUserId, level);
    }

    @Override
    public void onAudioMicVolume(short vol) {
        GenseeLog.d((String)TAG, (String)("onAudioMicVolume vol = " + vol));
    }

    @Override
    public void onAudioSpeakerAvailable(boolean isAvailable) {
        GenseeLog.d((String)TAG, (String)("onAudioSpeakerAvailable isAvailable = " + isAvailable));
        IRoutine routine = this.getRoutine();
        if (!GenseeConfig.isCloseSpeakerDefault && isAvailable && routine != null) {
            boolean ret = routine.audioOpenSpeaker(null);
            GenseeLog.d((String)TAG, (String)("onAudioSpeakerAvailable audioOpenSpeaker ret " + ret));
        }
    }

    @Override
    public void onAudioSpeakerOpened() {
        GenseeLog.d((String)TAG, (String)"onAudioSpeakerOpened");
        if (null != this.audioCallBack) {
            this.audioCallBack.onAudioSpeakerOpened();
        }
    }

    @Override
    public void onAudioSpeakerClosed() {
        GenseeLog.d((String)TAG, (String)"onAudioSpeakerClosed");
        if (null != this.audioCallBack) {
            this.audioCallBack.onAudioSpeakerClosed();
        }
    }

    @Override
    public void onAudioSpeakerLevel(short level) {
    }

    @Override
    public void onAudioSpeakerLevel(short level, long userId) {
        GenseeLog.v((String)TAG, (String)("onAudioSpeakerLevel level = " + level + " userId = " + userId));
        this.onAudioLevel(userId, level);
    }

    @Override
    public void onAudioSpeakerVolume(short vol) {
        GenseeLog.d((String)TAG, (String)("onAudioSpeakerVolume vol = " + vol));
    }

    @Override
    public Context onGetContext() {
        Context c;
        if (this.appContext != null) {
            return this.appContext;
        }
        if (null != this.audioCallBack && (c = this.audioCallBack.onGetContext()) != null) {
            return c.getApplicationContext();
        }
        GenseeLog.w((String)TAG, (String)"onGetContext context is null");
        return null;
    }

    public void setContext(Context context) {
        this.appContext = context.getApplicationContext();
    }

    @Override
    protected String onGetLogTag() {
        return TAG;
    }

    @Override
    public void onAudioStreamPlayStatus(int status) {
        GenseeLog.d((String)TAG, (String)("OnAudioStreamPlayStatus status = " + status));
    }

    @Override
    public void release() {
        this.appContext = null;
    }
}

