/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.doc;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.SystemClock;
import com.gensee.callback.IDocCallBack;
import com.gensee.doc.IDocModule;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.AnnoAction;
import com.gensee.pdu.AnnoCleaner;
import com.gensee.pdu.AnnoFPoint;
import com.gensee.pdu.AnnoFreepenEx;
import com.gensee.pdu.GSDocView;
import com.gensee.pdu.PduDoc;
import com.gensee.pdu.PduPage;
import com.gensee.room.AbsModule;
import com.gensee.routine.IRTEvent;
import com.gensee.routine.IRoutine;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.AbsTaskRet;
import com.gensee.taskret.OnTaskRet;
import com.gensee.user.UserManager;
import com.gensee.utils.FileUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewGx;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class DocEventImpl
extends AbsModule
implements IRTEvent.IDocEvent,
AnnoAction,
IDocModule {
    private static final int TIMELONG = 3000;
    private long nJoinConfirmTime = 0L;
    private static final String TAG = "DocEventImpl";
    private int mPhotoCount = 0;
    private GSDocView mDocView;
    private GSDocViewGx mGlDocView;
    private List<PduDoc> docs = new ArrayList<PduDoc>(0);
    private PduDoc mCurDoc;
    private int annoTmpUserId;
    private long lastAnnoReceiveTime = 0L;
    private IDocCallBack mDocCallBack;
    private volatile long annoTmpId = 1000L;

    public static void initPageCachDir(Context c) {
        PduPage.setFileDir((String)FileUtil.getCachDir((Context)c, (String)"rtsdk"));
    }

    public void setDocView(GSDocView docView) {
        GenseeLog.d((String)TAG, (String)("setDocView docView = " + docView));
        GSDocView preView = this.mDocView;
        this.mDocView = docView;
        if (this.mDocView != null) {
            PduPage p;
            this.setHandler(this.mDocView.getHandler());
            this.mDocView.setAnnoAction((AnnoAction)this);
            if (this.mCurDoc != null && (p = this.mCurDoc.getCurPage()) != null) {
                this.sendMessage(138, p);
            }
        } else {
            this.setHandler(null);
        }
        if (preView != null && !preView.equals(this.mDocView)) {
            preView.getHandler().sendEmptyMessage(145);
        }
    }

    public void setDocViewGx(GSDocViewGx glDocViewGroup) {
        GenseeLog.d((String)TAG, (String)("setDocViewGx docView = " + glDocViewGroup));
        GSDocViewGx preView = this.mGlDocView;
        this.mGlDocView = glDocViewGroup;
        if (this.mGlDocView != null) {
            PduPage p;
            this.mGlDocView.setAnnoAction((AnnoAction)this);
            GenseeLog.d((String)TAG, (String)("setDocViewGx docHandler = " + this.mGlDocView.getHandler()));
            this.setHandler(this.mGlDocView.getHandler());
            if (this.mCurDoc != null && (p = this.mCurDoc.getCurPage()) != null) {
                this.sendMessage(138, p);
            }
        } else {
            this.setHandler(null);
        }
        if (preView != null && !preView.equals(this.mGlDocView)) {
            preView.getHandler().sendEmptyMessage(145);
        }
    }

    public void setDocCallbak(IDocCallBack docCallBack) {
        this.mDocCallBack = docCallBack;
    }

    @Override
    public List<PduDoc> getDocs() {
        return this.docs;
    }

    @Override
    public PduDoc getCurrentDoc() {
        return this.mCurDoc;
    }

    @Override
    public boolean isCurrentDoc(PduDoc doc) {
        if (doc == null || this.mCurDoc == null) {
            return false;
        }
        return doc.getDocId() == this.mCurDoc.getDocId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PduDoc changeCurDoc(int index) {
        List<PduDoc> list = this.docs;
        synchronized (list) {
            PduDoc o;
            if (index < this.docs.size() && (o = this.docs.get(index)) instanceof PduDoc) {
                this.mCurDoc = o;
                return this.mCurDoc;
            }
        }
        return null;
    }

    @Override
    public void gotoPage(PduPage page, boolean syn, OnTaskRet taskRet) {
        IRoutine routine = this.getRoutine();
        if (page == null || routine == null) {
            if (taskRet != null) {
                taskRet.onTaskRet(false, 0, "switchPage");
            }
            GenseeLog.w((String)TAG, (String)("gotoPage page = " + page + " routine = " + routine));
            return;
        }
        this.sendMessage(138, page);
        routine.docGotoPage(page.getDocId(), page.getPageId(), syn, taskRet);
    }

    @Override
    public void gotoAnimation(PduPage page, int nAniStep, boolean syn, OnTaskRet taskRet) {
        IRoutine routine = this.getRoutine();
        if (page == null || routine == null) {
            if (taskRet != null) {
                taskRet.onTaskRet(false, 0, "gotoAnimation");
            }
            return;
        }
        routine.docGotoAnimation(page.getDocId(), page.getPageId(), nAniStep, syn, taskRet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PduDoc getDocById(int docId) {
        if (this.mCurDoc != null && this.mCurDoc.getDocId() == docId) {
            return this.mCurDoc;
        }
        List<PduDoc> list = this.docs;
        synchronized (list) {
            for (PduDoc o : this.docs) {
                PduDoc doc;
                if (!(o instanceof PduDoc) || (doc = o) == null || doc.getDocId() != docId) continue;
                return doc;
            }
        }
        return null;
    }

    private void onAnnoAdd(AbsAnno anno) {
        if (anno == null) {
            return;
        }
        if (this.mCurDoc != null && this.mCurDoc.getDocId() == anno.getDocId()) {
            long time = System.currentTimeMillis();
            long timeLag = time - this.lastAnnoReceiveTime;
            this.lastAnnoReceiveTime = time;
            int nAnnoFlag = this.mCurDoc.addAnno(anno);
            if (!this.isCurPagePrepared()) {
                return;
            }
            if (nAnnoFlag != -1) {
                if (anno instanceof AnnoFreepenEx) {
                    if (timeLag < 10L) {
                        this.removeMessages(136);
                    }
                    this.sendMessageDelayed(136, anno, 100L);
                } else if (nAnnoFlag == 0) {
                    this.sendMessage(136, anno);
                } else if (nAnnoFlag == 1) {
                    this.sendMessage(141, anno);
                }
            }
            return;
        }
        PduDoc doc = this.getDocById(anno.getDocId());
        if (doc != null) {
            doc.addAnno(anno);
        }
    }

    private void onClean(AbsAnno cleaner) {
        if (cleaner == null) {
            return;
        }
        if (this.mCurDoc != null && this.mCurDoc.getDocId() == cleaner.getDocId()) {
            if (this.mCurDoc.delAnno(cleaner)) {
                if (!this.isCurPagePrepared()) {
                    return;
                }
                this.sendMessage(144, null);
            }
            return;
        }
        PduDoc doc = this.getDocById(cleaner.getDocId());
        if (doc != null) {
            doc.delAnno(cleaner);
        }
    }

    private void onPoint(AbsAnno p) {
        if (p == null) {
            return;
        }
        GenseeLog.d((String)TAG, (String)("onPoint p = " + p));
        if (this.mCurDoc != null && this.mCurDoc.getDocId() == p.getDocId()) {
            if (this.mCurDoc.changePoint(p)) {
                if (!this.isCurPagePrepared()) {
                    return;
                }
                this.removeMessages(135);
                this.sendMessage(135, null);
            }
            return;
        }
        PduDoc doc = this.getDocById(p.getDocId());
        if (doc != null) {
            doc.changePoint(p);
        }
    }

    public boolean sendAnno(final AbsAnno anno, final OnTaskRet onTaskRet) {
        AnnoFreepenEx annoFreepenEx;
        IRoutine routine = this.getRoutine();
        if (this.mCurDoc == null || routine == null) {
            return false;
        }
        anno.setDocId(this.mCurDoc.getDocId());
        UserInfo self = UserManager.getIns().getMyUserInfo();
        if (null != self) {
            anno.setOwner(self.getId());
        }
        AbsAnno newAnnoFreepenEx = anno;
        if (anno instanceof AnnoFreepenEx && (annoFreepenEx = (AnnoFreepenEx)anno).getStepType() == 1) {
            ++this.annoTmpId;
            if (this.annoTmpId >= Long.MAX_VALUE) {
                this.annoTmpId = 1000L;
            }
            anno.setId(this.annoTmpId);
            GenseeLog.d((String)TAG, (String)("sendAnno copy anno = " + anno));
            newAnnoFreepenEx = new AnnoFreepenEx();
            newAnnoFreepenEx.setType(anno.getType());
            newAnnoFreepenEx.setId(anno.getId());
            newAnnoFreepenEx.setDocId(anno.getDocId());
            newAnnoFreepenEx.setPageId(anno.getPageId());
            newAnnoFreepenEx.setOwner(anno.getOwner());
            ((AnnoFreepenEx)newAnnoFreepenEx).setColor(((AnnoFreepenEx)anno).getColor());
            AnnoFPoint[] points = ((AnnoFreepenEx)anno).getPoints();
            ((AnnoFreepenEx)newAnnoFreepenEx).setPoints(Arrays.asList(points));
            ((AnnoFreepenEx)newAnnoFreepenEx).setHighLight(((AnnoFreepenEx)anno).isHighLight());
            ((AnnoFreepenEx)newAnnoFreepenEx).setLinesize((byte)((AnnoFreepenEx)anno).getLinesize());
            ((AnnoFreepenEx)newAnnoFreepenEx).setStepType(((AnnoFreepenEx)anno).getStepType());
        }
        final AbsAnno sendAnno = newAnnoFreepenEx;
        boolean ret = routine.docAddAnnotation(sendAnno.getDocId(), sendAnno.getPageId(), sendAnno, new OnTaskRet(){

            public void onTaskRet(boolean ret, int id, String desc) {
                if (sendAnno instanceof AnnoFreepenEx && ((AnnoFreepenEx)sendAnno).getStepType() == 1) {
                    anno.setId(sendAnno.getId());
                }
                if (null != onTaskRet) {
                    onTaskRet.onTaskRet(ret, id, desc);
                }
            }
        });
        return ret;
    }

    public boolean deleteAnno(AbsAnno anno, boolean isAll) {
        IRoutine routine = this.getRoutine();
        if (this.mCurDoc == null || routine == null) {
            return false;
        }
        int docId = this.mCurDoc.getDocId();
        int pageId = anno.getPageId();
        GenseeLog.d((String)TAG, (String)("deleteAnno " + anno.toString()));
        return isAll ? routine.docRemoveAllAnnotation(docId, pageId, null) : routine.docRemoveAnnotation(docId, pageId, anno, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDocOrLodAdd(PduDoc o) {
        String string = TAG;
        synchronized (TAG) {
            if (!this.docs.contains(o)) {
                this.docs.add(o);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDocOrLodRemove(Object o) {
        String string = TAG;
        synchronized (TAG) {
            int index = this.docs.indexOf(o);
            if (index != -1) {
                this.docs.remove(index);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean docNewWhiteboard(String name, boolean createOnce, OnTaskRet taskRet) {
        return this.getRoutine().docNewWhiteboard(name, createOnce, taskRet);
    }

    @Override
    public boolean docClose(int docId, boolean bDelOnServer, OnTaskRet taskRet) {
        return this.getRoutine().docClose(docId, bDelOnServer, taskRet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openDoc(String name, Bitmap bitmap) {
        ByteArrayOutputStream stream;
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Bitmap tmp = null;
        if (w * h > 512000) {
            try {
                float scale = (float)Math.sqrt(512000.0 / (double)w * (double)h);
                Matrix m = new Matrix();
                m.setScale(scale, scale);
                bitmap = tmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)m, (boolean)false);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)(stream = new ByteArrayOutputStream()))) {
            try {
                stream.flush();
                byte[] arr = stream.toByteArray();
                this.openDoc(name, arr, bitmap.getWidth(), bitmap.getHeight());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        if (tmp != null) {
            tmp.recycle();
        }
    }

    @Override
    public void openDoc(String name, final byte[] data, final int w, final int h) {
        GenseeLog.d((String)TAG, (String)("openDoc data len = " + (data == null ? 0 : data.length)));
        if (null == data || data.length <= 0) {
            return;
        }
        ++this.mPhotoCount;
        this.getRoutine().docOpen(name, 5, new AbsTaskRet(){

            public void onTaskRet(Object o, String desc) {
                if (o instanceof PduDoc) {
                    final PduDoc newDoc = (PduDoc)o;
                    if (DocEventImpl.this.mDocCallBack != null) {
                        DocEventImpl.this.mDocCallBack.onDocOpened(newDoc);
                    }
                    DocEventImpl.this.getRoutine().docTranslateBegin(newDoc.getDocId(), new OnTaskRet(){

                        public void onTaskRet(boolean ret, int id, String desc) {
                            if (null != DocEventImpl.this.mDocCallBack) {
                                DocEventImpl.this.mDocCallBack.onDocUploadStatus(newDoc.getDocId(), 1);
                            }
                            DocEventImpl.this.getRoutine().docTranslataData(newDoc.getDocId(), 0, w, h, 0, "1", "", "", "", data, new OnTaskRet(){

                                public void onTaskRet(boolean ret, int id, String desc) {
                                    if (null != DocEventImpl.this.mDocCallBack) {
                                        DocEventImpl.this.mDocCallBack.onDocUploadStatus(newDoc.getDocId(), 2);
                                    }
                                    GenseeLog.d((String)DocEventImpl.TAG, (String)("docTranslataData ret = " + ret + " data len = " + data.length), (String)(" width = " + w + " height = " + h));
                                    DocEventImpl.this.getRoutine().docTranslateEnd(newDoc.getDocId(), ret, new OnTaskRet(){

                                        public void onTaskRet(boolean ret, int id, String desc) {
                                            if (null != DocEventImpl.this.mDocCallBack) {
                                                DocEventImpl.this.mDocCallBack.onDocUploadStatus(newDoc.getDocId(), 3);
                                            }
                                            GenseeLog.d((String)DocEventImpl.TAG, (String)("docTranslateEnd ret = " + ret));
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    private boolean isCurPagePrepared() {
        PduPage page = this.mCurDoc.getCurPage();
        return page != null && page.isPrepare();
    }

    @Override
    public void onDocJoinConfirm(final boolean bRet) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocJoinConfirm(bRet);
                }
            }
        });
        this.annoTmpUserId = new Random().nextInt();
        this.nJoinConfirmTime = bRet ? SystemClock.elapsedRealtime() : 0L;
        GenseeLog.d((String)TAG, (String)("onDocJoinConfirm bRet = " + bRet + " annoTmpUserId = " + this.annoTmpUserId));
    }

    @Override
    public void onDocOpened(final PduDoc doc) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                GenseeLog.d((String)DocEventImpl.TAG, (String)("onDocOpened docId = " + doc.getDocId() + " docName = " + doc.getDocName()));
                DocEventImpl.this.onDocOrLodAdd(doc);
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocOpened(doc);
                }
            }
        });
    }

    @Override
    public void onDocClosed(final int docId) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                GenseeLog.d((String)DocEventImpl.TAG, (String)("onDocClosed docId = " + docId));
                if (DocEventImpl.this.mCurDoc != null && DocEventImpl.this.mCurDoc.getDocId() == docId) {
                    DocEventImpl.this.sendMessage(146, docId);
                    DocEventImpl.this.mCurDoc = null;
                }
                DocEventImpl.this.onDocOrLodRemove(new PduDoc(docId));
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocClosed(docId);
                }
            }
        });
    }

    @Override
    public void onDocGotoPage(final int docId, final int pageId, final int aniStep) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                DocEventImpl.this.runDocGotoPage(docId, pageId, aniStep);
            }
        });
    }

    private void runDocGotoPage(int docId, int pageId, int aniStep) {
        PduPage curPage;
        GenseeLog.d((String)TAG, (String)("onDocGotoPage docId = " + docId + " pageId = " + pageId + " aniStep = " + aniStep));
        PduDoc curDoc = this.getCurrentDoc();
        if (curDoc != null && docId == curDoc.getDocId() && (curPage = curDoc.getCurPage()) != null && curPage.getPageId() == pageId) {
            curPage.setAniStep(aniStep);
            this.sendMessage(142, curPage);
            return;
        }
        PduDoc doc = this.getDocById(docId);
        if (doc != null) {
            PduPage p = doc.onCmd((long)pageId, aniStep);
            this.mCurDoc = doc;
            if (this.mDocCallBack != null) {
                this.mDocCallBack.onDocGotoPage(docId, pageId, aniStep);
                if (p != null) {
                    this.mDocCallBack.onDocPageSize(p.getImgWidth(), p.getImgHeight());
                }
            }
            if (this.isCurPagePrepared()) {
                this.sendMessage(138, p);
            }
        }
    }

    @Override
    public void onDocGotoAnimation(int docId, final int pageId, final int step) {
        GenseeLog.d((String)TAG, (String)("onDocGotoAnimation docId = " + docId + " pageId = " + pageId + " step = " + step));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                PduPage curPage = null;
                if (DocEventImpl.this.mCurDoc != null) {
                    curPage = DocEventImpl.this.mCurDoc.getCurPage();
                }
                if (null != curPage && curPage.getPageId() == pageId) {
                    curPage.setAniStep(step);
                    DocEventImpl.this.sendMessage(142, curPage);
                }
            }
        });
    }

    @Override
    public void onDocSavedOnServer(final int docId, final boolean bRet, final boolean savedByMyself) {
        GenseeLog.d((String)TAG, (String)("onDocSavedOnServer docId = " + docId + " bRet = " + bRet));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                PduDoc doc = null;
                doc = DocEventImpl.this.mCurDoc != null && DocEventImpl.this.mCurDoc.getDocId() == docId ? DocEventImpl.this.mCurDoc : DocEventImpl.this.getDocById(docId);
                if (null != doc) {
                    doc.setSavedOnServer((byte)(bRet ? 1 : 0));
                }
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocSavedOnServer(docId, bRet, savedByMyself);
                }
            }
        });
    }

    @Override
    public void onDocPageReady(final int docId, final PduPage page, final byte[] data) {
        if (null == page) {
            return;
        }
        GenseeLog.d((String)TAG, (String)("onDocPageReady docId = " + docId + " pageId = " + page.getPageId() + " data len = " + data.length));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                page.setDocId(docId);
                PduDoc doc = null;
                boolean isShowing = false;
                PduPage p = null;
                if (DocEventImpl.this.mCurDoc != null && DocEventImpl.this.mCurDoc.getDocId() == docId) {
                    doc = DocEventImpl.this.mCurDoc;
                    p = DocEventImpl.this.mCurDoc.getCurPage();
                    if (p != null && p.getPageId() == page.getPageId()) {
                        isShowing = true;
                    }
                } else {
                    doc = DocEventImpl.this.getDocById(docId);
                }
                if (null != doc && null == p && doc.addPage(page)) {
                    p = page;
                }
                PduDoc docNeed = doc;
                boolean isNow = isShowing;
                PduPage pageNeed = p;
                if (docNeed != null) {
                    if (null != DocEventImpl.this.mGlDocView) {
                        docNeed.onGlContent((long)page.getPageId(), data, isNow);
                    } else {
                        docNeed.onContent((long)page.getPageId(), data, isNow);
                    }
                    if (isNow) {
                        DocEventImpl.this.sendMessage(140, pageNeed);
                    }
                }
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocPageReady(docId, page, data);
                }
            }
        });
    }

    @Override
    public void onDocReceiveAnno(int docId, int pageId, final AbsAnno anno) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                switch (anno.getType()) {
                    case 18: {
                        long nCurTime = SystemClock.elapsedRealtime();
                        if (nCurTime - DocEventImpl.this.nJoinConfirmTime > 3000L) {
                            DocEventImpl.this.onFreePenF((AnnoFreepenEx)anno);
                            break;
                        }
                        AnnoFreepenEx tmpPen = AnnoFreepenEx.create((AnnoFreepenEx)((AnnoFreepenEx)anno));
                        tmpPen.appendPoints(((AnnoFreepenEx)anno).getPoints());
                        tmpPen.setStepType(((AnnoFreepenEx)anno).getStepType());
                        DocEventImpl.this.onAnnoAdd((AbsAnno)tmpPen);
                        break;
                    }
                    case 16: {
                        DocEventImpl.this.onAnnoAdd(anno);
                        break;
                    }
                    case 3: {
                        DocEventImpl.this.onClean(anno);
                        break;
                    }
                    case 1: 
                    case 9: 
                    case 17: {
                        DocEventImpl.this.onPoint(anno);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 19: 
                    case 20: 
                    case 21: {
                        DocEventImpl.this.onAnnoAdd(anno);
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void onDocRemoveAnno(final int docId, final int pageId, final long llAnnoId) {
        GenseeLog.d((String)TAG, (String)("onDocRemoveAnno docId = " + docId + " pageId = " + pageId + " llAnnoId = " + llAnnoId));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                AnnoCleaner cleaner = new AnnoCleaner();
                cleaner.setDocId(docId);
                cleaner.setPageId(pageId);
                cleaner.setRemovedId(llAnnoId);
                DocEventImpl.this.onClean((AbsAnno)cleaner);
            }
        });
    }

    private void onFreePenF(final AnnoFreepenEx anno) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                List list = anno.getPointList();
                int size = list.size();
                if (size > 0) {
                    int count = 0;
                    int delay = anno.getDelay();
                    int pTime = delay / size;
                    AnnoFreepenEx tmpPen = null;
                    int oldStepType = anno.getStepType();
                    for (AnnoFPoint p : list) {
                        tmpPen = AnnoFreepenEx.create((AnnoFreepenEx)anno);
                        tmpPen.appendPoints(new AnnoFPoint[]{p});
                        int step = 0;
                        switch (oldStepType) {
                            case 1: {
                                step = count == 0 ? 1 : 2;
                                break;
                            }
                            case 2: {
                                step = 2;
                                break;
                            }
                            case 3: {
                                step = count == size - 1 ? 3 : 2;
                                break;
                            }
                            default: {
                                step = count == size - 1 ? 3 : (count == 0 ? 1 : 2);
                            }
                        }
                        tmpPen.setStepType(step);
                        ++count;
                        DocEventImpl.this.onAnnoAdd((AbsAnno)tmpPen);
                        if (pTime > 100) {
                            pTime = 100;
                        } else if (pTime <= 0) {
                            pTime = 1;
                        }
                        try {
                            if (pTime <= 0) continue;
                            Thread.sleep(pTime);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    @Override
    protected String onGetLogTag() {
        return TAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanData() {
        List<PduDoc> list = this.docs;
        synchronized (list) {
            for (PduDoc doc : this.docs) {
                if (doc == null) continue;
                doc.clean(doc.equals((Object)this.mCurDoc));
            }
            this.mCurDoc = null;
            this.docs.clear();
        }
    }

    @Override
    public void synCurrentDoc() {
        PduPage page;
        if ((UserManager.getIns().isHost() || UserManager.getIns().isPanlist()) && this.mCurDoc != null && (page = this.mCurDoc.getCurPage()) != null) {
            this.getRoutine().docGotoPage(this.mCurDoc.getDocId(), page.getPageId(), true, null);
        }
    }

    @Override
    public int getPhotoCount() {
        return this.mPhotoCount;
    }

    @Override
    public void release() {
        this.mPhotoCount = 0;
        this.mDocView = null;
        this.mGlDocView = null;
        this.setHandler(null);
        String filePath = PduPage.getFileDir();
        if (filePath != null) {
            FileUtil.deleteFile((File)new File(filePath));
        }
    }

    @Override
    public boolean docRemoteOpen(String filePath, String fileName, OnTaskRet taskRet) {
        GenseeLog.d((String)TAG, (String)("docRemoteOpen path = " + filePath + " fileName " + fileName));
        if (filePath == null || "".equals(filePath) || fileName == null || "".equals(fileName)) {
            GenseeLog.e((String)TAG, (String)("docRemoteOpen Error path = " + filePath + " desc " + fileName));
            return false;
        }
        File f = new File(filePath);
        if (f == null || !f.isFile() || !f.exists()) {
            GenseeLog.e((String)TAG, (String)("docRemoteOpen Error path = " + filePath + " is not a file or not exist"));
            return false;
        }
        return this.getRoutine().docRemoteOpen(filePath, fileName, taskRet);
    }

    @Override
    public void onDocRename(int docId, String name) {
        GenseeLog.d((String)TAG, (String)("onDocRename name = " + name));
        if (this.mDocCallBack != null) {
            this.mDocCallBack.onDocRename(docId, name);
        }
    }
}

