/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.net;

import com.gensee.entity.LiveInfo;
import com.gensee.net.AbsRtAction;
import com.gensee.net.StringRes;
import com.gensee.parse.PullBase;
import com.gensee.routine.ILiveInfoEvent;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Properties;
import org.xmlpull.v1.XmlPullParser;

public class LiveInfoReq
extends AbsRtAction {
    private static final String TAG = "LiveInfoReq";
    private static final String XML_EVENT_DETAIL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><getEventDetail><confId>%s</confId><userId>%s</userId><siteId>%s</siteId></getEventDetail>";
    private ILiveInfoEvent mEvent;

    public LiveInfoReq(ILiveInfoEvent event) {
        super(null);
        this.mEvent = event;
    }

    public void postReq(String launchCode, int serviceType) {
        String norCode = StringUtil.hexStr2Str((String)launchCode);
        Properties p = new Properties();
        String api = "";
        try {
            p.load(new StringReader(norCode));
            api = p.getProperty("api");
            if (api != null && api.contains("?")) {
                api = api.substring(0, api.indexOf("?"));
            }
            api = api + "?sc=" + serviceType;
            String confId = p.getProperty("evtID");
            String userId = p.getProperty("userID");
            String siteId = p.getProperty("siteID");
            String param = String.format(XML_EVENT_DETAIL, confId, userId, siteId);
            this.doPostRequest(api, param, new StringRes(){

                public void onConnectError(int errorType, String errorInfo) {
                    GenseeLog.d((String)LiveInfoReq.TAG, (String)("postReq onConnectError errorType = " + errorType));
                    LiveInfoReq.this.onLiveInfo(null);
                }

                public void onRes(String result) {
                    InfoPullParse p = new InfoPullParse();
                    p.parseXml(result);
                    LiveInfoReq.this.onLiveInfo(p.info);
                }
            });
        }
        catch (IOException e) {
            this.onLiveInfo(null);
            e.printStackTrace();
        }
    }

    private void onLiveInfo(LiveInfo info) {
        if (this.mEvent != null) {
            if (null != info) {
                this.mEvent.onLiveInfo(info);
            }
            this.mEvent = null;
        }
    }

    private class InfoPullParse
    extends PullBase {
        private LiveInfo info = null;

        private InfoPullParse() {
        }

        public XmlPullParser parseXml(String xml) {
            return super.parseXml(xml);
        }

        protected void onStartTag(String nodeName, XmlPullParser parser) {
            if ("getEventDetailResponse".equals(nodeName)) {
                this.info = new LiveInfo();
            } else if ("scheduleInfo".equals(nodeName)) {
                this.nextEventType(parser);
                this.info.setScheduleInfo(parser.getText());
            } else if ("speakerInfo".equals(nodeName)) {
                this.nextEventType(parser);
                this.info.setSpeakerInfo(parser.getText());
            } else if ("description".equals(nodeName)) {
                this.nextEventType(parser);
                this.info.setDescription(parser.getText());
            }
        }

        protected void onEndTag(String nodeName, XmlPullParser parser) {
        }

        protected void onEndDoc(XmlPullParser parser) {
        }

        protected void onStartDoc(XmlPullParser parser) {
        }

        public <T> T toParse(InputStream inputStream) {
            return null;
        }
    }
}

