/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.praise;

import com.gensee.callback.IMedalPraiseCallback;
import com.gensee.praise.PraiseInfo;
import com.gensee.praise.PraiseUserInfo;
import com.gensee.room.AbsModule;
import com.gensee.routine.IRTEvent;
import com.gensee.utils.GenseeLog;

public class MedalPraiseEventImpl
extends AbsModule
implements IRTEvent.IMedalPraiseEvent {
    private static final String TAG = "PraiseEventImpl";
    private IMedalPraiseCallback mCallback;
    private long selfId;
    private int cusMedal;
    private int cusFavour;

    public void initMedalPraise(IMedalPraiseCallback callback, int medal, int faour, long selfId) {
        GenseeLog.d((String)TAG, (String)("initMedalPraise medal = " + medal + " faour = " + faour));
        this.mCallback = callback;
        if (selfId != 0L) {
            this.selfId = selfId;
            if (medal > -2) {
                this.cusMedal = medal;
                this.getRoutine().getPraiseInfo("medal", selfId, null);
            }
            if (faour > -2) {
                this.cusFavour = faour;
                this.getRoutine().getPraiseInfo("favour", selfId, null);
            }
        } else {
            GenseeLog.w((String)TAG, (String)"initMedalPraise fail,by not join the room");
        }
    }

    @Override
    protected String onGetLogTag() {
        return TAG;
    }

    @Override
    public void onSetPraiseInfo(int result, String praiseType, PraiseUserInfo userinfo) {
        if (this.mCallback != null) {
            this.mCallback.onPraiseInfo(result, praiseType, userinfo);
        }
    }

    @Override
    public void onGetPraiseInfo(int nResult, String praiseType, PraiseUserInfo userinfo) {
        if (nResult == 10304 && userinfo.getUserId() == this.selfId) {
            this.getRoutine().setPraiseInfo(praiseType, "favour".equals(praiseType) ? this.cusFavour : ("medal".equals(praiseType) ? this.cusMedal : 0), null);
            return;
        }
        if (this.mCallback != null) {
            this.mCallback.onPraiseInfo(nResult, praiseType, userinfo);
        }
    }

    @Override
    public void onSendPraise(int result, String praiseType, PraiseUserInfo userinfo) {
        if (this.mCallback != null) {
            this.mCallback.onPraiseInfo(result, praiseType, userinfo);
        }
    }

    @Override
    public void onGetPraiseTotal(int result, String praiseType, int total) {
        if (this.mCallback != null) {
            this.mCallback.onPraiseTotal(result, praiseType, total);
        }
    }

    @Override
    public void onSendPraiseNotify(String praiseType, int time, PraiseUserInfo senderInfo, PraiseUserInfo receiverInfo, String comment) {
        if (this.mCallback != null) {
            this.mCallback.onPraiseNotify(praiseType, time, senderInfo, receiverInfo, comment);
        }
    }

    @Override
    public void onGetPraiseRecvList(int result, String praiseType, PraiseInfo[] praises) {
        if (this.mCallback != null) {
            this.mCallback.onPraiseRecvList(result, praiseType, praises);
        }
    }

    @Override
    public void release() {
        super.release();
        this.mCallback = null;
        this.cusFavour = 0;
        this.cusFavour = 0;
    }
}

