/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.room;

import android.os.Handler;
import com.gensee.room.IRoomFunc;
import com.gensee.routine.IRoutine;
import com.gensee.routine.UserInfo;
import com.gensee.utils.RTLog;

public abstract class AbsModule
implements IRoomFunc {
    private Handler mHandler;
    private IRoomFunc mRoomFunc;
    protected long localUserId;

    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    protected void sendMessage(int what, Object object) {
        if (this.mHandler != null) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(what, object));
        } else {
            RTLog.w((String)(this.onGetLogTag() + " there is a msg " + what + " arived,but the ui handler is null"));
        }
    }

    protected void sendMessageDelayed(int what, Object object, long delay) {
        if (this.mHandler != null) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(what, object), delay);
        } else {
            RTLog.w((String)(this.onGetLogTag() + " there is a msg " + what + " arived,but the ui handler is null"));
        }
    }

    protected void removeMessages(int what) {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(what);
        } else {
            RTLog.w((String)(this.onGetLogTag() + " there is a msg " + what + " arived,but the ui handler is null"));
        }
    }

    protected void post(Runnable r) {
        if (this.mHandler != null) {
            this.mHandler.post(r);
        } else {
            RTLog.w((String)(this.onGetLogTag() + " post faild"));
        }
    }

    @Override
    public IRoutine getRoutine() {
        return this.mRoomFunc == null ? null : this.mRoomFunc.getRoutine();
    }

    public void setRoomFunc(IRoomFunc roomFunc) {
        this.mRoomFunc = roomFunc;
    }

    @Override
    public void postPool(Runnable r) {
        if (this.mRoomFunc != null) {
            this.mRoomFunc.postPool(r);
        }
    }

    public void onRoomData(String key, long value, long userId) {
    }

    public void onUserJoin(UserInfo userInfo) {
    }

    public void onUserUpdate(UserInfo userInfo) {
    }

    public void onUserLeave(long userId) {
    }

    public void setUserId(long userId) {
        this.localUserId = userId;
    }

    public boolean isOpenAV(long userId) {
        return false;
    }

    public boolean hasOpenAV() {
        return false;
    }

    public boolean isAVJoin(long userId) {
        return false;
    }

    protected abstract String onGetLogTag();

    public void release() {
    }

    public void onReconnect() {
    }

    public void onFailover(boolean isFailover, long userId) {
    }

    public void onFreezeVideo(long userId) {
    }

    public boolean isUserFreezeeVideo(long userId) {
        return false;
    }
}

