/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.room;

import android.content.Context;
import com.gensee.as.AsEventImpl;
import com.gensee.audio.AudioEventImpl;
import com.gensee.callback.IAsCallBack;
import com.gensee.callback.IAudioCallBack;
import com.gensee.callback.IChatCallBack;
import com.gensee.callback.IFtCallBack;
import com.gensee.callback.IHongbaoCallBack;
import com.gensee.callback.ILodCallBack;
import com.gensee.callback.IMedalPraiseCallback;
import com.gensee.callback.IQACallback;
import com.gensee.callback.IRoomCallBack;
import com.gensee.callback.ITipInfoCallBack;
import com.gensee.callback.IVideoCallBack;
import com.gensee.callback.IVoteCallBack;
import com.gensee.common.GenseeConfig;
import com.gensee.common.RTSharedPref;
import com.gensee.doc.DocEventImpl;
import com.gensee.entity.LiveInfo;
import com.gensee.entity.LoginResEntity;
import com.gensee.ft.FtEventImpl;
import com.gensee.hongbao.HongbaoEventImpl;
import com.gensee.lod.LodEventImpl;
import com.gensee.media.BlueToother;
import com.gensee.net.LiveInfoReq;
import com.gensee.net.NetChange;
import com.gensee.net.OnNetChangeListener;
import com.gensee.praise.MedalPraiseEventImpl;
import com.gensee.qa.QaEventImpl;
import com.gensee.room.AbsModule;
import com.gensee.routine.ChatEventImpl;
import com.gensee.routine.IRTEvent;
import com.gensee.routine.IRoutine;
import com.gensee.routine.Routine;
import com.gensee.routine.State;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.user.UserManager;
import com.gensee.utils.FileUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.upload.LogProperty;
import com.gensee.video.VideoEventImpl;
import com.gensee.vote.VoteEventImpl;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class RTRoom
extends AbsModule
implements IRTEvent.IRoomEvent,
OnNetChangeListener {
    private static final String TAG = "RTRoom";
    private IRoutine routine;
    private IRTEvent.IChatEvent chatEvent;
    private IRTEvent.IAudioEvent audioEvent;
    private IRTEvent.IVideoEvent videoEvent;
    private IRTEvent.IDocEvent docEvent;
    private IRTEvent.IVoteEvent voteEvent;
    private IRTEvent.IAsEvent asEvent;
    private IRTEvent.ILodEvent lodEvent;
    private IRTEvent.IQaEvent qaEvent;
    private IRTEvent.IHongbaoEvent hongbaoEvent;
    private IRTEvent.IFtEvent ftEvent;
    private IRTEvent.IMedalPraiseEvent mPraiseEvent;
    private boolean isJoinOK = false;
    private boolean isGetLiveInfo = false;
    private AtomicBoolean isFreeMode = new AtomicBoolean(false);
    private ExecutorService mExService;
    private int nChatMode = 1;
    private static RTRoom ins = null;
    private long userId;
    private IRoomCallBack roomCallBack;
    private Timer exitTimer;
    private OnTaskRet initTaskRet = new OnTaskRet(){

        public void onTaskRet(boolean ret, int id, String desc) {
            if (RTRoom.this.roomCallBack != null && !ret) {
                RTRoom.this.roomCallBack.onInit(false);
            }
        }
    };
    private boolean svrFailover = false;

    public long getUserId() {
        return this.userId;
    }

    private RTRoom() {
        this.routine = new Routine();
    }

    @Override
    public void postPool(Runnable r) {
        ExecutorService s = this.mExService;
        if (s != null && !s.isShutdown()) {
            s.submit(r);
        } else {
            GenseeLog.w((String)TAG, (String)"postPool s is null or shutdwn already!");
        }
    }

    public IRTEvent.IChatEvent getChatEvent() {
        if (this.chatEvent == null) {
            this.chatEvent = new ChatEventImpl();
            ((AbsModule)((Object)this.chatEvent)).setRoomFunc(this);
        }
        return this.chatEvent;
    }

    public IRTEvent.IAudioEvent getAudioEvent() {
        if (this.audioEvent == null) {
            this.audioEvent = new AudioEventImpl();
            ((AbsModule)((Object)this.audioEvent)).setRoomFunc(this);
        }
        return this.audioEvent;
    }

    public IRTEvent.IVideoEvent getVideoEvent() {
        if (this.videoEvent == null) {
            this.videoEvent = new VideoEventImpl();
            ((AbsModule)((Object)this.videoEvent)).setRoomFunc(this);
        }
        return this.videoEvent;
    }

    public IRTEvent.IDocEvent getDocEvent() {
        if (this.docEvent == null) {
            this.docEvent = new DocEventImpl();
            ((AbsModule)((Object)this.docEvent)).setRoomFunc(this);
        }
        return this.docEvent;
    }

    public IRTEvent.IVoteEvent getVoteEvent() {
        if (null == this.voteEvent) {
            this.voteEvent = new VoteEventImpl();
            ((AbsModule)((Object)this.voteEvent)).setRoomFunc(this);
        }
        return this.voteEvent;
    }

    public IRTEvent.IAsEvent getAsEvent() {
        if (null == this.asEvent) {
            this.asEvent = new AsEventImpl();
            ((AbsModule)((Object)this.asEvent)).setRoomFunc(this);
        }
        return this.asEvent;
    }

    public IRTEvent.ILodEvent getLodEvent() {
        if (this.lodEvent == null) {
            this.lodEvent = new LodEventImpl();
            ((AbsModule)((Object)this.lodEvent)).setRoomFunc(this);
        }
        return this.lodEvent;
    }

    public IRTEvent.IQaEvent getQaEvent() {
        if (this.qaEvent == null) {
            this.qaEvent = new QaEventImpl();
            ((AbsModule)((Object)this.qaEvent)).setRoomFunc(this);
        }
        return this.qaEvent;
    }

    public IRTEvent.IHongbaoEvent getHongbaoEvent() {
        if (this.hongbaoEvent == null) {
            this.hongbaoEvent = new HongbaoEventImpl();
        }
        return this.hongbaoEvent;
    }

    public IRTEvent.IMedalPraiseEvent getMPraiseEvent() {
        if (this.mPraiseEvent == null) {
            this.mPraiseEvent = new MedalPraiseEventImpl();
            ((AbsModule)((Object)this.mPraiseEvent)).setRoomFunc(this);
        }
        return this.mPraiseEvent;
    }

    private IRTEvent.IFtEvent getFtEvent() {
        if (this.ftEvent == null) {
            this.ftEvent = new FtEventImpl();
        }
        return this.ftEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RTRoom getIns() {
        if (ins != null) return ins;
        Class<RTRoom> clazz = RTRoom.class;
        synchronized (RTRoom.class) {
            if (ins != null) return ins;
            ins = new RTRoom();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    public void setAudioCallBack(IAudioCallBack audioCallBack) {
        ((AudioEventImpl)this.getAudioEvent()).setAudioCallBack(audioCallBack);
    }

    public void setChatCallBack(IChatCallBack chatCallBack) {
        ((ChatEventImpl)this.getChatEvent()).setChatCallBack(chatCallBack);
    }

    public void setVoteCallBack(IVoteCallBack voteCallBack) {
        ((VoteEventImpl)this.getVoteEvent()).setVoteCallBack(voteCallBack);
    }

    public void setAsCallBack(IAsCallBack asCallBack) {
        ((AsEventImpl)this.getAsEvent()).setAsCallBack(asCallBack);
    }

    public void setVideoCallBack(IVideoCallBack videoCallBack) {
        ((VideoEventImpl)this.getVideoEvent()).setVideoCallBack(videoCallBack);
    }

    public void setLodCallBack(ILodCallBack lodCallBack) {
        ((LodEventImpl)this.getLodEvent()).setLodCallBack(lodCallBack);
    }

    public void setQACallback(IQACallback callback) {
        ((QaEventImpl)this.getQaEvent()).setQaCallBack(callback);
    }

    public void setHongbaoCallback(IHongbaoCallBack callback) {
        ((HongbaoEventImpl)this.getHongbaoEvent()).setHongbaoCallBack(callback);
    }

    public void setTipInfoCallback(ITipInfoCallBack tipInfoBack) {
        ((HongbaoEventImpl)this.getHongbaoEvent()).setOnTipInfoCallBack(tipInfoBack);
    }

    public void initMedalPraise(IMedalPraiseCallback callback, int cusMedal, int cusFaour) {
        if (this.userId != 0L) {
            ((MedalPraiseEventImpl)this.getMPraiseEvent()).initMedalPraise(callback, cusMedal, cusFaour, this.userId);
        }
    }

    public void setFtCallback(IFtCallBack callback) {
        ((FtEventImpl)this.getFtEvent()).setFtCallback(callback);
    }

    public boolean isAsPlaying() {
        return this.getAsEvent().isAsPlaying();
    }

    public boolean isFreeMode() {
        return this.isFreeMode.get();
    }

    public void setFreeMode(boolean isFreeMode) {
        if (this.userId == 0L || isFreeMode == this.isFreeMode()) {
            return;
        }
        UserInfo self = UserManager.getIns().getMyUserInfo();
        if (self != null && (self.isHost() || self.IsPanelist())) {
            this.routine.roomSetData("class.mode", isFreeMode ? 1L : 0L, null);
        }
    }

    public int getChatMode() {
        return this.nChatMode;
    }

    @Override
    public IRoutine getRoutine() {
        return this.routine;
    }

    public boolean initRt(String logFileName, final String launchCode, IRoomCallBack roomCallBack) {
        if (!this.checkCallbackAndLib(roomCallBack)) {
            return false;
        }
        RTSharedPref.getIns().putString("launch_code", launchCode);
        Runnable initFun = new Runnable(){

            @Override
            public void run() {
                RTRoom.this.routine.init(launchCode, RTRoom.this.initTaskRet);
            }
        };
        return this.createRoutine(logFileName, initFun);
    }

    private void initExecutor() {
        if (this.mExService == null) {
            this.mExService = Executors.newSingleThreadExecutor();
        }
    }

    public boolean initRTRoom(String logFileName, final String ini, IRoomCallBack roomCallBack) {
        if (!this.checkCallbackAndLib(roomCallBack)) {
            return false;
        }
        LoginResEntity e = GenseeConfig.getIns().getLoginResEntity();
        if (e != null) {
            String rewardConfig = e.getRewardConfig();
            if (rewardConfig != null) {
                this.OnSettingSet("reward.range", rewardConfig);
            }
            this.OnSettingSet("pay.ol.type.1.enable", e.isAliPaySupport() ? 1 : 0);
            this.OnSettingSet("medal.enable", e.isMedalEnable() ? 1 : 0);
            this.OnSettingSet("praise.enable", e.isFavourEnable() ? 1 : 0);
        }
        Runnable initFun = new Runnable(){

            @Override
            public void run() {
                RTRoom.this.routine.initWithParam(ini, RTRoom.this.initTaskRet);
            }
        };
        return this.createRoutine(logFileName, initFun);
    }

    private boolean createRoutine(String logFileName, final Runnable initFun) {
        return this.routine.createRTRoutine(logFileName, new OnTaskRet(){

            public void onTaskRet(boolean ret, int id, String desc) {
                if (ret) {
                    RTRoom.this.initExecutor();
                    RTRoom.this.routine.setRoomEvent(RTRoom.this);
                    initFun.run();
                } else if (RTRoom.this.roomCallBack != null) {
                    RTRoom.this.roomCallBack.onInit(false);
                }
            }
        });
    }

    public boolean initWithWebApi(final String webApi, final long siteId, final String liveId, final long userId, IRoomCallBack roomCallBack) {
        if (!this.checkCallbackAndLib(roomCallBack)) {
            return false;
        }
        Runnable initFun = new Runnable(){

            @Override
            public void run() {
                RTRoom.this.routine.initWithWebApi(webApi, siteId, liveId, userId, RTRoom.this.initTaskRet);
            }
        };
        return this.createRoutine("", initFun);
    }

    private boolean checkCallbackAndLib(IRoomCallBack roomCallBack) {
        this.roomCallBack = roomCallBack;
        if (roomCallBack == null) {
            GenseeLog.w((String)TAG, (String)"checkCallbackAndLib roomCallBack is null");
            return false;
        }
        if (!Routine.loadLibrarys()) {
            GenseeLog.w((String)TAG, (String)"checkCallbackAndLib lib not loaded");
            roomCallBack.onInit(false);
            return false;
        }
        Context context = roomCallBack.onGetContext();
        if (context == null) {
            roomCallBack.onInit(false);
            GenseeLog.w((String)TAG, (String)"checkCallbackAndLib onGetContext is null");
            return false;
        }
        NetChange.getIns().setUp(context);
        NetChange.getIns().addOnNetChangeListener((OnNetChangeListener)this);
        RTSharedPref.initPref((Context)context);
        DocEventImpl.initPageCachDir(context);
        ((AudioEventImpl)this.getAudioEvent()).setContext(context);
        return true;
    }

    public boolean join(final OnTaskRet taskRet) {
        if (this.routine.join(new OnTaskRet(){

            public void onTaskRet(boolean ret, int id, String desc) {
                if (!ret && RTRoom.this.roomCallBack != null) {
                    RTRoom.this.roomCallBack.onRoomJoin(1, null, false);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret, id, desc);
                }
            }
        })) {
            return true;
        }
        if (this.roomCallBack != null) {
            this.roomCallBack.onRoomJoin(1, null, false);
        }
        return false;
    }

    public boolean leave(boolean isClose, final OnTaskRet taskRet) {
        this.cancelTimer();
        GenseeLog.d((String)TAG, (String)("leave isClose = " + isClose + " isJoinOk = " + this.isJoinOK + " userId = " + this.userId));
        if (!this.isJoinOK || this.userId == 0L) {
            if (this.roomCallBack != null) {
                this.roomCallBack.onRoomLeave(0);
            } else if (taskRet != null) {
                taskRet.onTaskRet(false, 1, "leave");
            }
            return true;
        }
        if (this.routine != null) {
            this.startExitTimer();
            isClose = UserManager.getIns().isHost() && isClose;
            ((AsEventImpl)this.getAsEvent()).leave();
            return this.routine.leave(isClose, new OnTaskRet(){

                public void onTaskRet(boolean ret, int id, String desc) {
                    GenseeLog.d((String)RTRoom.TAG, (String)("leave OnTaskRet ret = " + ret + " id = " + id));
                    if (!ret && RTRoom.this.roomCallBack != null) {
                        RTRoom.this.roomCallBack.onRoomLeave(0);
                    }
                    if (taskRet != null) {
                        taskRet.onTaskRet(ret, id, desc);
                    }
                }
            });
        }
        return false;
    }

    @Override
    public void OnInit(boolean isOk) {
        GenseeLog.d((String)TAG, (String)("OnInit isOk " + isOk));
        if (isOk) {
            this.routine.setChatEvent(this.getChatEvent());
            this.routine.setAuidoEvent(this.getAudioEvent());
            this.routine.setVideoEvent(this.getVideoEvent());
            this.routine.setDocEvent(this.getDocEvent());
            this.routine.setVoteEvent(this.getVoteEvent());
            this.routine.setLodEvent(this.getLodEvent());
            this.routine.setAsEvent(this.getAsEvent());
            this.routine.setQaEvent(this.getQaEvent());
            this.routine.setHongbaoEvent(this.getHongbaoEvent());
            this.routine.setFtEvent(this.getFtEvent());
            this.routine.setMedalPraiseEvent(this.getMPraiseEvent());
        }
        if (null != this.roomCallBack) {
            this.roomCallBack.onInit(isOk);
        }
    }

    @Override
    public void OnRoomJoin(int result, long myUserId, boolean svrFailover) {
        GenseeLog.d((String)TAG, (String)("OnRoomJoin result " + result + " myUserId = " + myUserId));
        this.svrFailover = svrFailover;
        if (0 == result) {
            this.userId = myUserId;
            this.onSelfJoin(this.routine.getMyUserInfo());
            ((AbsModule)((Object)this.getAudioEvent())).setUserId(myUserId);
            this.saveLogProperty();
            LoginResEntity e = GenseeConfig.getIns().getLoginResEntity();
            if (e != null) {
                String rewardConfig = e.getRewardConfig();
                if (rewardConfig != null) {
                    this.OnSettingSet("reward.range", rewardConfig);
                }
                this.OnSettingSet("pay.ol.type.1.enable", e.isAliPaySupport() ? 1 : 0);
            }
        } else if (null != this.roomCallBack) {
            this.roomCallBack.onRoomJoin(result, null, svrFailover);
        }
    }

    private void saveLogProperty() {
        Context context = this.roomCallBack.onGetContext();
        if (context != null) {
            int siteId = RTSharedPref.getIns().getInt("site.id", 0);
            String liveId = RTSharedPref.getIns().getString("training.class.id", "");
            String userId = RTSharedPref.getIns().getString("training.user.my.id", "");
            long tmpUserId = !"".equals(userId) ? Long.parseLong(userId) : 0L;
            String userNickName = RTSharedPref.getIns().getString("training.user.my.name", "");
            LogProperty.getIns().setProperty(context, userNickName, liveId, tmpUserId, (long)siteId, "RtSDK" + GenseeConfig.getSDKVersion(), null);
        }
    }

    private void onSelfJoin(UserInfo info) {
        if (info == null) {
            return;
        }
        if (this.isJoinOK) {
            return;
        }
        this.isJoinOK = true;
        this.saveJoinStatus(1);
        UserManager.getIns().userJoin(info, this.userId);
        if (this.roomCallBack != null) {
            this.roomCallBack.onRoomJoin(0, info, this.svrFailover);
        }
        this.svrFailover = false;
    }

    private synchronized void startExitTimer() {
        this.exitTimer = new Timer();
        TimerTask mTimerTask = new TimerTask(){

            @Override
            public void run() {
                GenseeLog.d((String)RTRoom.TAG, (String)"leave timer time out");
                RTRoom.this.OnRoomLeave(0);
            }
        };
        this.exitTimer.schedule(mTimerTask, 15000L);
    }

    private synchronized void cancelTimer() {
        if (null != this.exitTimer) {
            this.exitTimer.cancel();
            this.exitTimer = null;
        }
    }

    @Override
    public void OnRoomLeave(int reason) {
        this.cancelTimer();
        GenseeLog.d((String)TAG, (String)("OnRoomLeave reason " + reason + " roomCallBack = " + this.roomCallBack));
        this.isJoinOK = false;
        this.saveJoinStatus(0);
        this.cleanData();
        this.onLeave(reason);
    }

    private void onLeave(int reason) {
        if (null != this.roomCallBack) {
            this.roomCallBack.onRoomLeave(reason);
        }
    }

    @Override
    public void OnRoomReconnecting() {
        GenseeLog.d((String)TAG, (String)"OnRoomReconnecting");
        this.isJoinOK = false;
        this.saveJoinStatus(0);
        if (null != this.roomCallBack) {
            this.roomCallBack.onRoomReconnecting();
        }
        ((AsEventImpl)this.asEvent).onRoomReconnecting();
    }

    @Override
    public void OnRoomLock(boolean locked) {
        GenseeLog.d((String)TAG, (String)("OnRoomLock locked = " + locked));
        if (null != this.roomCallBack) {
            this.roomCallBack.onRoomLock(locked);
        }
    }

    @Override
    public void OnRoomPublish(State s) {
        GenseeLog.d((String)TAG, (String)("OnRoomPublish s = " + s.getValue()));
        if (this.roomCallBack != null) {
            this.roomCallBack.onRoomPublish(s);
        }
    }

    @Override
    public void OnRoomRecord(State s) {
        GenseeLog.d((String)TAG, (String)("OnRoomRecord s = " + s.getValue()));
        if (this.roomCallBack != null) {
            this.roomCallBack.onRoomRecord(s);
        }
    }

    @Override
    public void OnRoomData(String key, long value) {
        GenseeLog.d((String)TAG, (String)("OnRoomData key = " + key + " value = " + value));
        if ("chat.mode".equals(key)) {
            this.nChatMode = (int)value;
            if (this.roomCallBack != null) {
                this.roomCallBack.onChatMode(this.nChatMode);
            }
            return;
        }
        if ("class.mode".equals(key)) {
            this.isFreeMode.set(value != 0L);
            if (this.isFreeMode.get()) {
                this.routine.roomHanddown(false, null);
            }
            if (this.roomCallBack != null) {
                this.roomCallBack.onFreeMode(this.isFreeMode.get());
            }
            return;
        }
        ((AbsModule)((Object)this.getAudioEvent())).onRoomData(key, value, this.userId);
        if (this.roomCallBack != null) {
            this.roomCallBack.onRoomData(key, value);
        }
    }

    @Override
    public void OnRoomUserJoin(final UserInfo user) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (user != null && user.getId() == RTRoom.this.userId) {
                    RTRoom.this.onSelfJoin(user);
                } else {
                    UserManager.getIns().userJoin(user, RTRoom.this.userId);
                }
                if (null != RTRoom.this.roomCallBack) {
                    RTRoom.this.roomCallBack.onRoomUserJoin(user);
                }
            }
        });
    }

    @Override
    public void OnRoomUserUpdate(final UserInfo user, final int updateFlag) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                UserManager.getIns().userUpdate(user, updateFlag);
                if (null != RTRoom.this.roomCallBack) {
                    RTRoom.this.roomCallBack.onRoomUserUpdate(user);
                }
            }
        });
    }

    @Override
    public void OnRoomUserLeave(final long userId) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                UserInfo userInfo = UserManager.getIns().getUserByUserId(userId);
                if (null != userInfo) {
                    UserManager.getIns().userLeave(userId);
                    if (null != RTRoom.this.roomCallBack) {
                        RTRoom.this.roomCallBack.onRoomUserLeave(userInfo);
                    }
                }
            }
        });
    }

    @Override
    public void OnRoomBroadcastMsg(String msg) {
        GenseeLog.d((String)TAG, (String)("OnRoomBroadcastMsg msg = " + msg));
        if (null != this.roomCallBack) {
            this.roomCallBack.onRoomBroadcastMsg(msg);
        }
    }

    @Override
    public void OnRoomRollcall(int timeout) {
        GenseeLog.d((String)TAG, (String)("OnRoomRollcall timeout = " + timeout));
        if (null != this.roomCallBack) {
            this.roomCallBack.onRoomRollcall(timeout);
        }
    }

    @Override
    public void OnRoomRollcallAck(long userId) {
        GenseeLog.d((String)TAG, (String)("OnRoomRollcallAck userId = " + userId));
        if (null != this.roomCallBack) {
            this.roomCallBack.onRoomRollcallAck(userId);
        }
    }

    @Override
    public void OnRoomHandup(long userId, String data) {
        GenseeLog.d((String)TAG, (String)("OnRoomHandup userId = " + userId + " data = " + data));
        if (null != this.roomCallBack) {
            this.roomCallBack.onRoomHandup(userId, data);
        }
    }

    @Override
    public void OnRoomHanddown(long userId) {
        GenseeLog.d((String)TAG, (String)("OnRoomHanddown userId = " + userId));
        if (null != this.roomCallBack) {
            this.roomCallBack.onRoomHanddown(userId);
        }
    }

    @Override
    public void OnRoomSendLog() {
        if (GenseeLog.isInited()) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    RTRoom.this.reportDiagonse("Android RTSDK Diagonse", false, true);
                }
            });
        }
        GenseeLog.d((String)TAG, (String)"OnRoomSendLog");
    }

    @Override
    public void OnRoomPhoneServiceStatus(boolean bAvailable) {
        if (null != this.roomCallBack) {
            this.roomCallBack.onRoomPhoneServiceStatus(bAvailable);
        }
    }

    @Override
    public void OnRoomPhoneCallingStatus(String phoneNumber, int reason, int status) {
        if (null != this.roomCallBack) {
            this.roomCallBack.onRoomPhoneCallingStatus(phoneNumber, reason, status);
        }
    }

    @Override
    public int OnSettingQuery(String key, int val) {
        GenseeLog.d((String)TAG, (String)("OnSettingQuery INT key = " + key));
        int defValue = 0;
        if (null != this.roomCallBack) {
            defValue = this.roomCallBack.onSettingQuery(key, val);
        }
        if ("save.video.height".equals(key) || "save.video.width".equals(key) || "save.video.fps".equals(key)) {
            return ((VideoEventImpl)this.getVideoEvent()).getVideoParm(key, defValue);
        }
        return RTSharedPref.getIns().getInt(key, defValue);
    }

    @Override
    public String OnSettingQuery(String key) {
        String sValue;
        if (null != this.roomCallBack && null != (sValue = this.roomCallBack.onSettingQuery(key)) && !"".equals(sValue)) {
            return sValue;
        }
        sValue = RTSharedPref.getIns().getString(key, "");
        GenseeLog.d((String)TAG, (String)("OnSettingQuery STRING key = " + key));
        return sValue;
    }

    @Override
    public boolean OnSettingSet(String key, int val) {
        GenseeLog.d((String)TAG, (String)("OnSettingSet INT  key = " + key + " val = " + val));
        if ("user.real.count".equals(key)) {
            UserManager.getIns().setUserCount(val);
        }
        if (null != this.roomCallBack) {
            this.roomCallBack.onSettingSet(key, val);
        }
        return RTSharedPref.getIns().putInt(key, val);
    }

    @Override
    public boolean OnSettingSet(String key, String val) {
        GenseeLog.d((String)TAG, (String)("OnSettingSet STRING key = " + key + " val = " + val));
        if ("url.for.preview.of.webplayer".equals(key) && this.isGetLiveInfo) {
            int st = val == null ? 0 : (val.contains("/webcast/site/entry/") ? 0 : (val.contains("/training/site/s/") ? 1 : 0));
            this.getInfo(st);
        }
        if (null != this.roomCallBack) {
            this.roomCallBack.onSettingSet(key, val);
        }
        return RTSharedPref.getIns().putString(key, val);
    }

    @Override
    public boolean OnSettingSet(String key, byte[] data) {
        GenseeLog.d((String)TAG, (String)("OnSettingSet STRING key = " + key + " data length = " + data.length));
        if (null != this.roomCallBack && "video.logo.data.png".equals(key)) {
            String path = FileUtil.saveToCache((Context)this.roomCallBack.onGetContext(), (String)"set", (String)"video.logo.data.png", (byte[])data);
            this.OnSettingSet(key, path);
        }
        return true;
    }

    @Override
    public void OnUpgradeNotify(String downloadUrl) {
        GenseeLog.d((String)TAG, (String)("OnUpgradeNotify downloadUrl = " + downloadUrl));
        if (this.roomCallBack != null) {
            this.roomCallBack.OnUpgradeNotify(downloadUrl);
        }
    }

    @Override
    public void OnNetworkReport(byte level) {
        GenseeLog.d((String)TAG, (String)("OnNetworkReport level = " + level));
        if (this.roomCallBack != null) {
            this.roomCallBack.onNetworkReport(level);
        }
    }

    @Override
    public void OnNetworkBandwidth(int bpsSend, int bpsRecv) {
        if (this.roomCallBack != null) {
            this.roomCallBack.onNetworkBandwidth(bpsSend, bpsRecv);
        }
    }

    @Override
    protected String onGetLogTag() {
        return TAG;
    }

    @Override
    public void release() {
        ((AbsModule)((Object)this.getVoteEvent())).release();
        this.routine.routineRelease(null);
    }

    public void release(final OnTaskRet taskRet) {
        RTSharedPref ref = RTSharedPref.getIns();
        if (ref != null) {
            ref.clear();
        }
        BlueToother.getIns().release(2);
        NetChange.getIns().removeNetChangeListener((OnNetChangeListener)this);
        this.svrFailover = false;
        this.isJoinOK = false;
        this.saveJoinStatus(0);
        this.isGetLiveInfo = false;
        this.cancelTimer();
        this.routine.routineRelease(new OnTaskRet(){

            public void onTaskRet(boolean arg0, int arg1, String arg2) {
                ExecutorService s = RTRoom.this.mExService;
                RTRoom.this.mExService = null;
                if (s != null) {
                    s.shutdownNow();
                }
                RTRoom.this.roomCallBack = null;
                ((AbsModule)((Object)RTRoom.this.getVoteEvent())).release();
                ((AbsModule)((Object)RTRoom.this.getDocEvent())).release();
                ((AbsModule)((Object)RTRoom.this.getVideoEvent())).release();
                ((AbsModule)((Object)RTRoom.this.getAudioEvent())).release();
                GenseeLog.d((String)RTRoom.TAG, (String)("release end , taskRet = " + taskRet));
                if (taskRet != null) {
                    taskRet.onTaskRet(arg0, arg1, arg2);
                }
            }
        });
    }

    public void setChatMode(int nChatMode) {
        if (this.userId == 0L || nChatMode == this.nChatMode) {
            return;
        }
        UserInfo self = UserManager.getIns().getMyUserInfo();
        if (self != null && (self.isHost() || self.IsPanelist())) {
            this.routine.roomSetData("chat.mode", nChatMode, null);
        }
    }

    public boolean ejectUser(long userId, boolean isForbidIp, OnTaskRet taskRet) {
        if (!UserManager.getIns().isHost() && !UserManager.getIns().isPanlist()) {
            return false;
        }
        return this.routine.roomEjectUser(userId, isForbidIp, taskRet);
    }

    public boolean roomPublish(byte state, OnTaskRet taskRet) {
        if (state == State.S_STOPPED.getValue()) {
            return false;
        }
        return this.routine.roomPublish(state, taskRet);
    }

    public boolean roomRecord(byte state, OnTaskRet taskRet) {
        if (state == State.S_STOPPED.getValue()) {
            return false;
        }
        return this.routine.roomRecord(state, taskRet);
    }

    public String reportDiagonse(String desc, boolean bOnlyReportStack, boolean isZipCurLog) {
        int siteId = RTSharedPref.getIns().getInt("site.id", 0);
        String liveId = RTSharedPref.getIns().getString("training.class.id", "");
        String userId = RTSharedPref.getIns().getString("training.user.my.id", "");
        String userNickName = RTSharedPref.getIns().getString("training.user.my.name", "");
        GenseeLog.zipFile((boolean)isZipCurLog, (String)(siteId <= 0 ? "" : siteId + ""), (String)liveId, (String)userId, (String)userNickName);
        String uploadUrl = RTSharedPref.getIns().getString("diagnose.upload.url", "");
        String webApiUrl = RTSharedPref.getIns().getString("web.api.url", "");
        HashMap<String, String> propertyList = new HashMap<String, String>();
        propertyList.put("siteid", siteId + "");
        propertyList.put("userid", userId + "");
        propertyList.put("confid", liveId);
        HashMap<String, String> textList = new HashMap<String, String>();
        textList.put("username", userNickName);
        textList.put("desc", desc);
        return GenseeLog.rtReport((String)uploadUrl, (String)webApiUrl, propertyList, textList, (boolean)bOnlyReportStack, (boolean)false);
    }

    @Override
    public void OnLottery(byte type, String sUserlist) {
        GenseeLog.i((String)("OnLottery type = " + type + " : sUserlist = " + sUserlist));
        if (null != this.roomCallBack) {
            this.roomCallBack.onLottery(type, sUserlist);
        }
    }

    private void cleanData() {
        this.userId = 0L;
        this.nChatMode = 1;
        this.isFreeMode.set(false);
        ((DocEventImpl)this.getDocEvent()).cleanData();
        UserManager.getIns().clear();
        GenseeConfig.getIns().clean();
    }

    @Override
    public void OnRoomWebLayoutChange(int webLayout) {
    }

    @Override
    public void OnRoomPushUserQuantity2WebChange(boolean bPush) {
    }

    @Override
    public void OnRoomPushUserList2WebChange(boolean bPush) {
    }

    public static boolean loadLibrarys() {
        return Routine.loadLibrarys();
    }

    public void onNetChange(Context context) {
        GenseeLog.d((String)TAG, (String)"onNetChange");
        this.routine.netChangeEx(null);
    }

    public void getLiveInfo() {
        IRoomCallBack callback = this.roomCallBack;
        if (callback == null) {
            return;
        }
        LoginResEntity info = GenseeConfig.getIns().getLoginResEntity();
        if (info != null) {
            callback.onLiveInfo((LiveInfo)info);
            return;
        }
        RTSharedPref pref = RTSharedPref.getIns();
        if (pref != null) {
            String val = pref.getString("url.for.preview.of.webplayer", null);
            int st = val == null ? -1 : (val.contains("/webcast/site/entry/") ? 0 : (val.contains("/training/site/s/") ? 1 : 0));
            GenseeLog.d((String)TAG, (String)("getLiveInfo st = " + st + " val = " + val));
            if (st == -1) {
                this.isGetLiveInfo = true;
            } else {
                this.getInfo(st);
            }
        } else {
            this.isGetLiveInfo = true;
        }
    }

    private void getInfo(int val) {
        this.isGetLiveInfo = false;
        String launchCode = RTSharedPref.getIns().getString("launch_code", "");
        new LiveInfoReq(this.roomCallBack).postReq(launchCode, val);
    }

    private void saveJoinStatus(int value) {
        RTSharedPref.getIns().putInt("KEY_JOIN_STATUS", value);
    }
}

