/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.routine;

import com.gensee.callback.IChatCallBack;
import com.gensee.entity.ChatMsg;
import com.gensee.room.AbsModule;
import com.gensee.routine.IRTEvent;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.user.UserManager;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.RTLog;

public class ChatEventImpl
extends AbsModule
implements IRTEvent.IChatEvent {
    private static final String TAG = ChatEventImpl.class.getSimpleName();
    private IChatCallBack chatCallBack;

    public void setChatCallBack(IChatCallBack chatCallBack) {
        this.chatCallBack = chatCallBack;
    }

    @Override
    public void OnChatJoinConfirm(final boolean bRet) {
        RTLog.d((String)TAG, (String)("OnChatJoinConfirm " + bRet));
        if (null != this.chatCallBack) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    ChatEventImpl.this.chatCallBack.onChatJoinConfirm(bRet);
                }
            });
        }
    }

    @Override
    public void onChatMessage(final long userId, final int role, final String userName, final int msgType, final String msg, final String rich, final String msgId) {
        if (this.chatCallBack != null) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    UserInfo mUserInfo;
                    RTLog.d((String)TAG, (String)("onChatMessage() called with: userId = " + userId + " userName = " + userName + " msgType = " + msgType + " msg = " + msg + " rich = " + rich));
                    int tmpRole = role;
                    if (tmpRole == 0 && (mUserInfo = UserManager.getIns().getUserByUserId(userId)) != null) {
                        tmpRole = mUserInfo.getRole();
                    }
                    ChatMsg chatMsg = new ChatMsg();
                    chatMsg.setChatMsgType(msgType);
                    chatMsg.setContent(msg);
                    chatMsg.setRichText(rich);
                    chatMsg.setId(msgId);
                    chatMsg.setSender(userName);
                    chatMsg.setSenderId(userId);
                    chatMsg.setSenderRole(tmpRole);
                    chatMsg.setTimeStamp(System.currentTimeMillis());
                    ChatEventImpl.this.chatCallBack.onChatMessage(chatMsg);
                }
            });
        }
    }

    public void OnChatWithPersion(UserInfo userInfo, String msg, String rich) {
        RTLog.d((String)TAG, (String)("OnChatWithPersion " + userInfo.getName() + " : msg = " + msg + " rich = " + rich));
    }

    public void OnChatWithPanelist(UserInfo userInfo, String msg, String rich) {
        RTLog.d((String)TAG, (String)("OnChatWithPanelist " + userInfo.getName() + " : " + msg));
    }

    public void OnChatWithPublic(UserInfo userInfo, String msg, String rich) {
        RTLog.d((String)TAG, (String)("OnChatWithPublic " + userInfo.getName() + " : msg = " + msg + "  rich :" + rich));
    }

    @Override
    public void OnChatMyselfEnable(final boolean enable) {
        RTLog.d((String)TAG, (String)("OnChatEnable " + enable));
        if (null != this.chatCallBack) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    ChatEventImpl.this.chatCallBack.onChatEnable(enable);
                }
            });
        }
    }

    @Override
    public void OnChatEmotionIconUpdate(String iconUrl) {
        RTLog.d((String)TAG, (String)("OnChatEmotionIconUpdate iconUrl = " + iconUrl));
    }

    @Override
    protected String onGetLogTag() {
        return TAG;
    }

    public boolean chatWithPublic(ChatMsg msg, OnTaskRet taskRet) {
        if (msg == null || !msg.isPubValid()) {
            GenseeLog.w((String)TAG, (String)("chatWithPublic err msg = " + msg));
            return false;
        }
        return this.getRoutine().chatWithPublic(msg.getContent(), msg.getRichText(), msg.getId(), taskRet);
    }

    public boolean chatWithPanelist(ChatMsg msg, OnTaskRet taskRet) {
        if (msg == null || !msg.isPubValid()) {
            GenseeLog.w((String)TAG, (String)("chatWithPanelist err msg = " + msg));
            return false;
        }
        return this.getRoutine().chatWithPanelist(msg.getContent(), msg.getRichText(), msg.getId(), taskRet);
    }

    public boolean chatWithPersion(ChatMsg msg, OnTaskRet taskRet) {
        if (msg == null || !msg.isPriValid()) {
            GenseeLog.w((String)TAG, (String)("chatWithPublic err msg = " + msg));
            return false;
        }
        return this.getRoutine().chatWithPersion(msg.getContent(), msg.getRichText(), msg.getReceiverId(), msg.getId(), taskRet);
    }

    @Override
    public void onChatCensor(long userId, String msgId) {
        if (null != this.chatCallBack) {
            this.chatCallBack.onChatCensor(userId, msgId);
        }
    }
}

