/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.vote;

import com.gensee.callback.IVoteCallBack;
import com.gensee.card.Card;
import com.gensee.room.AbsModule;
import com.gensee.routine.IRTEvent;
import com.gensee.user.UserManager;
import com.gensee.utils.GenseeLog;
import com.gensee.vote.VoteGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class VoteEventImpl
extends AbsModule
implements IRTEvent.IVoteEvent {
    private static final String TAG = VoteEventImpl.class.getSimpleName();
    private static final int TIMELONG = 3000;
    private Timer timer;
    private TimerTask timerTask;
    private List<VoteGroup> cacheVoteList;
    private AtomicBoolean bFirst = new AtomicBoolean(false);
    private IVoteCallBack voteCallBack;

    @Override
    protected String onGetLogTag() {
        return TAG;
    }

    public void setVoteCallBack(IVoteCallBack voteCallBack) {
        this.voteCallBack = voteCallBack;
    }

    @Override
    public void OnVoteJoinConfirm(final boolean bRet) {
        GenseeLog.i((String)TAG, (String)("OnVoteJoinConfirm bRet " + bRet));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                VoteEventImpl.this.voteConfirm(bRet);
            }
        });
    }

    private void voteConfirm(boolean bRet) {
        if (null != this.voteCallBack) {
            this.voteCallBack.onVoteJoinConfirm(bRet);
        }
        if (bRet) {
            this.bFirst.set(true);
            this.cacheVoteList = new ArrayList<VoteGroup>();
            this.timer = new Timer();
            this.timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GenseeLog.i((String)TAG, (String)"onVote cache  finish");
                    VoteEventImpl.this.bFirst.set(false);
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        for (int i = 0; i < VoteEventImpl.this.cacheVoteList.size(); ++i) {
                            VoteGroup voteMsg = (VoteGroup)VoteEventImpl.this.cacheVoteList.get(i);
                            if (voteMsg.isM_bPublishResult() || voteMsg.isM_bDeadline()) {
                                if (!UserManager.getIns().isHost() && !UserManager.getIns().isPanlist()) continue;
                                if (voteMsg.isM_bPublishResult()) {
                                    if (null == VoteEventImpl.this.voteCallBack) continue;
                                    VoteEventImpl.this.voteCallBack.onVotePublishResult(voteMsg);
                                    continue;
                                }
                                if (null == VoteEventImpl.this.voteCallBack) continue;
                                VoteEventImpl.this.voteCallBack.onVoteDeadline(voteMsg);
                                continue;
                            }
                            if (voteMsg.isM_bPublish()) {
                                if (null == VoteEventImpl.this.voteCallBack) continue;
                                VoteEventImpl.this.voteCallBack.onVotePublish(voteMsg);
                                continue;
                            }
                            if (null == VoteEventImpl.this.voteCallBack) continue;
                            VoteEventImpl.this.voteCallBack.onVoteAdd(voteMsg);
                        }
                    }
                }
            };
            this.timer.schedule(this.timerTask, 3000L);
        }
    }

    @Override
    public void OnVoteAdd(final VoteGroup pGroup, long optUser) {
        GenseeLog.i((String)TAG, (String)("OnVoteAdd optUser " + optUser));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (!VoteEventImpl.this.bFirst.get()) {
                    if (null != VoteEventImpl.this.voteCallBack) {
                        VoteEventImpl.this.voteCallBack.onVoteAdd(pGroup);
                    }
                } else {
                    VoteEventImpl.this.cacheVote(pGroup);
                }
            }
        });
    }

    @Override
    public void OnVoteDel(final VoteGroup pGroup, long optUser) {
        GenseeLog.i((String)TAG, (String)("OnVoteDel optUser " + optUser));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (null != VoteEventImpl.this.voteCallBack) {
                    VoteEventImpl.this.voteCallBack.onVoteDel(pGroup);
                }
            }
        });
    }

    @Override
    public void OnVotePublish(final VoteGroup pGroup, long optUser) {
        GenseeLog.i((String)TAG, (String)("OnVotePublish optUser " + optUser));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (!VoteEventImpl.this.bFirst.get()) {
                    if (null != VoteEventImpl.this.voteCallBack) {
                        VoteEventImpl.this.voteCallBack.onVotePublish(pGroup);
                    }
                } else {
                    VoteEventImpl.this.cacheVote(pGroup);
                }
            }
        });
    }

    @Override
    public void OnVotePublishResult(final VoteGroup pGroup, long optUser) {
        GenseeLog.i((String)TAG, (String)("OnVotePublishResult optUser " + optUser));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (!VoteEventImpl.this.bFirst.get()) {
                    if (null != VoteEventImpl.this.voteCallBack) {
                        VoteEventImpl.this.voteCallBack.onVotePublishResult(pGroup);
                    }
                } else {
                    VoteEventImpl.this.cacheVote(pGroup);
                }
            }
        });
    }

    @Override
    public void OnVoteSubmit(final VoteGroup pGroup, long optUser) {
        GenseeLog.i((String)TAG, (String)("OnVoteSubmit optUser " + optUser));
        if (null != this.voteCallBack) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    VoteEventImpl.this.voteCallBack.onVoteSubmit(pGroup);
                }
            });
        }
    }

    @Override
    public void OnVoteDeadline(final VoteGroup pGroup, long optUser) {
        GenseeLog.i((String)TAG, (String)("OnVoteDeadline optUser " + optUser));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (!VoteEventImpl.this.bFirst.get()) {
                    if (null != VoteEventImpl.this.voteCallBack) {
                        VoteEventImpl.this.voteCallBack.onVoteDeadline(pGroup);
                    }
                } else {
                    VoteEventImpl.this.cacheVote(pGroup);
                }
            }
        });
    }

    @Override
    public void OnVotePostUrl(final String strURL, final long optUser) {
        GenseeLog.i((String)TAG, (String)("OnVotePostUrl optUser " + optUser));
        if (null != this.voteCallBack) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    VoteEventImpl.this.voteCallBack.onVotePostUrl(strURL, optUser);
                }
            });
        }
    }

    public void cancelTimer() {
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void cacheVote(final VoteGroup voteMsg) {
        GenseeLog.i((String)TAG, (String)"cacheVote enter");
        this.postPool(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                10 var1_1 = this;
                synchronized (var1_1) {
                    boolean bTrue = false;
                    for (int i = 0; i < VoteEventImpl.this.cacheVoteList.size(); ++i) {
                        VoteGroup tempVoteMsg = (VoteGroup)VoteEventImpl.this.cacheVoteList.get(i);
                        if (!tempVoteMsg.getM_strId().equals(voteMsg.getM_strId())) continue;
                        bTrue = true;
                        VoteEventImpl.this.cacheVoteList.set(i, voteMsg);
                        break;
                    }
                    if (!bTrue) {
                        VoteEventImpl.this.cacheVoteList.add(voteMsg);
                    }
                }
            }
        });
    }

    @Override
    public void onCardPublish(final Card card) {
        GenseeLog.i((String)TAG, (String)("onCardPublish card " + card));
        if (null != this.voteCallBack) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    VoteEventImpl.this.voteCallBack.onCardPublish(card);
                }
            });
        }
    }

    @Override
    public void onCardResultPublish(final int type, final int totalSubmitted, final int[] itemSubmits, final int[] itemOptions) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                int nSize = itemSubmits.length;
                String ids = "";
                for (int id : itemSubmits) {
                    ids = ids + " " + id;
                }
                GenseeLog.i((String)TAG, (String)("onCardResultPublish nSize " + nSize + " ids = " + ids));
                if (null != VoteEventImpl.this.voteCallBack) {
                    VoteEventImpl.this.voteCallBack.onCardResultPublish(type, totalSubmitted, itemSubmits, itemOptions);
                }
            }
        });
    }

    @Override
    public void onCardSubmit(final long userId, final int[] itemids) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                int nSize = itemids.length;
                String ids = "";
                for (int id : itemids) {
                    ids = ids + " " + id;
                }
                GenseeLog.i((String)TAG, (String)("onCardSubmit nSize " + nSize + " ids = " + ids));
                if (null != VoteEventImpl.this.voteCallBack) {
                    VoteEventImpl.this.voteCallBack.onCardSubmit(userId, itemids);
                }
            }
        });
    }

    @Override
    public void onCardEnd() {
        GenseeLog.i((String)TAG, (String)"onCardEnd ");
        if (null != this.voteCallBack) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    VoteEventImpl.this.voteCallBack.onCardEnd();
                }
            });
        }
    }

    @Override
    public void onVieToAnswerFirstStart(final int durationSec, final int delaySec) {
        GenseeLog.i((String)TAG, (String)("onVieToAnswerFirstStart durationSec = " + durationSec + " delaySec = " + delaySec));
        if (this.voteCallBack != null) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    if (VoteEventImpl.this.voteCallBack != null) {
                        VoteEventImpl.this.voteCallBack.onVieToAnswerFirstStart(durationSec, delaySec);
                    }
                }
            });
        }
    }

    @Override
    public void onVieToAnswerFirstEnd() {
        GenseeLog.i((String)TAG, (String)"onVieToAnswerFirstEnd");
        if (this.voteCallBack != null) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    if (VoteEventImpl.this.voteCallBack != null) {
                        VoteEventImpl.this.voteCallBack.onVieToAnswerFirstEnd();
                    }
                }
            });
        }
    }

    @Override
    public void onVieToAnswerFirstSubmit(final long userId, final String userName) {
        GenseeLog.i((String)TAG, (String)("onVieToAnswerFirstSubmit userId=" + userId + " userName=" + userName));
        if (this.voteCallBack != null) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    if (VoteEventImpl.this.voteCallBack != null) {
                        VoteEventImpl.this.voteCallBack.onVieToAnswerFirstSubmit(userId, userName);
                    }
                }
            });
        }
    }
}

