/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.chat.gif;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.util.DisplayMetrics;
import android.util.Log;
import com.gensee.chat.gif.GifDrawalbe;
import com.gensee.chat.gif.GifHelper;
import com.gensee.chat.gif.SpanResource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class AbsChatResource {
    public static void setImageGetter(Html.ImageGetter imageGetter) {
        if (imageGetter == null) {
            imageGetter = new Html.ImageGetter(){

                public Drawable getDrawable(String source) {
                    Log.d((String)"AbsChatResource", (String)(" getDrawable " + source));
                    return null;
                }
            };
        }
        SpanResource.setExtraImageGetter(imageGetter);
    }

    protected void initResource(Context context) {
        this.initResource(context, null);
    }

    protected void initResource(Context context, Runnable runnable) {
        DisplayMetrics metric = new DisplayMetrics();
        metric = context.getResources().getDisplayMetrics();
        GifDrawalbe.ration = metric.density;
        this.initTextTipList(context);
        this.initSourceMaps(context);
    }

    private void initTextTipList(Context context) {
        ArrayList<String> textTipList = new ArrayList<String>();
        SpanResource.initTextTipList(textTipList);
    }

    protected abstract void onInitTextTips(Context var1, List<String> var2);

    private static Bitmap drawableToBitmap(Context context, Drawable drawable) {
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, width, height);
        drawable.draw(canvas);
        return bitmap;
    }

    private static Drawable zoomDrawable(Context context, Drawable drawable) {
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        Bitmap oldbmp = AbsChatResource.drawableToBitmap(context, drawable);
        Matrix matrix = new Matrix();
        float scaleWidth = (float)GifDrawalbe.ration;
        float scaleHeight = (float)GifDrawalbe.ration;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newbmp = Bitmap.createBitmap((Bitmap)oldbmp, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        BitmapDrawable returnDrawable = new BitmapDrawable(context.getResources(), newbmp);
        returnDrawable.setBounds(0, 0, returnDrawable.getIntrinsicWidth(), returnDrawable.getMinimumHeight());
        if (newbmp != oldbmp) {
            oldbmp.recycle();
            oldbmp = null;
        }
        return returnDrawable;
    }

    public String getString(Context context, int resId) {
        return context.getString(resId);
    }

    private void initSourceMaps(Context context) {
        List<Item> items = this.getItems();
        int size = items.size();
        HashMap<String, String> textMap = new HashMap<String, String>(size);
        LinkedHashMap<String, Integer> browMap = new LinkedHashMap<String, Integer>(size);
        HashMap<String, String> richSendMap = new HashMap<String, String>(size);
        LinkedHashMap<String, Drawable> uiMap = new LinkedHashMap<String, Drawable>(size);
        String key = null;
        Drawable drawable = null;
        String text = null;
        for (Item i : items) {
            if (i.stream == null) {
                key = this.getString(context, i.key);
                drawable = this.getDrawableByResource(context, key, i.drawale);
                text = this.getString(context, i.textId);
            } else {
                key = i.strKey;
                drawable = this.getDrawableByStream(context, key, i.stream);
                text = i.strText;
            }
            textMap.put(key, text);
            uiMap.put(key, drawable);
            richSendMap.put(key, i.path);
        }
        items.clear();
        SpanResource.initTextMap(textMap);
        SpanResource.initUiMap(uiMap);
        SpanResource.initBrowSource(browMap);
        SpanResource.initSendRichMap(richSendMap);
    }

    private Drawable getDrawableByResource(Context context, String key, int resDrawable) {
        Drawable bitmapDrawable = null;
        String tempKey = key.substring(1, key.length() - 1);
        if (tempKey.endsWith(".gif")) {
            bitmapDrawable = this.getPngDrawableForGif(context, key, resDrawable);
            if (bitmapDrawable == null) {
                GifDrawalbe gifDrawalbe = new GifDrawalbe(context, resDrawable);
                SpanResource.putGifDrawable(key, (Drawable)gifDrawalbe);
                Drawable drawable = gifDrawalbe.getFrame(0);
                bitmapDrawable = AbsChatResource.zoomDrawable(context, drawable);
            } else {
                SpanResource.putGifDrawable(key, bitmapDrawable);
            }
        } else {
            bitmapDrawable = context.getResources().getDrawable(resDrawable);
            bitmapDrawable.setBounds(0, 0, bitmapDrawable.getIntrinsicWidth(), bitmapDrawable.getIntrinsicWidth());
        }
        return bitmapDrawable;
    }

    private Drawable getDrawableByStream(Context context, String key, InputStream stream) {
        Drawable bitmapDrawable = null;
        String tempKey = key.substring(1, key.length() - 1);
        if (tempKey.endsWith(".gif")) {
            bitmapDrawable = this.getPngDrawableForGif(context, key, 0);
            if (bitmapDrawable == null) {
                GifDrawalbe gifDrawalbe = new GifDrawalbe(context, stream);
                SpanResource.putGifDrawable(key, (Drawable)gifDrawalbe);
                Drawable drawable = gifDrawalbe.getFrame(0);
                bitmapDrawable = AbsChatResource.zoomDrawable(context, drawable);
            } else {
                SpanResource.putGifDrawable(key, bitmapDrawable);
            }
        } else {
            BitmapDrawable drawable = new BitmapDrawable(stream);
            drawable.setTargetDensity(context.getResources().getDisplayMetrics());
            drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
            bitmapDrawable = AbsChatResource.zoomDrawable(context, (Drawable)drawable);
            GifHelper.closeStream(stream);
        }
        return bitmapDrawable;
    }

    protected Drawable getPngDrawableForGif(Context context, String key, int resId) {
        return null;
    }

    private List<Item> getItems() {
        ArrayList<Item> items = new ArrayList<Item>(36);
        this.onGenseeBrowInit(items);
        this.onExtraBrowInit(items);
        return items;
    }

    protected abstract void onGenseeBrowInit(List<Item> var1);

    protected abstract void onExtraBrowInit(List<Item> var1);

    public class Item {
        private int key;
        private String strKey;
        private int textId;
        private String strText;
        private int drawale;
        private InputStream stream;
        private String path;

        public Item(int key, int textId, int drawale, String path) {
            this.key = key;
            this.drawale = drawale;
            this.textId = textId;
            this.path = path;
        }

        public Item(String key, String text, InputStream stream, String path) {
            this.strKey = key;
            this.strText = text;
            this.path = path;
            this.stream = stream;
        }

        public Item(Item item) {
            this.key = item.key;
            this.drawale = item.drawale;
            this.textId = item.textId;
            this.path = item.path;
            this.strKey = item.strKey;
            this.strText = item.strText;
            this.stream = item.stream;
        }
    }
}

