/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.chat.gif;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import com.gensee.chat.gif.GifHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class GifDrawalbe
extends AnimationDrawable {
    public static double ration = 1.3333333333333333;
    private Context context;
    private AtomicBoolean bParsing = new AtomicBoolean(false);
    GifHelper helper;
    private List<UpdateUIListen> updateUIListenList;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (((Boolean)msg.obj).booleanValue()) {
                GifDrawalbe.this.start();
            }
            return false;
        }
    });

    public boolean isParsing() {
        return this.bParsing.get();
    }

    public GifDrawalbe(Context context, int id) {
        this(context, context.getResources().openRawResource(id));
    }

    public GifDrawalbe(Context context, InputStream stream) {
        this.context = context;
        this.bParsing.set(false);
        this.updateUIListenList = new ArrayList<UpdateUIListen>();
        this.setOneShot(false);
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)opts);
        this.setBounds(0, 0, (int)((double)opts.outWidth * ration), (int)((double)opts.outHeight * ration));
        try {
            stream.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.parseFrame(stream);
        this.invalidateSelf();
    }

    public void readFrames(boolean bStarted) {
        if (!this.bParsing.get()) {
            // empty if block
        }
        if (bStarted) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFrame(InputStream inputStream) {
        GifDrawalbe gifDrawalbe = this;
        synchronized (gifDrawalbe) {
            if (!this.bParsing.get()) {
                GifHelper helper = new GifHelper();
                helper.read(inputStream);
                int gifCount = helper.getFrameCount();
                if (gifCount <= 0) {
                    this.bParsing.set(false);
                    return;
                }
                Resources resources = this.context.getResources();
                BitmapDrawable bd = new BitmapDrawable(resources, helper.getImage());
                this.addFrame((Drawable)bd, helper.getDelay(0));
                for (int i = 1; i < helper.getFrameCount(); ++i) {
                    this.addFrame((Drawable)new BitmapDrawable(resources, helper.nextBitmap()), helper.getDelay(i));
                }
                this.bParsing.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        super.run();
        this.invalidateSelf();
        GifDrawalbe gifDrawalbe = this;
        synchronized (gifDrawalbe) {
            for (UpdateUIListen listen : this.updateUIListenList) {
                listen.updateUI();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListen(UpdateUIListen listen) {
        GifDrawalbe gifDrawalbe = this;
        synchronized (gifDrawalbe) {
            if (!this.updateUIListenList.contains(listen)) {
                this.updateUIListenList.add(listen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListen(UpdateUIListen listen) {
        GifDrawalbe gifDrawalbe = this;
        synchronized (gifDrawalbe) {
            this.updateUIListenList.remove(listen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSelf(Runnable what, long when) {
        GifDrawalbe gifDrawalbe = this;
        synchronized (gifDrawalbe) {
            if (this.updateUIListenList.size() <= 0) {
                this.stop();
                return;
            }
        }
        this.handler.postAtTime(what, when);
    }

    public static interface UpdateUIListen {
        public void updateUI();
    }
}

