/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.text.InputFilter;
import android.text.Spanned;
import android.util.AttributeSet;
import android.widget.EditText;
import com.gensee.chat.gif.SpanResource;
import com.gensee.entity.SendText;

public class ChatEditText
extends EditText {
    private OnSensitiveWordFilter mfilter;
    private SendText mSendText;

    public ChatEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public ChatEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ChatEditText(Context context) {
        super(context);
        this.init();
    }

    public void insertAvatar(String avatar, int resId) {
        this.getText().insert(this.getSelectionStart(), (CharSequence)SpanResource.convetToSpan(avatar.toString(), this.getContext()));
    }

    private void init() {
        this.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                int[] nAvatarCountOld = SpanResource.getAvatarCount(dest.toString());
                int totalCountOld = dest.toString().length() - nAvatarCountOld[1] + nAvatarCountOld[0];
                int[] nAvatarCountNew = SpanResource.getAvatarCount(source.toString());
                int totalCountNew = source.toString().length() - nAvatarCountNew[1] + nAvatarCountNew[0];
                int totalAvatarCount = nAvatarCountOld[0] + nAvatarCountNew[0];
                int totalCount = totalCountOld + totalCountNew;
                if (totalAvatarCount > 20 || totalCount > 512) {
                    return "";
                }
                return source;
            }
        }});
    }

    @Deprecated
    public String getChatText() {
        return this.getSendText().getChatText();
    }

    @Deprecated
    public String getRichText() {
        return this.getSendText().getRichText();
    }

    public SendText getSendText() {
        String text;
        if (this.mSendText == null) {
            this.mSendText = new SendText();
        }
        if ((text = this.getText().toString()).equals(this.mSendText.getSrc())) {
            return this.mSendText;
        }
        this.mSendText.setSrc(text);
        String chatText = "";
        String richText = "";
        if (!"".equals(text)) {
            OnSensitiveWordFilter f = this.mfilter;
            if (f != null) {
                text = f.onFilter(text);
            }
            chatText = SpanResource.convertToSendText(text);
            richText = SpanResource.convertToSendRichText(text);
        }
        this.mSendText.setRichText(richText);
        this.mSendText.setChatText(chatText);
        return this.mSendText;
    }

    public void setOnSensitiveWordFilter(OnSensitiveWordFilter mfilter) {
        this.mfilter = mfilter;
    }

    public static interface OnSensitiveWordFilter {
        public String onFilter(String var1);
    }
}

