/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.aid;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;
import com.ta.utdid2.android.utils.Base64;
import com.ta.utdid2.android.utils.Base64Helper;
import com.ta.utdid2.android.utils.DebugUtils;
import com.ta.utdid2.android.utils.SharedPreferenceHelper;
import com.ta.utdid2.android.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AidStorageController {
    private static final String TAG = AidStorageController.class.getName();
    private static final String PREF_AID = "OfJbkLdFbPOMbGyP";
    private static final String KEY_PREF_AID_VALUE = "EvQwnbilKezpOJey";
    private static final String KEY_PREF_AID_GEN_TIME = "rKrMJgyAEbVtSQGi";
    private static Map<String, String> sAidMapInSP = new ConcurrentHashMap<String, String>();
    private static Map<String, Long> sAidGenTimeMapInSP = new ConcurrentHashMap<String, Long>();

    public static void setAidValueToSP(Context context, String appName, String aidValue, String token) {
        if (context == null) {
            Log.e((String)TAG, (String)"no context!");
            return;
        }
        String encodedAppName = AidStorageController.getEncodedAppName(appName, token);
        long timeStamp = System.currentTimeMillis();
        sAidMapInSP.put(encodedAppName, aidValue);
        sAidGenTimeMapInSP.put(encodedAppName, timeStamp);
        SharedPreferences sp = context.getSharedPreferences(PREF_AID, 0);
        if (Build.VERSION.SDK_INT >= 9) {
            SharedPreferenceHelper.apply(sp.edit().putString(KEY_PREF_AID_VALUE.concat(encodedAppName), aidValue));
            SharedPreferenceHelper.apply(sp.edit().putLong(KEY_PREF_AID_GEN_TIME.concat(encodedAppName), timeStamp));
        } else {
            sp.edit().putString(KEY_PREF_AID_VALUE.concat(encodedAppName), aidValue).commit();
            sp.edit().putLong(KEY_PREF_AID_GEN_TIME.concat(encodedAppName), timeStamp).commit();
        }
    }

    public static String getAidValueFromSP(Context context, String appName, String token) {
        if (context == null) {
            Log.e((String)TAG, (String)"no context!");
            return "";
        }
        String encodedAppName = AidStorageController.getEncodedAppName(appName, token);
        String aidInSP = sAidMapInSP.get(encodedAppName);
        if (DebugUtils.DBG) {
            Log.d((String)TAG, (String)("cache AID:" + aidInSP));
        }
        if (StringUtils.isEmpty(aidInSP)) {
            SharedPreferences sp = context.getSharedPreferences(PREF_AID, 0);
            aidInSP = sp.getString(KEY_PREF_AID_VALUE.concat(encodedAppName), "");
            sAidMapInSP.put(encodedAppName, aidInSP);
        }
        return aidInSP;
    }

    public static long getAidGenTimeFromSP(Context context, String appName, String token) {
        if (context == null) {
            Log.e((String)TAG, (String)"no context!");
            return 0L;
        }
        String encodedAppName = AidStorageController.getEncodedAppName(appName, token);
        Long aidGenTimeInSP = sAidGenTimeMapInSP.containsKey(encodedAppName) ? sAidGenTimeMapInSP.get(encodedAppName) : 0L;
        if (DebugUtils.DBG) {
            Log.d((String)TAG, (String)("cache AIDGenTime:" + aidGenTimeInSP));
        }
        if (aidGenTimeInSP == 0L) {
            SharedPreferences sp = context.getSharedPreferences(PREF_AID, 0);
            aidGenTimeInSP = sp.getLong(KEY_PREF_AID_GEN_TIME.concat(encodedAppName), 0L);
            sAidGenTimeMapInSP.put(encodedAppName, aidGenTimeInSP);
        }
        return aidGenTimeInSP;
    }

    private static String getEncodedAppName(String appName, String token) {
        String encodedName = "";
        encodedName = Build.VERSION.SDK_INT >= 8 ? Base64Helper.encodeToString(appName.concat(token).getBytes(), 2) : Base64.encodeToString(appName.concat(token).getBytes(), 2);
        if (DebugUtils.DBG) {
            Log.d((String)TAG, (String)("encodedName:" + encodedName));
        }
        return encodedName;
    }
}

