/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model;

import master.flame.danmaku.danmaku.model.Duration;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.R2LDanmaku;

public class L2RDanmaku
extends R2LDanmaku {
    public L2RDanmaku(Duration duration) {
        super(duration);
    }

    @Override
    public void layout(IDisplayer displayer, float x, float y) {
        if (this.mTimer != null) {
            long currMS = this.mTimer.currMillisecond;
            long deltaDuration = currMS - this.time;
            if (deltaDuration > 0L && deltaDuration < this.duration.value) {
                this.x = this.getAccurateLeft(displayer, currMS);
                if (!this.isShown()) {
                    this.y = y;
                    this.setVisibility(true);
                }
                this.mLastTime = currMS;
                return;
            }
            this.mLastTime = currMS;
        }
        this.setVisibility(false);
    }

    @Override
    public float[] getRectAtTime(IDisplayer displayer, long time) {
        if (!this.isMeasured()) {
            return null;
        }
        float left = this.getAccurateLeft(displayer, time);
        if (this.RECT == null) {
            this.RECT = new float[4];
        }
        this.RECT[0] = left;
        this.RECT[1] = this.y;
        this.RECT[2] = left + this.paintWidth;
        this.RECT[3] = this.y + this.paintHeight;
        return this.RECT;
    }

    @Override
    protected float getAccurateLeft(IDisplayer displayer, long currTime) {
        long elapsedTime = currTime - this.time;
        if (elapsedTime >= this.duration.value) {
            return displayer.getWidth();
        }
        return this.mStepX * (float)elapsedTime - this.paintWidth;
    }

    @Override
    public float getLeft() {
        return this.x;
    }

    @Override
    public float getTop() {
        return this.y;
    }

    @Override
    public float getRight() {
        return this.x + this.paintWidth;
    }

    @Override
    public float getBottom() {
        return this.y + this.paintHeight;
    }

    @Override
    public int getType() {
        return 6;
    }
}

