/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model.android;

import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.Duration;
import master.flame.danmaku.danmaku.model.FBDanmaku;
import master.flame.danmaku.danmaku.model.FTDanmaku;
import master.flame.danmaku.danmaku.model.IDanmakuIterator;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.L2RDanmaku;
import master.flame.danmaku.danmaku.model.R2LDanmaku;
import master.flame.danmaku.danmaku.model.SpecialDanmaku;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;

public class DanmakuFactory {
    public static final float OLD_BILI_PLAYER_WIDTH = 539.0f;
    public static final float BILI_PLAYER_WIDTH = 682.0f;
    public static final float OLD_BILI_PLAYER_HEIGHT = 385.0f;
    public static final float BILI_PLAYER_HEIGHT = 438.0f;
    public static final long COMMON_DANMAKU_DURATION = 3800L;
    public static final int DANMAKU_MEDIUM_TEXTSIZE = 25;
    public static final long MIN_DANMAKU_DURATION = 4000L;
    public static final long MAX_DANMAKU_DURATION_HIGH_DENSITY = 9000L;
    public int CURRENT_DISP_WIDTH = 0;
    public int CURRENT_DISP_HEIGHT = 0;
    private float CURRENT_DISP_SIZE_FACTOR = 1.0f;
    public long REAL_DANMAKU_DURATION = 3800L;
    public long MAX_DANMAKU_DURATION = 4000L;
    public Duration MAX_Duration_Scroll_Danmaku;
    public Duration MAX_Duration_Fix_Danmaku;
    public Duration MAX_Duration_Special_Danmaku;
    public IDanmakus sSpecialDanmakus = new Danmakus();
    public IDisplayer sLastDisp;
    private DanmakuContext sLastConfig;

    static DanmakuFactory create() {
        return new DanmakuFactory();
    }

    protected DanmakuFactory() {
    }

    public void resetDurationsData() {
        this.sLastDisp = null;
        this.CURRENT_DISP_HEIGHT = 0;
        this.CURRENT_DISP_WIDTH = 0;
        this.sSpecialDanmakus.clear();
        this.MAX_Duration_Scroll_Danmaku = null;
        this.MAX_Duration_Fix_Danmaku = null;
        this.MAX_Duration_Special_Danmaku = null;
        this.MAX_DANMAKU_DURATION = 4000L;
    }

    public void notifyDispSizeChanged(DanmakuContext context) {
        this.sLastConfig = context;
        this.sLastDisp = context.getDisplayer();
        this.createDanmaku(1, context);
    }

    public BaseDanmaku createDanmaku(int type) {
        return this.createDanmaku(type, this.sLastConfig);
    }

    public BaseDanmaku createDanmaku(int type, DanmakuContext context) {
        if (context == null) {
            return null;
        }
        this.sLastConfig = context;
        this.sLastDisp = context.getDisplayer();
        return this.createDanmaku(type, this.sLastDisp.getWidth(), this.sLastDisp.getHeight(), this.CURRENT_DISP_SIZE_FACTOR, context.scrollSpeedFactor);
    }

    public BaseDanmaku createDanmaku(int type, IDisplayer disp, float viewportScale, float scrollSpeedFactor) {
        if (disp == null) {
            return null;
        }
        this.sLastDisp = disp;
        return this.createDanmaku(type, disp.getWidth(), disp.getHeight(), viewportScale, scrollSpeedFactor);
    }

    public BaseDanmaku createDanmaku(int type, int viewportWidth, int viewportHeight, float viewportScale, float scrollSpeedFactor) {
        return this.createDanmaku(type, (float)viewportWidth, (float)viewportHeight, viewportScale, scrollSpeedFactor);
    }

    public BaseDanmaku createDanmaku(int type, float viewportWidth, float viewportHeight, float viewportSizeFactor, float scrollSpeedFactor) {
        int oldDispWidth = this.CURRENT_DISP_WIDTH;
        int oldDispHeight = this.CURRENT_DISP_HEIGHT;
        boolean sizeChanged = this.updateViewportState(viewportWidth, viewportHeight, viewportSizeFactor);
        if (this.MAX_Duration_Scroll_Danmaku == null) {
            this.MAX_Duration_Scroll_Danmaku = new Duration(this.REAL_DANMAKU_DURATION);
            this.MAX_Duration_Scroll_Danmaku.setFactor(scrollSpeedFactor);
        } else if (sizeChanged) {
            this.MAX_Duration_Scroll_Danmaku.setValue(this.REAL_DANMAKU_DURATION);
        }
        if (this.MAX_Duration_Fix_Danmaku == null) {
            this.MAX_Duration_Fix_Danmaku = new Duration(3800L);
        }
        if (sizeChanged && viewportWidth > 0.0f) {
            this.updateMaxDanmakuDuration();
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            if (oldDispWidth > 0 && oldDispHeight > 0) {
                scaleX = viewportWidth / (float)oldDispWidth;
                scaleY = viewportHeight / (float)oldDispHeight;
            }
            if (viewportHeight > 0.0f) {
                this.updateSpecialDanmakusDate(scaleX, scaleY);
            }
        }
        BaseDanmaku instance = null;
        switch (type) {
            case 1: {
                instance = new R2LDanmaku(this.MAX_Duration_Scroll_Danmaku);
                break;
            }
            case 4: {
                instance = new FBDanmaku(this.MAX_Duration_Fix_Danmaku);
                break;
            }
            case 5: {
                instance = new FTDanmaku(this.MAX_Duration_Fix_Danmaku);
                break;
            }
            case 6: {
                instance = new L2RDanmaku(this.MAX_Duration_Scroll_Danmaku);
                break;
            }
            case 7: {
                instance = new SpecialDanmaku();
                this.sSpecialDanmakus.addItem(instance);
            }
        }
        return instance;
    }

    public boolean updateViewportState(float viewportWidth, float viewportHeight, float viewportSizeFactor) {
        boolean sizeChanged = false;
        if (this.CURRENT_DISP_WIDTH != (int)viewportWidth || this.CURRENT_DISP_HEIGHT != (int)viewportHeight || this.CURRENT_DISP_SIZE_FACTOR != viewportSizeFactor) {
            sizeChanged = true;
            this.REAL_DANMAKU_DURATION = (long)(3800.0f * (viewportSizeFactor * viewportWidth / 682.0f));
            this.REAL_DANMAKU_DURATION = Math.min(9000L, this.REAL_DANMAKU_DURATION);
            this.REAL_DANMAKU_DURATION = Math.max(4000L, this.REAL_DANMAKU_DURATION);
            this.CURRENT_DISP_WIDTH = (int)viewportWidth;
            this.CURRENT_DISP_HEIGHT = (int)viewportHeight;
            this.CURRENT_DISP_SIZE_FACTOR = viewportSizeFactor;
        }
        return sizeChanged;
    }

    private void updateSpecialDanmakusDate(float scaleX, float scaleY) {
        IDanmakus list = this.sSpecialDanmakus;
        IDanmakuIterator it = list.iterator();
        while (it.hasNext()) {
            SpecialDanmaku speicalDanmaku = (SpecialDanmaku)it.next();
            this.fillTranslationData(speicalDanmaku, speicalDanmaku.beginX, speicalDanmaku.beginY, speicalDanmaku.endX, speicalDanmaku.endY, speicalDanmaku.translationDuration, speicalDanmaku.translationStartDelay, scaleX, scaleY);
            SpecialDanmaku.LinePath[] linePaths = speicalDanmaku.linePaths;
            if (linePaths == null || linePaths.length <= 0) continue;
            int length = linePaths.length;
            float[][] points = new float[length + 1][2];
            int j = 0;
            while (j < length) {
                points[j] = linePaths[j].getBeginPoint();
                points[j + 1] = linePaths[j].getEndPoint();
                ++j;
            }
            DanmakuFactory.fillLinePathData(speicalDanmaku, points, scaleX, scaleY);
        }
    }

    public void updateMaxDanmakuDuration() {
        long maxScrollDuration = this.MAX_Duration_Scroll_Danmaku == null ? 0L : this.MAX_Duration_Scroll_Danmaku.value;
        long maxFixDuration = this.MAX_Duration_Fix_Danmaku == null ? 0L : this.MAX_Duration_Fix_Danmaku.value;
        long maxSpecialDuration = this.MAX_Duration_Special_Danmaku == null ? 0L : this.MAX_Duration_Special_Danmaku.value;
        this.MAX_DANMAKU_DURATION = Math.max(maxScrollDuration, maxFixDuration);
        this.MAX_DANMAKU_DURATION = Math.max(this.MAX_DANMAKU_DURATION, maxSpecialDuration);
        this.MAX_DANMAKU_DURATION = Math.max(3800L, this.MAX_DANMAKU_DURATION);
        this.MAX_DANMAKU_DURATION = Math.max(this.REAL_DANMAKU_DURATION, this.MAX_DANMAKU_DURATION);
    }

    public void updateDurationFactor(float f) {
        if (this.MAX_Duration_Scroll_Danmaku == null || this.MAX_Duration_Fix_Danmaku == null) {
            return;
        }
        this.MAX_Duration_Scroll_Danmaku.setFactor(f);
        this.updateMaxDanmakuDuration();
    }

    public void fillTranslationData(BaseDanmaku item, float beginX, float beginY, float endX, float endY, long translationDuration, long translationStartDelay, float scaleX, float scaleY) {
        if (item.getType() != 7) {
            return;
        }
        ((SpecialDanmaku)item).setTranslationData(beginX * scaleX, beginY * scaleY, endX * scaleX, endY * scaleY, translationDuration, translationStartDelay);
        this.updateSpecicalDanmakuDuration(item);
    }

    public static void fillLinePathData(BaseDanmaku item, float[][] points, float scaleX, float scaleY) {
        if (item.getType() != 7 || points.length == 0 || points[0].length != 2) {
            return;
        }
        int i = 0;
        while (i < points.length) {
            float[] fArray = points[i];
            fArray[0] = fArray[0] * scaleX;
            float[] fArray2 = points[i];
            fArray2[1] = fArray2[1] * scaleY;
            ++i;
        }
        ((SpecialDanmaku)item).setLinePathData(points);
    }

    public void fillAlphaData(BaseDanmaku item, int beginAlpha, int endAlpha, long alphaDuraion) {
        if (item.getType() != 7) {
            return;
        }
        ((SpecialDanmaku)item).setAlphaData(beginAlpha, endAlpha, alphaDuraion);
        this.updateSpecicalDanmakuDuration(item);
    }

    private void updateSpecicalDanmakuDuration(BaseDanmaku item) {
        if (this.MAX_Duration_Special_Danmaku == null || item.duration != null && item.duration.value > this.MAX_Duration_Special_Danmaku.value) {
            this.MAX_Duration_Special_Danmaku = item.duration;
            this.updateMaxDanmakuDuration();
        }
    }
}

