/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model.android;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.Danmaku;
import master.flame.danmaku.danmaku.model.IDanmakuIterator;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.util.DanmakuUtils;

public class Danmakus
implements IDanmakus {
    public static final int ST_BY_TIME = 0;
    public static final int ST_BY_YPOS = 1;
    public static final int ST_BY_YPOS_DESC = 2;
    public static final int ST_BY_LIST = 4;
    public Collection<BaseDanmaku> items;
    private Danmakus subItems;
    private BaseDanmaku startItem;
    private BaseDanmaku endItem;
    private BaseDanmaku endSubItem;
    private BaseDanmaku startSubItem;
    private DanmakuIterator iterator;
    private int mSize = 0;
    private int mSortType = 0;
    private BaseComparator mComparator;
    private boolean mDuplicateMergingEnabled;

    public Danmakus() {
        this(0, false);
    }

    public Danmakus(int sortType) {
        this(sortType, false);
    }

    public Danmakus(int sortType, boolean duplicateMergingEnabled) {
        BaseComparator comparator = null;
        if (sortType == 0) {
            comparator = new TimeComparator(duplicateMergingEnabled);
        } else if (sortType == 1) {
            comparator = new YPosComparator(duplicateMergingEnabled);
        } else if (sortType == 2) {
            comparator = new YPosDescComparator(duplicateMergingEnabled);
        }
        if (sortType == 4) {
            this.items = new ArrayList<BaseDanmaku>();
        } else {
            this.mDuplicateMergingEnabled = duplicateMergingEnabled;
            comparator.setDuplicateMergingEnabled(duplicateMergingEnabled);
            this.items = new TreeSet<BaseDanmaku>(comparator);
            this.mComparator = comparator;
        }
        this.mSortType = sortType;
        this.mSize = 0;
        this.iterator = new DanmakuIterator(this.items);
    }

    public Danmakus(Collection<BaseDanmaku> items) {
        this.setItems(items);
    }

    public Danmakus(boolean duplicateMergingEnabled) {
        this(0, duplicateMergingEnabled);
    }

    public void setItems(Collection<BaseDanmaku> items) {
        if (this.mDuplicateMergingEnabled && this.mSortType != 4) {
            this.items.clear();
            this.items.addAll(items);
            items = this.items;
        } else {
            this.items = items;
        }
        if (items instanceof List) {
            this.mSortType = 4;
        }
        int n = this.mSize = items == null ? 0 : items.size();
        if (this.iterator == null) {
            this.iterator = new DanmakuIterator(items);
        } else {
            this.iterator.setDatas(items);
        }
    }

    @Override
    public IDanmakuIterator iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    @Override
    public boolean addItem(BaseDanmaku item) {
        if (this.items != null) {
            try {
                if (this.items.add(item)) {
                    ++this.mSize;
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean removeItem(BaseDanmaku item) {
        if (item == null) {
            return false;
        }
        if (item.isOutside()) {
            item.setVisibility(false);
        }
        if (this.items.remove(item)) {
            --this.mSize;
            return true;
        }
        return false;
    }

    private Collection<BaseDanmaku> subset(long startTime, long endTime) {
        if (this.mSortType == 4 || this.items == null || this.items.size() == 0) {
            return null;
        }
        if (this.subItems == null) {
            this.subItems = new Danmakus(this.mDuplicateMergingEnabled);
        }
        if (this.startSubItem == null) {
            this.startSubItem = this.createItem("start");
        }
        if (this.endSubItem == null) {
            this.endSubItem = this.createItem("end");
        }
        this.startSubItem.time = startTime;
        this.endSubItem.time = endTime;
        return ((SortedSet)this.items).subSet(this.startSubItem, this.endSubItem);
    }

    @Override
    public IDanmakus subnew(long startTime, long endTime) {
        Collection<BaseDanmaku> subset = this.subset(startTime, endTime);
        if (subset == null || subset.isEmpty()) {
            return null;
        }
        ArrayList<BaseDanmaku> newSet = new ArrayList<BaseDanmaku>(subset);
        return new Danmakus(newSet);
    }

    @Override
    public IDanmakus sub(long startTime, long endTime) {
        long dtime;
        if (this.items == null || this.items.size() == 0) {
            return null;
        }
        if (this.subItems == null) {
            if (this.mSortType == 4) {
                this.subItems = new Danmakus(4);
                this.subItems.setItems(this.items);
            } else {
                this.subItems = new Danmakus(this.mDuplicateMergingEnabled);
            }
        }
        if (this.mSortType == 4) {
            return this.subItems;
        }
        if (this.startItem == null) {
            this.startItem = this.createItem("start");
        }
        if (this.endItem == null) {
            this.endItem = this.createItem("end");
        }
        if (this.subItems != null && (dtime = startTime - this.startItem.time) >= 0L && endTime <= this.endItem.time) {
            return this.subItems;
        }
        this.startItem.time = startTime;
        this.endItem.time = endTime;
        this.subItems.setItems(((SortedSet)this.items).subSet(this.startItem, this.endItem));
        return this.subItems;
    }

    private BaseDanmaku createItem(String text) {
        return new Danmaku(text);
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public void clear() {
        if (this.items != null) {
            this.items.clear();
            this.mSize = 0;
            this.iterator = new DanmakuIterator(this.items);
        }
        if (this.subItems != null) {
            this.subItems = null;
            this.startItem = this.createItem("start");
            this.endItem = this.createItem("end");
        }
    }

    @Override
    public BaseDanmaku first() {
        if (this.items != null && !this.items.isEmpty()) {
            if (this.mSortType == 4) {
                return (BaseDanmaku)((ArrayList)this.items).get(0);
            }
            return (BaseDanmaku)((SortedSet)this.items).first();
        }
        return null;
    }

    @Override
    public BaseDanmaku last() {
        if (this.items != null && !this.items.isEmpty()) {
            if (this.mSortType == 4) {
                return (BaseDanmaku)((ArrayList)this.items).get(this.items.size() - 1);
            }
            return (BaseDanmaku)((SortedSet)this.items).last();
        }
        return null;
    }

    @Override
    public boolean contains(BaseDanmaku item) {
        return this.items != null && this.items.contains(item);
    }

    @Override
    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    private void setDuplicateMergingEnabled(boolean enable) {
        this.mComparator.setDuplicateMergingEnabled(enable);
        this.mDuplicateMergingEnabled = enable;
    }

    @Override
    public void setSubItemsDuplicateMergingEnabled(boolean enable) {
        this.mDuplicateMergingEnabled = enable;
        this.endItem = null;
        this.startItem = null;
        if (this.subItems == null) {
            this.subItems = new Danmakus(enable);
        }
        this.subItems.setDuplicateMergingEnabled(enable);
    }

    private class BaseComparator
    implements Comparator<BaseDanmaku> {
        protected boolean mDuplicateMergingEnable;

        public BaseComparator(boolean duplicateMergingEnabled) {
            this.setDuplicateMergingEnabled(duplicateMergingEnabled);
        }

        public void setDuplicateMergingEnabled(boolean enable) {
            this.mDuplicateMergingEnable = enable;
        }

        @Override
        public int compare(BaseDanmaku obj1, BaseDanmaku obj2) {
            if (this.mDuplicateMergingEnable && DanmakuUtils.isDuplicate(obj1, obj2)) {
                return 0;
            }
            return DanmakuUtils.compare(obj1, obj2);
        }
    }

    private class DanmakuIterator
    implements IDanmakuIterator {
        private Collection<BaseDanmaku> mData;
        private Iterator<BaseDanmaku> it;
        private boolean mIteratorUsed;

        public DanmakuIterator(Collection<BaseDanmaku> datas) {
            this.setDatas(datas);
        }

        @Override
        public synchronized void reset() {
            if (!this.mIteratorUsed && this.it != null) {
                return;
            }
            this.it = this.mData != null && Danmakus.this.mSize > 0 ? this.mData.iterator() : null;
            this.mIteratorUsed = false;
        }

        public synchronized void setDatas(Collection<BaseDanmaku> datas) {
            if (this.mData != datas) {
                this.mIteratorUsed = false;
                this.it = null;
            }
            this.mData = datas;
        }

        @Override
        public synchronized BaseDanmaku next() {
            this.mIteratorUsed = true;
            return this.it != null ? this.it.next() : null;
        }

        @Override
        public synchronized boolean hasNext() {
            return this.it != null && this.it.hasNext();
        }

        @Override
        public synchronized void remove() {
            this.mIteratorUsed = true;
            if (this.it != null) {
                this.it.remove();
                Danmakus danmakus = Danmakus.this;
                danmakus.mSize = danmakus.mSize - 1;
            }
        }
    }

    private class TimeComparator
    extends BaseComparator {
        public TimeComparator(boolean duplicateMergingEnabled) {
            super(duplicateMergingEnabled);
        }

        @Override
        public int compare(BaseDanmaku obj1, BaseDanmaku obj2) {
            return super.compare(obj1, obj2);
        }
    }

    private class YPosComparator
    extends BaseComparator {
        public YPosComparator(boolean duplicateMergingEnabled) {
            super(duplicateMergingEnabled);
        }

        @Override
        public int compare(BaseDanmaku obj1, BaseDanmaku obj2) {
            if (this.mDuplicateMergingEnable && DanmakuUtils.isDuplicate(obj1, obj2)) {
                return 0;
            }
            return Float.compare(obj1.getTop(), obj2.getTop());
        }
    }

    private class YPosDescComparator
    extends BaseComparator {
        public YPosDescComparator(boolean duplicateMergingEnabled) {
            super(duplicateMergingEnabled);
        }

        @Override
        public int compare(BaseDanmaku obj1, BaseDanmaku obj2) {
            if (this.mDuplicateMergingEnable && DanmakuUtils.isDuplicate(obj1, obj2)) {
                return 0;
            }
            return Float.compare(obj2.getTop(), obj1.getTop());
        }
    }
}

