/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model.android;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import tv.cjump.jni.NativeBitmapFactory;

public class DrawingCacheHolder {
    public Canvas canvas;
    public Bitmap bitmap;
    public Bitmap[][] bitmapArray;
    public Object extra;
    public int width;
    public int height;
    public boolean drawn;
    private int mDensity;

    public DrawingCacheHolder() {
    }

    public DrawingCacheHolder(int w, int h) {
        this.buildCache(w, h, 0, true);
    }

    public DrawingCacheHolder(int w, int h, int density) {
        this.mDensity = density;
        this.buildCache(w, h, density, true);
    }

    public void buildCache(int w, int h, int density, boolean checkSizeEquals) {
        boolean reuse;
        boolean bl = checkSizeEquals ? w == this.width && h == this.height : (reuse = w <= this.width && h <= this.height);
        if (reuse && this.bitmap != null) {
            this.bitmap.eraseColor(0);
            this.canvas.setBitmap(this.bitmap);
            this.recycleBitmapArray();
            return;
        }
        if (this.bitmap != null) {
            this.recycle();
        }
        this.width = w;
        this.height = h;
        this.bitmap = NativeBitmapFactory.createBitmap(w, h, Bitmap.Config.ARGB_8888);
        if (density > 0) {
            this.mDensity = density;
            this.bitmap.setDensity(density);
        }
        if (this.canvas == null) {
            this.canvas = new Canvas(this.bitmap);
            this.canvas.setDensity(density);
        } else {
            this.canvas.setBitmap(this.bitmap);
        }
    }

    public void erase() {
        this.eraseBitmap(this.bitmap);
        this.eraseBitmapArray();
    }

    public synchronized void recycle() {
        Bitmap bitmapReserve = this.bitmap;
        this.bitmap = null;
        this.height = 0;
        this.width = 0;
        if (bitmapReserve != null) {
            bitmapReserve.recycle();
        }
        this.recycleBitmapArray();
        this.extra = null;
    }

    @SuppressLint(value={"NewApi"})
    public void splitWith(int dispWidth, int dispHeight, int maximumCacheWidth, int maximumCacheHeight) {
        this.recycleBitmapArray();
        if (this.width <= 0 || this.height <= 0 || this.bitmap == null) {
            return;
        }
        if (this.width <= maximumCacheWidth && this.height <= maximumCacheHeight) {
            return;
        }
        maximumCacheWidth = Math.min(maximumCacheWidth, dispWidth);
        maximumCacheHeight = Math.min(maximumCacheHeight, dispHeight);
        int xCount = this.width / maximumCacheWidth + (this.width % maximumCacheWidth == 0 ? 0 : 1);
        int yCount = this.height / maximumCacheHeight + (this.height % maximumCacheHeight == 0 ? 0 : 1);
        int averageWidth = this.width / xCount;
        int averageHeight = this.height / yCount;
        Bitmap[][] bmpArray = new Bitmap[yCount][xCount];
        if (this.canvas == null) {
            this.canvas = new Canvas();
            if (this.mDensity > 0) {
                this.canvas.setDensity(this.mDensity);
            }
        }
        Rect rectSrc = new Rect();
        Rect rectDst = new Rect();
        int yIndex = 0;
        while (yIndex < yCount) {
            int xIndex = 0;
            while (xIndex < xCount) {
                Bitmap bitmap = NativeBitmapFactory.createBitmap(averageWidth, averageHeight, Bitmap.Config.ARGB_8888);
                bmpArray[yIndex][xIndex] = bitmap;
                Bitmap bmp = bitmap;
                if (this.mDensity > 0) {
                    bmp.setDensity(this.mDensity);
                }
                this.canvas.setBitmap(bmp);
                int left = xIndex * averageWidth;
                int top = yIndex * averageHeight;
                rectSrc.set(left, top, left + averageWidth, top + averageHeight);
                rectDst.set(0, 0, bmp.getWidth(), bmp.getHeight());
                this.canvas.drawBitmap(this.bitmap, rectSrc, rectDst, null);
                ++xIndex;
            }
            ++yIndex;
        }
        this.canvas.setBitmap(this.bitmap);
        this.bitmapArray = bmpArray;
    }

    private void eraseBitmap(Bitmap bmp) {
        if (bmp != null) {
            bmp.eraseColor(0);
        }
    }

    private void eraseBitmapArray() {
        if (this.bitmapArray != null) {
            int i = 0;
            while (i < this.bitmapArray.length) {
                int j = 0;
                while (j < this.bitmapArray[i].length) {
                    this.eraseBitmap(this.bitmapArray[i][j]);
                    ++j;
                }
                ++i;
            }
        }
    }

    private void recycleBitmapArray() {
        Bitmap[][] bitmapArrayReserve = this.bitmapArray;
        this.bitmapArray = null;
        if (bitmapArrayReserve != null) {
            int i = 0;
            while (i < bitmapArrayReserve.length) {
                int j = 0;
                while (j < bitmapArrayReserve[i].length) {
                    if (bitmapArrayReserve[i][j] != null) {
                        bitmapArrayReserve[i][j].recycle();
                        bitmapArrayReserve[i][j] = null;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public final synchronized boolean draw(Canvas canvas, float left, float top, Paint paint) {
        if (this.bitmapArray != null) {
            int i = 0;
            while (i < this.bitmapArray.length) {
                int j = 0;
                while (j < this.bitmapArray[i].length) {
                    float dtop;
                    float dleft;
                    Bitmap bmp = this.bitmapArray[i][j];
                    if (!(bmp == null || (dleft = left + (float)(j * bmp.getWidth())) > (float)canvas.getWidth() || dleft + (float)bmp.getWidth() < 0.0f || (dtop = top + (float)(i * bmp.getHeight())) > (float)canvas.getHeight() || dtop + (float)bmp.getHeight() < 0.0f)) {
                        canvas.drawBitmap(bmp, dleft, dtop, paint);
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        if (this.bitmap != null) {
            canvas.drawBitmap(this.bitmap, left, top, paint);
            return true;
        }
        return false;
    }
}

