/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.parser.android;

import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.parser.android.JSONSource;
import master.flame.danmaku.danmaku.util.DanmakuUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AcFunDanmakuParser
extends BaseDanmakuParser {
    @Override
    public Danmakus parse() {
        if (this.mDataSource != null && this.mDataSource instanceof JSONSource) {
            JSONSource jsonSource = (JSONSource)this.mDataSource;
            return this.doParse(jsonSource.data());
        }
        return new Danmakus();
    }

    private Danmakus doParse(JSONArray danmakuListData) {
        Danmakus danmakus = new Danmakus();
        if (danmakuListData == null || danmakuListData.length() == 0) {
            return danmakus;
        }
        int i = 0;
        while (i < danmakuListData.length()) {
            try {
                JSONObject danmakuArray = danmakuListData.getJSONObject(i);
                if (danmakuArray != null) {
                    danmakus = this._parse(danmakuArray, danmakus);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return danmakus;
    }

    private Danmakus _parse(JSONObject jsonObject, Danmakus danmakus) {
        if (danmakus == null) {
            danmakus = new Danmakus();
        }
        if (jsonObject == null || jsonObject.length() == 0) {
            return danmakus;
        }
        int i = 0;
        while (i < jsonObject.length()) {
            try {
                int type;
                JSONObject obj = jsonObject;
                String c = obj.getString("c");
                String[] values = c.split(",");
                if (values.length > 0 && (type = Integer.parseInt(values[2])) != 7) {
                    long time = (long)(Float.parseFloat(values[0]) * 1000.0f);
                    int color = Integer.parseInt(values[1]) | 0xFF000000;
                    float textSize = Float.parseFloat(values[3]);
                    BaseDanmaku item = this.mContext.mDanmakuFactory.createDanmaku(type, this.mContext);
                    if (item != null) {
                        item.time = time;
                        item.textSize = textSize * (this.mDispDensity - 0.6f);
                        item.textColor = color;
                        item.textShadowColor = color <= -16777216 ? -1 : -16777216;
                        DanmakuUtils.fillText(item, obj.optString("m", "...."));
                        item.index = i;
                        item.setTimer(this.mTimer);
                        danmakus.addItem(item);
                    }
                }
            }
            catch (JSONException jSONException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        return danmakus;
    }
}

