/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.parser.android;

import android.net.Uri;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import master.flame.danmaku.danmaku.parser.IDataSource;
import master.flame.danmaku.danmaku.util.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;

public class JSONSource
implements IDataSource<JSONArray> {
    private JSONArray mJSONArray;
    private InputStream mInput;

    public JSONSource(String json) throws JSONException {
        this.init(json);
    }

    public JSONSource(InputStream in) throws JSONException {
        this.init(in);
    }

    private void init(InputStream in) throws JSONException {
        if (in == null) {
            throw new NullPointerException("input stream cannot be null!");
        }
        this.mInput = in;
        String json = IOUtils.getString(this.mInput);
        this.init(json);
    }

    public JSONSource(URL url) throws JSONException, IOException {
        this(url.openStream());
    }

    public JSONSource(File file) throws FileNotFoundException, JSONException {
        this.init(new FileInputStream(file));
    }

    public JSONSource(Uri uri) throws IOException, JSONException {
        String scheme = uri.getScheme();
        if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            this.init(new URL(uri.getPath()).openStream());
        } else if ("file".equalsIgnoreCase(scheme)) {
            this.init(new FileInputStream(uri.getPath()));
        }
    }

    private void init(String json) throws JSONException {
        if (!TextUtils.isEmpty((CharSequence)json)) {
            this.mJSONArray = new JSONArray(json);
        }
    }

    @Override
    public JSONArray data() {
        return this.mJSONArray;
    }

    @Override
    public void release() {
        IOUtils.closeQuietly(this.mInput);
        this.mInput = null;
        this.mJSONArray = null;
    }
}

