/*
 * Decompiled with CFR 0.152.
 */
package tv.cjump.jni;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;

public class DeviceUtils {
    public static final String ABI_X86 = "x86";
    public static final String ABI_MIPS = "mips";
    private static ARCH sArch = ARCH.Unknown;
    private static final int EM_ARM = 40;
    private static final int EM_386 = 3;
    private static final int EM_MIPS = 8;
    private static final int EM_AARCH64 = 183;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ARCH getMyCpuArch() {
        byte[] data = new byte[20];
        File libc = new File(Environment.getRootDirectory(), "lib/libc.so");
        if (!libc.canRead()) return sArch;
        RandomAccessFile fp = null;
        try {
            try {
                fp = new RandomAccessFile(libc, "r");
                fp.readFully(data);
                int machine = data[19] << 8 | data[18];
                switch (machine) {
                    case 40: {
                        sArch = ARCH.ARM;
                        return sArch;
                    }
                    case 3: {
                        sArch = ARCH.X86;
                        return sArch;
                    }
                    case 8: {
                        sArch = ARCH.MIPS;
                        return sArch;
                    }
                    case 183: {
                        sArch = ARCH.ARM64;
                        return sArch;
                    }
                    default: {
                        Log.e((String)"NativeBitmapFactory", (String)("libc.so is unknown arch: " + Integer.toHexString(machine)));
                        return sArch;
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (fp == null) return sArch;
                try {
                    fp.close();
                    return sArch;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return sArch;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fp == null) return sArch;
                try {
                    fp.close();
                    return sArch;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return sArch;
            }
        }
        finally {
            if (fp != null) {
                try {
                    fp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String get_CPU_ABI() {
        return Build.CPU_ABI;
    }

    public static String get_CPU_ABI2() {
        Object fieldValue;
        block5: {
            Field field;
            block4: {
                try {
                    field = Build.class.getDeclaredField("CPU_ABI2");
                    if (field != null) break block4;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            fieldValue = field.get(null);
            if (fieldValue instanceof String) break block5;
            return null;
        }
        return (String)fieldValue;
    }

    public static boolean supportABI(String requestAbi) {
        String abi = DeviceUtils.get_CPU_ABI();
        if (!TextUtils.isEmpty((CharSequence)abi) && abi.equalsIgnoreCase(requestAbi)) {
            return true;
        }
        String abi2 = DeviceUtils.get_CPU_ABI2();
        return !TextUtils.isEmpty((CharSequence)abi2) && abi.equalsIgnoreCase(requestAbi);
    }

    public static boolean supportX86() {
        return DeviceUtils.supportABI(ABI_X86);
    }

    public static boolean supportMips() {
        return DeviceUtils.supportABI(ABI_MIPS);
    }

    public static boolean isARMSimulatedByX86() {
        ARCH arch = DeviceUtils.getMyCpuArch();
        return !DeviceUtils.supportX86() && ARCH.X86.equals((Object)arch);
    }

    public static boolean isMiBox2Device() {
        String manufacturer = Build.MANUFACTURER;
        String productName = Build.PRODUCT;
        return manufacturer.equalsIgnoreCase("Xiaomi") && productName.equalsIgnoreCase("dredd");
    }

    public static boolean isMagicBoxDevice() {
        String manufacturer = Build.MANUFACTURER;
        String productName = Build.PRODUCT;
        return manufacturer.equalsIgnoreCase("MagicBox") && productName.equalsIgnoreCase("MagicBox");
    }

    public static boolean isProblemBoxDevice() {
        return DeviceUtils.isMiBox2Device() || DeviceUtils.isMagicBoxDevice();
    }

    public static boolean isRealARMArch() {
        ARCH arch = DeviceUtils.getMyCpuArch();
        return (DeviceUtils.supportABI("armeabi-v7a") || DeviceUtils.supportABI("armeabi")) && ARCH.ARM.equals((Object)arch);
    }

    public static boolean isRealX86Arch() {
        ARCH arch = DeviceUtils.getMyCpuArch();
        return DeviceUtils.supportABI(ABI_X86) || ARCH.X86.equals((Object)arch);
    }

    public static enum ARCH {
        Unknown,
        ARM,
        X86,
        MIPS,
        ARM64;

    }
}

