/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.core;

import android.content.Context;
import android.content.Intent;
import com.gensee.common.ServiceType;
import com.gensee.entity.InitParam;
import com.gensee.fastsdk.entity.OfflinePlayParam;
import com.gensee.fastsdk.ui.VodActivity;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;
import java.io.Serializable;

public class GenseeVod {
    private static final String TAG = "GenseeVod";

    public static void startVod(Context context, InitParam initParam) {
        if (context == null || initParam == null || !initParam.isValid()) {
            GenseeLog.e((String)TAG, (String)("startVod param is invalide context = " + context + " onlinePlayParam = " + initParam));
        } else {
            GenseeVod.play(context, initParam, null);
        }
    }

    public static void startVod(Context context, OfflinePlayParam offlinePlayParam) {
        if (context == null || offlinePlayParam == null || !offlinePlayParam.isValid()) {
            GenseeLog.e((String)TAG, (String)("startVod param is invalide context = " + context + " offlinePlayParam = " + offlinePlayParam));
        } else {
            GenseeVod.play(context, null, offlinePlayParam);
        }
    }

    private static void play(Context context, InitParam onlineParam, OfflinePlayParam offlinePlayParam) {
        PreferUtil.initPref(context.getApplicationContext());
        ResManager.getIns().init(context);
        Intent intent = new Intent();
        if (onlineParam != null) {
            PreferUtil.getIns().putInt("KEY_SERVICE_TYPE", onlineParam.getServiceType() == ServiceType.TRAINING ? 1 : 0);
            intent.putExtra("VOD_JOIN_ONLINE_PARAM", (Serializable)onlineParam);
        } else {
            intent.putExtra("VOD_JOIN_OFFLINE_PARAM", (Serializable)offlinePlayParam);
        }
        intent.setClass(context, VodActivity.class);
        context.startActivity(intent);
    }
}

