/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.core;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import com.gensee.common.RTSharedPref;
import com.gensee.common.ServiceType;
import com.gensee.entity.BroadCastMsg;
import com.gensee.entity.InitParam;
import com.gensee.entity.LiveInfo;
import com.gensee.entity.LoginResEntity;
import com.gensee.entity.PayInfo;
import com.gensee.entity.PingEntity;
import com.gensee.entity.RewardResult;
import com.gensee.entity.qa.RtQaMsg;
import com.gensee.fastsdk.core.GSFastConfig;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.entity.GSMoreItem;
import com.gensee.fastsdk.ui.BaseWatchActivity;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.chat.AbsChatImpl;
import com.gensee.fastsdk.ui.holder.chat.impl.PlayerChatImpl;
import com.gensee.fastsdk.ui.holder.idc.IdcWhiteHolder;
import com.gensee.fastsdk.ui.portrait.WatchActivity;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.qa.impl.AbstractQaImpl;
import com.gensee.player.IPlayerModule;
import com.gensee.player.OnChatListener;
import com.gensee.player.OnPlayListener;
import com.gensee.player.Player;
import com.gensee.player.VideoRate;
import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import com.gensee.view.ChatEditText;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.LocalTextureVideoView;
import com.gensee.vote.OnVoteListener;
import com.gensee.vote.VotePlayerGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class PlayerLive
implements OnPlayListener,
ChatEditText.OnSensitiveWordFilter {
    public static final String GS_FAST_CONFIG = "GS_FAST_CONFIG";
    public static final String GS_INIT_PARAM = "GS_INIT_PARAM";
    private static final String TAG = "PlayerLive";
    public static final int S_IDLE = 1;
    public static final int S_JOIN_BEGIN = 2;
    public static final int S_JOINED = 3;
    public static final int S_RECONNECTING = 4;
    public static final int WHAT_0 = 0;
    public static final int WHAT_ERROR = 1;
    public static final int WHAT_JOIN = 2;
    public static final int WHAT_RECONNECT = 3;
    public static final int WHAT_VIDEO_START = 5;
    public static final int WHAT_VIDEO_END = 6;
    public static final int WHAT_SUBJECT = 7;
    public static final int WHAT_PUBLISH = 8;
    public static final int WHAT_LEAVE = 10;
    public static final int WHAT_SIZE_CHANGE = 11;
    public static final int WHAT_CACHING = 12;
    public static final int WHAT_CACHING_COMPLETE = 13;
    public static final int WHAT_MIC_NOTIFY = 14;
    public static final int WHAT_INVITE_AUDIO = 15;
    public static final int WHAT_INVITE_VIDEO = 16;
    public static final int WHAT_INVITE_MUTI = 17;
    public static final int WHAT_ON_PAGESIZE = 18;
    public static final int WHAT_ON_DOC_SWITCH = 19;
    public static final int WHAT_ON_LIVE_INFO = 20;
    public static final int MIC_NOTIFY_OPEN = 1;
    public static final int MIC_NOTIFY_CLOSE = 2;
    public static final int MIC_NOTIFY_FAILED = 3;
    private static final int AUIDO_JOIN = 1;
    public static final int INVITE_TYPE_AUDIO = 1;
    public static final int INVITE_TYPE_VIDEO = 2;
    public static final int INVITE_TYPE_MUTI = 3;
    private static final int AUIDO_MICAVAILABLE = 2;
    private static final int AUIDO_MIC_OPENED = 4;
    private static final int AUIDO_MIC_REOPEN = 8;
    private static final int VIDEO_START = 32;
    private static final int VIDEO_CAMERA_OPEN = 64;
    private static final int VIDEO_CAMERA_REOPEN = 128;
    private static PlayerLive ins;
    private boolean isPublishMode;
    private boolean isHardEncode;
    private int publishMode;
    private int publishQuality;
    private ServiceType serviceType;
    private int[] fixedMoneyArray;
    private boolean isShowFixMoneyPanel;
    private int dashangEnable;
    private RTLive.OnDashangEnableListener onDashangEnableListener;
    private int watchMode;
    private boolean isShowDoc = true;
    private boolean isShowChat = true;
    private boolean isShowQa = true;
    private boolean isShowIntro = true;
    private boolean isShowPIP = true;
    private boolean isShowHand = true;
    private boolean isShowRateSwitch = true;
    private boolean isShownetSwitch = true;
    private boolean isShowDanmuBtn = true;
    private boolean isShowCloseVideo = true;
    private boolean bBarrageEnable;
    private InitParam initParam;
    private OnLocalVideoListener onLocalVideoListener;
    private Handler roomHandler;
    private Player mPlayer;
    private AbsChatImpl chatImpl;
    private AtomicInteger liveStatus = new AtomicInteger(1);
    private Context context;
    private ArrayList<IdcWhiteHolder.FastIdc> idcList;
    private int avFlag = 0;
    private OnUserJoinLeaveListener onUserLeaveListener;
    private OnRollcallListener onRollcallListener;
    private OnDocListener onDocListener;
    private OnRoomHandupListener onRoomHandupListener;
    private OnAudioVideoListener onAudioVideoListener;
    private int nOpenMicVideoType = 0;
    private int skinType;
    private String liveId;
    private GSFastConfig gsFastConfig;
    private OnLotteryListener onLotteryListener;
    private GSFastConfig.onPlayerVoteCommitListener onPlayerVoteCommitListener;
    private List<GSMoreItem> extraGSMoreItems;

    public GSFastConfig getGsFastConfig() {
        return this.gsFastConfig;
    }

    public void setGsFastConfig(GSFastConfig gsFastConfig) {
        this.gsFastConfig = gsFastConfig;
    }

    public String getLiveId() {
        return this.liveId;
    }

    public GSFastConfig.onPlayerVoteCommitListener getOnPlayerVoteCommitListener() {
        return this.onPlayerVoteCommitListener;
    }

    public List<GSMoreItem> getExtraGSMoreItems() {
        return this.extraGSMoreItems;
    }

    public void setOnLotteryListener(OnLotteryListener onLotteryListener) {
        this.onLotteryListener = onLotteryListener;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public boolean isShowChat() {
        return this.isShowChat;
    }

    public boolean isShowQa() {
        return this.isShowQa;
    }

    public boolean isShowIntro() {
        return this.isShowIntro;
    }

    public boolean isShowHand() {
        return this.isShowHand;
    }

    public boolean isShowRateSwitch() {
        return this.isShowRateSwitch;
    }

    public boolean isShownetSwitch() {
        return this.isShownetSwitch;
    }

    public boolean isShowDanmuBtn() {
        return this.isShowDanmuBtn;
    }

    public boolean isShowFixMoneyPanel() {
        return this.isShowFixMoneyPanel;
    }

    public boolean isShowCloseVideo() {
        return this.isShowCloseVideo;
    }

    public void setShowCloseVideo(boolean showCloseVideo) {
        this.isShowCloseVideo = showCloseVideo;
    }

    public void setShowFixMoneyPanel(boolean showFixMoneyPanel) {
        this.isShowFixMoneyPanel = showFixMoneyPanel;
    }

    public int[] getFixedMoneyArray() {
        return this.fixedMoneyArray;
    }

    public void setOnAudioVideoListener(OnAudioVideoListener onAudioVideoListener) {
        this.onAudioVideoListener = onAudioVideoListener;
    }

    public void setOnRoomHandupListener(OnRoomHandupListener onRoomHandupListener) {
        this.onRoomHandupListener = onRoomHandupListener;
    }

    public void setOnDocListener(OnDocListener onDocListener) {
        this.onDocListener = onDocListener;
    }

    public void setOnRollcallListener(OnRollcallListener onRollcallListener) {
        this.onRollcallListener = onRollcallListener;
    }

    public ArrayList<IdcWhiteHolder.FastIdc> getIdcList() {
        return this.idcList;
    }

    public void setOnUserLeaveListener(OnUserJoinLeaveListener onUserLeaveListener) {
        this.onUserLeaveListener = onUserLeaveListener;
    }

    public Player getmPlayer() {
        return this.mPlayer;
    }

    public void setLiveStatus(int liveStatus) {
        this.liveStatus.set(liveStatus);
    }

    public int getLiveStatus() {
        return this.liveStatus.get();
    }

    public void setOnLocalVideoListener(OnLocalVideoListener onLocalVideoListener) {
        this.onLocalVideoListener = onLocalVideoListener;
    }

    public AbsChatImpl getChatImpl() {
        return this.chatImpl;
    }

    public InitParam getInitParam() {
        return this.initParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlayerLive getIns() {
        if (null != ins) return ins;
        Class<RTLive> clazz = RTLive.class;
        synchronized (RTLive.class) {
            if (ins != null) return ins;
            ins = new PlayerLive();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    private PlayerLive() {
    }

    private void initPlayParams(GSFastConfig config, InitParam initParam) {
        this.initParam = initParam;
        this.isPublishMode = config.isPublish();
        this.isHardEncode = config.isHardEncode();
        this.publishMode = config.getPublishScreenMode();
        this.publishQuality = config.getPubQuality();
        this.fixedMoneyArray = config.getFixedMoneyArray();
        this.watchMode = config.getWatchScreenMode();
        if (this.watchMode != 1) {
            this.isShowDoc = config.isShowDoc();
            this.isShowChat = config.isShowChat();
            this.isShowQa = config.isShowQa();
            this.isShowIntro = config.isShowIntro();
            this.isShowPIP = config.isShowPIP();
            this.isShowHand = config.isShowHand();
            this.isShowRateSwitch = config.isShowRateSwitch();
            this.isShownetSwitch = config.isShownetSwitch();
            this.isShowDanmuBtn = config.isShowDanmuBtn();
            this.isShowCloseVideo = config.isShowCloseVideo();
            this.skinType = config.getSkinType();
            ResManager.setIsSkinTypeNight(this.getSkinType() == 0);
        }
    }

    public void startLive(Context context, GSFastConfig config, InitParam initParam) {
        RTSharedPref.initPref((Context)context);
        PreferUtil.initPref(context);
        RTSharedPref.getIns().clear();
        String version = GenseeUtils.getVersionName(context);
        RTSharedPref.getIns().putString("app.version", version);
        RTSharedPref.getIns().putInt("save.video.width", 320);
        RTSharedPref.getIns().putInt("save.video.height", 240);
        this.extraGSMoreItems = config.getExtraGSMoreItems();
        this.onPlayerVoteCommitListener = config.getOnPlayerVoteCommitListener();
        config.setExtraGSMoreItems(null);
        this.gsFastConfig = config;
        Intent intent = new Intent();
        intent.putExtra(GS_INIT_PARAM, (Serializable)initParam);
        intent.addFlags(0x10000000);
        if (!config.isPublish()) {
            if (config.getWatchScreenMode() == 0) {
                intent.setClass(context, LiveActivity.class);
            } else if (config.getWatchScreenMode() == 1) {
                intent.setClass(context, WatchActivity.class);
            }
        }
        context.startActivity(intent);
    }

    public void setRoomHandler(Handler handler) {
        this.roomHandler = handler;
    }

    public void init(Context context, GSFastConfig config, InitParam initParam) {
        if (config == null || initParam == null) {
            GenseeLog.d((String)TAG, (String)"init config or iniparma is null");
            return;
        }
        this.initPlayParams(config, initParam);
        this.context = context;
        this.mPlayer = new MyPlayer();
        this.chatImpl = new PlayerChatImpl(context);
        this.mPlayer.setOnChatListener((OnChatListener)((PlayerChatImpl)this.chatImpl));
        ((PlayerChatImpl)this.chatImpl).setModuleHandle((IPlayerModule)this.mPlayer);
    }

    public void playerJoin() {
        this.setLiveStatus(2);
        this.mPlayer.join(this.context.getApplicationContext(), PlayerLive.getIns().getInitParam(), (OnPlayListener)this);
    }

    public UserInfo getSelf() {
        return this.mPlayer.getSelfInfo();
    }

    public void onJoin(int result) {
        this.sendMsg(2, result);
        GenseeLog.i((String)TAG, (String)("OnPlayListener onJoin result:" + result));
    }

    public void onUserJoin(UserInfo userInfo) {
        if (null != this.onUserLeaveListener) {
            this.onUserLeaveListener.onUserJoin(userInfo);
        }
    }

    public void onUserLeave(UserInfo info) {
        if (null != this.onUserLeaveListener) {
            this.onUserLeaveListener.onUserLeave(info);
        }
    }

    public void onUserUpdate(UserInfo info) {
    }

    public void onRosterTotal(int total) {
    }

    public void onReconnecting() {
        GenseeLog.i((String)TAG, (String)"OnPlayListener onReconnecting...");
        this.setLiveStatus(4);
        this.sendMsg(3, null);
    }

    public void onLeave(int reason) {
        GenseeLog.i((String)TAG, (String)("OnPlayListener onLeave reason:" + reason));
        this.setLiveStatus(1);
        this.sendMsg(10, reason);
    }

    public void onCaching(boolean isCaching) {
        GenseeLog.i((String)TAG, (String)("OnPlayListener onCaching isCaching" + isCaching));
        this.sendMsg(12, isCaching);
        if (null != this.onAudioVideoListener) {
            this.onAudioVideoListener.onCaching(isCaching);
        }
    }

    public void onErr(int errCode) {
        GenseeLog.i((String)TAG, (String)("OnPlayListener join room onErr,errCode:" + errCode));
        this.sendMsg(1, errCode);
    }

    public void onIdcList(List<PingEntity> idcs) {
        if (null != idcs && idcs.size() > 0) {
            this.idcList = new ArrayList();
            for (PingEntity pingEntity : idcs) {
                IdcWhiteHolder.FastIdc fastIdc = new IdcWhiteHolder.FastIdc();
                fastIdc.name = pingEntity.getDescription();
                fastIdc.id = pingEntity.getIdcId();
                this.idcList.add(fastIdc);
            }
        }
    }

    public void onVideoBegin() {
        GenseeLog.i((String)TAG, (String)"OnPlayListener onVideoBegin");
        this.sendMsg(5, null);
    }

    public void onVideoEnd() {
        GenseeLog.i((String)TAG, (String)"OnPlayListener onVideoEnd");
        this.sendMsg(6, null);
    }

    public void onVideoSize(int width, int height, boolean isAs) {
        float rate = (float)width / (float)height;
        GenseeLog.i((String)TAG, (String)("OnPlayListener onVideoSize rate:" + rate));
        this.sendMsg(11, Float.valueOf(rate));
    }

    public void onAudioLevel(int level) {
        if (null != this.onAudioVideoListener) {
            this.onAudioVideoListener.onReceiverAudio();
        }
    }

    public void onVideoDataNotify() {
        if (null != this.onAudioVideoListener) {
            this.onAudioVideoListener.onReceiverVideo();
        }
    }

    public void onPublish(boolean isPlaying) {
        GenseeLog.i((String)TAG, (String)("OnPlayListener onPublish isPlaying:" + isPlaying));
        this.sendMsg(8, isPlaying ? 1 : 2);
    }

    public void onSubject(String subject) {
        GenseeLog.i((String)TAG, (String)("OnPlayListener onSubject subject:" + subject));
        this.sendMsg(7, subject);
    }

    public void onPageSize(int pos, int width, int height) {
        GenseeLog.i((String)TAG, (String)"OnPlayListener onPageSize");
        if (null != this.onDocListener) {
            this.onDocListener.onPageSize(pos, width, height);
        }
    }

    public void onDocSwitch(int docType, String docName) {
        GenseeLog.i((String)TAG, (String)("OnPlayListener onDocSwitch docType:" + docType));
        if (null != this.onDocListener) {
            this.onDocListener.onDocSwitch(docType, docName);
        }
    }

    public void onLiveInfo(LiveInfo info) {
        GenseeLog.i((String)TAG, (String)("onLiveInfo LiveInfo :" + info));
        if (null != info) {
            this.sendMsg(20, info);
        }
    }

    public boolean isReconnecting() {
        return this.liveStatus.get() == 4;
    }

    public void onPublicMsg(BroadCastMsg broadCastMsg) {
        if (null != this.chatImpl && (this.isShowChat || this.isShowDoc || this.isShowQa)) {
            ((PlayerChatImpl)this.chatImpl).onSysMsg(broadCastMsg.getContent());
        }
    }

    public void onLiveText(String language, String text) {
    }

    public void onRollcall(int timeOut) {
        GenseeLog.i((String)TAG, (String)("OnPlayListener onRollcall timeOut:" + timeOut));
        if (null != this.onRollcallListener) {
            this.onRollcallListener.onRollcall(timeOut);
        }
    }

    public void onLottery(int cmd, String lotteryInfo) {
        GenseeLog.i((String)TAG, (String)("onLottery() called with: cmd = [" + cmd + "], lotteryInfo = [" + lotteryInfo + "]"));
        if (null != this.onLotteryListener) {
            this.onLotteryListener.onLottery((byte)cmd, lotteryInfo);
        }
    }

    public void onFileShare(int cmd, String fileName, String fileUrl) {
    }

    public void onFileShareDl(int ret, String fileUrl, String filePath) {
    }

    public void onInvite(int type, boolean isOpen) {
        GenseeLog.i((String)TAG, (String)("OnPlayListener onInvite type:" + type + ",isOpen:" + isOpen));
        if (isOpen) {
            if ((this.nOpenMicVideoType & type) == type) {
                GenseeLog.w((String)("postInvite two times same type = " + type + " isOpen = " + isOpen));
                return;
            }
            this.nOpenMicVideoType |= type;
            if (type == 1) {
                ((BaseWatchActivity)this.context).onAudioMicInvite(true);
            } else if (type == 2) {
                ((BaseWatchActivity)this.context).onVideoCameraInvite(true);
            }
        } else {
            if (type == 1) {
                ((BaseWatchActivity)this.context).onAudioMicInvite(false);
            } else if (type == 2) {
                ((BaseWatchActivity)this.context).onVideoCameraInvite(false);
            }
            this.close(type);
            this.nOpenMicVideoType &= ~type;
        }
    }

    public void setVideoClose(boolean isClose) {
        if (null != this.mPlayer) {
            this.mPlayer.videoSet(isClose);
        }
    }

    public void acceptOpenMic(boolean isAccept) {
        this.mPlayer.openMic(this.context, isAccept, null);
    }

    public void acceptOpenCamera(boolean isAccept) {
        this.mPlayer.openCamera(this.context, isAccept, null);
    }

    private void close(int type) {
        if ((type & 1) == 1) {
            this.acceptOpenMic(false);
        }
        if ((type & 2) == 2) {
            this.acceptOpenCamera(false);
        }
    }

    public void onMicNotify(int status) {
        GenseeLog.d((String)TAG, (String)(" onMicNotify status = " + status));
        if (status != 3) {
            if (status == 1) {
                ((BaseWatchActivity)this.context).audioOpenUI();
            } else {
                ((BaseWatchActivity)this.context).audioCloseUI();
            }
        }
    }

    public void onCameraNotify(int notify) {
        GenseeLog.d((String)TAG, (String)("OnPlayListener onCameraNotify notify:" + notify));
        if (notify == 1) {
            this.avFlag |= 0x40;
            if (null != this.onLocalVideoListener) {
                this.onLocalVideoListener.onLocalVideoOpen();
            }
        } else if (notify == 2) {
            this.avFlag &= 0xFFFFFFBF;
            if (null != this.onLocalVideoListener) {
                this.onLocalVideoListener.onLocalVideoClose();
            }
        }
        PreferUtil.getIns().putInt("CAMERA_STATUS", 0);
    }

    public boolean isVideoCameraOpen() {
        return (this.avFlag & 0x40) == 64;
    }

    public void onScreenStatus(boolean isAs) {
    }

    public void onModuleFocus(int mode) {
    }

    public void onRedBagTip(RewardResult rewardResult) {
        ((BaseWatchActivity)this.context).onRedBagTip(rewardResult);
    }

    public void onGotoPay(PayInfo payInfo) {
        ((BaseWatchActivity)this.context).onGotoPay(payInfo);
    }

    public void onRewordEnable(boolean isAliPay, boolean isWx) {
        GenseeLog.i((String)TAG, (String)("OnPlayListener onRewordEnable isAliPay:" + isAliPay + ",isWx:" + isWx));
        if (isAliPay) {
            ((BaseWatchActivity)this.context).showRewardBtn(true);
        }
    }

    public void onGetUserInfo(UserInfo[] info) {
    }

    public void onThirdVote(String s) {
    }

    public void sendQaMsg(AbstractQaImpl qaImpl, String text) {
        if (this.mPlayer != null) {
            String uuid = UUID.randomUUID().toString();
            this.mPlayer.question(uuid, text);
            RtQaMsg msg = new RtQaMsg();
            msg.setQuestId(uuid);
            msg.setQuestion(text);
            UserInfo self = this.mPlayer.getSelfInfo();
            if (self != null) {
                msg.setQuestOwnerId(self.getUserId());
                msg.setQuestOwnerName(self.getName());
            }
            long now = Calendar.getInstance().getTimeInMillis();
            msg.setQuestTimgstamp(now / 1000L);
            msg.setTimestamp(now);
            qaImpl.addMsg(msg);
        } else {
            GenseeLog.w((String)"mQaHandle is null");
        }
    }

    public void micControl(boolean isAccept) {
        if (null != this.mPlayer) {
            this.mPlayer.inviteAck(1, isAccept, null);
            if (isAccept) {
                this.acceptOpenMic(isAccept);
            }
            this.nOpenMicVideoType &= 0xFFFFFFFE;
        }
    }

    public void cameraControl(boolean isAccept) {
        if (null != this.mPlayer) {
            this.mPlayer.inviteAck(2, isAccept, null);
            if (isAccept) {
                this.acceptOpenCamera(isAccept);
            }
            this.nOpenMicVideoType &= 0xFFFFFFFD;
        }
    }

    public void restoreVideoCameraInvite() {
        if ((this.nOpenMicVideoType & 2) == 2) {
            ((BaseWatchActivity)this.context).onVideoCameraInvite(true);
        }
    }

    public void restoreAudioMicInvite() {
        if ((this.nOpenMicVideoType & 1) == 1) {
            ((BaseWatchActivity)this.context).onAudioMicInvite(true);
        }
    }

    public void voteSubmit(VotePlayerGroup mVoteGroup) {
        this.mPlayer.voteSubmit(mVoteGroup);
    }

    public void roomRollcallAck(boolean isAccept) {
        this.mPlayer.rollCallAck(isAccept, null);
    }

    public void roomHandlUp(boolean isHandup) {
        this.mPlayer.handUp(isHandup, null);
        if (null != this.onRoomHandupListener) {
            this.onRoomHandupListener.onRoomHandup(isHandup);
        }
    }

    public void release() {
        if ((this.avFlag & 0x40) == 64 || (this.avFlag & 0x80) == 128) {
            this.acceptOpenCamera(false);
        }
        if ((this.avFlag & 4) == 4 || (this.avFlag & 8) == 8) {
            this.acceptOpenMic(false);
        }
        if (null != this.extraGSMoreItems) {
            this.extraGSMoreItems.clear();
        }
        this.liveStatus.set(1);
        this.avFlag = 0;
        this.nOpenMicVideoType = 0;
        this.mPlayer.leave();
        this.mPlayer.release(this.context);
        this.gsFastConfig = null;
    }

    public void switchQuality(boolean isHD) {
        this.mPlayer.switchRate(isHD ? VideoRate.RATE_NORMAL : VideoRate.RATE_LOW, null);
    }

    private void sendMsg(int what, Object obj) {
        if (obj == null) {
            this.roomHandler.sendEmptyMessage(what);
            return;
        }
        this.roomHandler.sendMessage(this.roomHandler.obtainMessage(what, obj));
    }

    public void setLocalTextureVideoView(LocalTextureVideoView localTextureVideoView) {
        this.mPlayer.setLocalVideoView((ILocalVideoView)localTextureVideoView);
    }

    public void setOnVoteListener(OnVoteListener onVoteListener) {
        this.mPlayer.setOnVoteListener(onVoteListener);
    }

    public boolean isShowDoc() {
        return this.isShowDoc;
    }

    public boolean isShowPIP() {
        return this.isShowPIP;
    }

    public String onFilter(String s) {
        return this.mPlayer.textFilter(s);
    }

    public static interface OnLotteryListener {
        public void onLottery(byte var1, String var2);
    }

    public static interface OnAudioVideoListener {
        public void onReceiverAudio();

        public void onReceiverVideo();

        public void onCaching(boolean var1);
    }

    public static interface OnRoomHandupListener {
        public void onRoomHandup(boolean var1);
    }

    public static interface OnRollcallListener {
        public void onRollcall(int var1);
    }

    public static interface OnUserJoinLeaveListener {
        public void onUserLeave(UserInfo var1);

        public void onUserJoin(UserInfo var1);
    }

    public static interface OnLocalVideoListener {
        public void onLocalVideoOpen();

        public void onLocalVideoClose();
    }

    public static interface OnDocListener {
        public void onPageSize(int var1, int var2, int var3);

        public void onDocSwitch(int var1, String var2);
    }

    private class MyPlayer
    extends Player {
        private MyPlayer() {
        }

        protected void joinRoom(Context context, LoginResEntity lEntity) {
            PlayerLive.this.liveId = lEntity.getWebcastId();
            super.joinRoom(context, lEntity);
        }
    }
}

