/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.core;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.text.TextUtils;
import com.gensee.callback.IChatCallBack;
import com.gensee.common.RTSharedPref;
import com.gensee.common.RoleType;
import com.gensee.common.ServiceType;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.InitParam;
import com.gensee.fastsdk.core.GSFastConfig;
import com.gensee.fastsdk.entity.GSMoreItem;
import com.gensee.fastsdk.receiver.PhoneStateReceiver;
import com.gensee.fastsdk.ui.BaseLiveActivity;
import com.gensee.fastsdk.ui.landscape.LandscapePubActivity;
import com.gensee.fastsdk.ui.portrait.PublishActivity;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.net.RtComp;
import com.gensee.room.RtSdk;
import com.gensee.room.RtSimpleImpl;
import com.gensee.routine.IDCInfo;
import com.gensee.routine.LiveodItem;
import com.gensee.routine.State;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.user.UserManager;
import com.gensee.utils.GenseeLog;
import com.gensee.view.ILocalVideoView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RTLive
extends RtSimpleImpl
implements RtComp.Callback,
PhoneStateReceiver.OnPhoneStateListener {
    private static final int AUIDO_JOIN = 1;
    private static final int AUIDO_MICAVAILABLE = 2;
    private static final int AUIDO_MIC_OPENED = 4;
    private static final int AUIDO_MIC_REOPEN = 8;
    private static final int VIDEO_START = 32;
    private static final int VIDEO_CAMERA_OPEN = 64;
    private static final int VIDEO_CAMERA_REOPEN = 128;
    private static final int USER_EVENT_PUBLISH = 1;
    public static final int S_IDLE = 1;
    public static final int S_JOIN_BEGIN = 2;
    public static final int S_JOINED = 3;
    public static final int S_RECONNECTING = 4;
    public static final int S_EXIT_BEGIN = 5;
    public static final int STATUS_UNSTART = 0;
    public static final int STATUS_ING = 1;
    public static final int STATUS_PAUSE = 3;
    public static final int STATUS_STOP = 2;
    private static final String TAG = "RTLive";
    private UserInfo self;
    private boolean bInitHostJoin;
    private Map<String, Long> roomData;
    private OnSysMsgListener onSysMsgListener;
    private int avFlag = 0;
    private static RTLive ins = null;
    private RtComp rtComp;
    private Context context;
    private InitParam initParam;
    private Handler roomHandler;
    private AtomicInteger nInitalRole = new AtomicInteger(0);
    private AtomicInteger status = new AtomicInteger(1);
    private AtomicBoolean isAppBackGround = new AtomicBoolean(false);
    private int eventFlag = 0;
    private int liveStatus = 0;
    private int lastWidth;
    private int lastHeight;
    private byte recordStaus = 0;
    private Context applicationContext;
    private List<OnUserCountChangeListener> userCountChangeList;
    private long speakTime = 0L;
    private OnHostStatusChangeListener onHostStatusChangeListener;
    private OnSelfVideoReadyListener onSelfVideoReadyListener;
    private boolean isAsBegin;
    private boolean isLodStart;
    private String liveodId;
    private boolean isPublishMode;
    private boolean isHardEncode;
    private int publishMode;
    private int publishQuality;
    private ServiceType serviceType;
    private int[] fixedMoneyArray;
    private boolean isShowFixMoneyPanel;
    private int dashangEnable;
    private OnDashangEnableListener onDashangEnableListener;
    private int watchMode;
    private boolean isShowDoc = true;
    private boolean isShowChat = true;
    private boolean isShowQa = true;
    private boolean isShowPIP = true;
    private boolean isShowHand = true;
    private boolean isShowRateSwitch = true;
    private boolean isShownetSwitch = true;
    private boolean bBarrageEnable;
    private List<GSMoreItem> extraGSMoreItems;
    private OnBarrageEnableListener onBarrageEnableListener;

    public List<GSMoreItem> getExtraGSMoreItems() {
        return this.extraGSMoreItems;
    }

    public boolean isbBarrageEnable() {
        return this.bBarrageEnable;
    }

    public void setOnBarrageEnableListener(OnBarrageEnableListener onBarrageEnableListener) {
        this.onBarrageEnableListener = onBarrageEnableListener;
    }

    public void setOnDashangEnableListener(OnDashangEnableListener onDashangEnableListener) {
        this.onDashangEnableListener = onDashangEnableListener;
    }

    public boolean isDashangEnable() {
        return this.dashangEnable == 1;
    }

    public int[] getFixedMoneyArray() {
        return this.fixedMoneyArray;
    }

    public int getPublishMode() {
        return this.publishMode;
    }

    public boolean isHardEncode() {
        return this.isHardEncode;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public boolean isPublishMode() {
        return this.isPublishMode;
    }

    public void setOnSelfVideoReadyListener(OnSelfVideoReadyListener onSelfVideoReadyListener) {
        this.onSelfVideoReadyListener = onSelfVideoReadyListener;
    }

    public void setOnHostStatusChangeListener(OnHostStatusChangeListener onHostStatusChangeListener) {
        this.onHostStatusChangeListener = onHostStatusChangeListener;
    }

    public void setAppBackGround(boolean isAppBackGround) {
        this.isAppBackGround.set(isAppBackGround);
    }

    public void setOnSysMsgListener(OnSysMsgListener onSysMsgListener) {
        this.onSysMsgListener = onSysMsgListener;
    }

    public InitParam getInitParam() {
        return this.initParam;
    }

    public UserInfo getSelf() {
        return this.self;
    }

    private void setStatus(int status) {
        this.status.set(status);
    }

    public int getStatus() {
        return this.status.get();
    }

    private RTLive() {
        this.roomData = new HashMap<String, Long>();
        this.initRoomData();
    }

    private void initRoomData() {
        this.roomData.put("user.rostrum", -1L);
        this.roomData.put("user.asker", -1L);
        this.roomData.put("user.asker.1", -1L);
        this.roomData.put("user.asker.2", -1L);
        this.roomData.put("user.asker.3", -1L);
    }

    private void releaseRoomData() {
        if (null != this.roomData) {
            this.initRoomData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RTLive getIns() {
        if (null != ins) return ins;
        Class<RTLive> clazz = RTLive.class;
        synchronized (RTLive.class) {
            if (ins != null) return ins;
            ins = new RTLive();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    public void startLive(Context context, GSFastConfig config, InitParam initParam) {
        this.initParam = initParam;
        this.applicationContext = context.getApplicationContext();
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        this.isPublishMode = config.isPublish();
        this.isHardEncode = config.isHardEncode();
        this.publishMode = config.getPublishScreenMode();
        this.publishQuality = config.getPubQuality();
        this.fixedMoneyArray = config.getFixedMoneyArray();
        this.isShowDoc = config.isShowDoc();
        this.isShowChat = config.isShowChat();
        this.isShowQa = config.isShowQa();
        this.isShowPIP = config.isShowPIP();
        this.isShowHand = config.isShowHand();
        this.isShowRateSwitch = config.isShowRateSwitch();
        this.isShownetSwitch = config.isShownetSwitch();
        this.watchMode = config.getWatchScreenMode();
        this.extraGSMoreItems = config.getExtraGSMoreItems();
        config.setExtraGSMoreItems(null);
        if (this.isPublishMode) {
            this.publishModeInit();
            if (this.publishMode == 0) {
                intent.setClass(context, PublishActivity.class);
            } else if (this.publishMode == 1) {
                intent.setClass(context, LandscapePubActivity.class);
            }
        }
        context.startActivity(intent);
    }

    private void publishModeInit() {
        RtSdk.loadLibrarys();
        RTSharedPref.initPref((Context)this.applicationContext);
        PreferUtil.initPref(this.applicationContext);
        RTSharedPref.getIns().clear();
        String version = GenseeUtils.getVersionName(this.applicationContext);
        RTSharedPref.getIns().putString("app.version", version);
        int width = 0;
        int height = 0;
        if (this.publishQuality == 0) {
            width = 960;
            height = 540;
        } else {
            width = 640;
            height = 360;
        }
        RTSharedPref.getIns().putInt("save.video.width", width);
        RTSharedPref.getIns().putInt("save.video.height", height);
    }

    public void initJoin() {
        if (null == this.rtComp) {
            this.rtComp = new RtComp(this.context, (RtComp.Callback)this);
        }
        if (null == this.initParam) {
            GenseeLog.e((String)"initParam is null, can not start live");
            return;
        }
        this.rtComp.setbAttendeeOnly(false);
        this.rtComp.setHostJoinOnly(true);
        this.rtComp.initWithGensee(this.initParam);
    }

    public void onInited(String rtParams) {
        this.joinWithParam("", rtParams);
    }

    public void onErr(int errorCode) {
        GenseeLog.e((String)("join onError errorCode:" + errorCode));
        ((BaseLiveActivity)this.context).onError(errorCode);
    }

    public void onInit(boolean result) {
        if (result && this.isPanelistEx()) {
            this.onRoomJoin(1011, this.self, false);
            return;
        }
        if (this.isHostJoin()) {
            this.sendMsg(this.roomHandler, 1012, result);
        } else {
            this.sendMsg(this.roomHandler, 1013, result);
        }
        super.onInit(result);
    }

    public void onNetworkReport(byte level) {
        super.onNetworkReport(level);
        this.sendMsg(this.roomHandler, 1014, level);
    }

    public void onRoomData(String key, long value) {
        if (!this.isJoin()) {
            GenseeLog.i((String)TAG, (String)("onRoomData key = " + key + "value = " + value + " isJoin = " + this.isJoin()));
            return;
        }
        if (this.isInitHostJoin()) {
            if ("user.rostrum".equals(key) && null != this.self && this.roomData.get("user.rostrum").longValue() == this.self.getId() && this.self.getId() != value) {
                this.roomData.put(key, value);
                this.sendMsg(this.roomHandler, 6005, 6008);
            }
        } else {
            this.onReceiverRoomData(key, value);
        }
        this.roomData.put(key, value);
    }

    public boolean isJoin() {
        return this.getStatus() == 3;
    }

    public void onRoomJoin(int result, UserInfo self, boolean svrFailover) {
        super.onRoomJoin(result, self, svrFailover);
        this.setStatus(result == 0 ? 3 : 1);
        this.self = self;
        if (result != 0) {
            this.getRtSdk().release(null);
        } else {
            boolean bl = this.bInitHostJoin = null != self && self.IsHost();
            if (svrFailover) {
                if (!this.isSelfOnAsker() && this.roomData.get("user.rostrum").longValue() != self.getId()) {
                    PreferUtil.getIns().putInt("CAMERA_STATUS", -1);
                    PreferUtil.getIns().putInt("MIC_STATUS", -1);
                    PreferUtil.getIns().putInt("VIDEO_SELF_ACTIVED", -1);
                }
                if (!this.bInitHostJoin) {
                    String askerId;
                    if (this.roomData.get("user.rostrum").longValue() == self.getId()) {
                        this.getRtSdk().roomSetData("user.rostrum", self.getId(), null);
                    }
                    if (this.isSelfOnAsker() && !"".equals(askerId = this.getAskerIdByUserId(self.getId()))) {
                        this.getRtSdk().roomSetData(askerId, self.getId(), null);
                    }
                }
            }
        }
        if (this.bInitHostJoin) {
            this.getRtSdk().roomSetData("user.rostrum", RTLive.getIns().getSelf().getId(), null);
        }
        this.sendMsg(this.roomHandler, 1000, result);
        if (svrFailover) {
            GenseeLog.i((String)"RTLive onRoonJoin svrFailover!");
            this.sendMsg(this.roomHandler, 1016, 0);
        }
    }

    public void leave(boolean isClose) {
        GenseeLog.i((String)"RTLive test video leave");
        if (null != this.userCountChangeList) {
            this.userCountChangeList.clear();
        }
        this.eventFlag = 0;
        this.avFlag = 0;
        this.setStatus(5);
        this.bInitHostJoin = false;
        if (null != this.self) {
            String selfAskerId;
            if (this.isSelfOnAsker() && !"".equals(selfAskerId = this.getAskerIdByUserId(this.self.getId()))) {
                this.getRtSdk().roomSetData(selfAskerId, 0L, null);
            }
            if (this.roomData.get("user.rostrum").longValue() == this.self.getId()) {
                this.getRtSdk().roomSetData("user.rostrum", 0L, null);
            }
        }
        this.releaseRoomData();
        super.leave(isClose);
    }

    protected void onRelease(int reason) {
        GenseeLog.i((String)"RTLive test video onRelease");
        this.eventFlag = 0;
        this.avFlag = 0;
        this.bInitHostJoin = false;
        this.setStatus(1);
        this.liveStatus = 0;
        this.recordStaus = 0;
        this.lastWidth = 0;
        this.lastHeight = 0;
        this.dashangEnable = 0;
        if (null != this.extraGSMoreItems) {
            this.extraGSMoreItems.clear();
        }
        this.sendMsg(this.roomHandler, 1008, reason);
    }

    public void onRoomReconnecting() {
        PreferUtil.getIns().putInt("MIC_STATUS", this.isMicOpen() ? 1 : 0);
        this.setStatus(4);
        this.avFlag &= 0xFFFFFFDF;
        if ((this.avFlag & 0x40) == 64) {
            this.onVideoCameraClosed();
        }
        this.sendMsg(this.roomHandler, 1009, null);
        super.onRoomReconnecting();
    }

    public void onRoomPublish(State mState) {
        UserInfo self;
        byte mValue = mState.getValue();
        this.liveStatus = mValue;
        if ((this.eventFlag & 1) != 1 && this.liveStatus == 1 && (self = this.getSelf()) != null && self.IsHost()) {
            this.postRecord();
        }
        this.sendMsg(this.roomHandler, 1007, mState.getValue());
    }

    private void onReceiverRoomData(String key, long value) {
        if ("user.rostrum".equals(key)) {
            if (value == 0L) {
                if (this.roomData.get("user.rostrum").longValue() == this.self.getId() && !this.isSelfOnAsker()) {
                    this.getRtSdk().audioCloseMic(null);
                }
            } else {
                UserInfo self = this.getSelf();
                if (self != null && value == self.getId()) {
                    String askeIdx;
                    if (!(this.roomData.get("user.asker") != value && this.roomData.get("user.asker.1") != value && this.roomData.get("user.asker.2") != value && this.roomData.get("user.asker.3") != value || "".equals(askeIdx = this.getAskerIdByUserId(value)))) {
                        this.getRtSdk().roomSetData(askeIdx, 0L, null);
                    }
                    this.getRtSdk().roomHanddown(false, null);
                    if ((this.avFlag & 4) != 4) {
                        if (this.roomData.get("user.rostrum").longValue() == self.getId() && PreferUtil.getIns().getInt("MIC_STATUS") != 1) {
                            return;
                        }
                        this.audioOpenMic();
                    }
                } else if (null != self && this.roomData.get("user.rostrum").longValue() == self.getId() && self.getId() != value) {
                    this.getRtSdk().audioCloseMic(null);
                }
            }
        } else if ("user.asker".equals(key) || "user.asker.1".equals(key) || "user.asker.2".equals(key) || "user.asker.3".equals(key)) {
            if (value == 0L) {
                if (this.roomData.get(key).longValue() == this.self.getId() && this.roomData.get("user.rostrum").longValue() != this.self.getId()) {
                    this.getRtSdk().audioCloseMic(null);
                }
            } else if (value == this.self.getId()) {
                if (this.roomData.get("user.rostrum") == value) {
                    this.getRtSdk().roomSetData("user.rostrum", 0L, null);
                }
                if ((this.avFlag & 4) != 4) {
                    if (this.isSelfOnAsker() && PreferUtil.getIns().getInt("MIC_STATUS") != 1) {
                        return;
                    }
                    this.audioOpenMic();
                }
                this.getRtSdk().roomHanddown(false, null);
            } else if (value != this.self.getId() && this.roomData.get(key).longValue() == this.self.getId()) {
                this.getRtSdk().audioCloseMic(null);
            }
        }
    }

    private boolean isSelfOnAsker() {
        if (null == this.self) {
            return false;
        }
        return this.roomData.get("user.asker").longValue() == this.self.getId() || this.roomData.get("user.asker.1").longValue() == this.self.getId() || this.roomData.get("user.asker.2").longValue() == this.self.getId() || this.roomData.get("user.asker.3").longValue() == this.self.getId();
    }

    public boolean isSelfOnRostrum() {
        if (null == this.self) {
            return false;
        }
        return this.roomData.get("user.rostrum").longValue() == this.self.getId();
    }

    private String getAskerIdByUserId(long value) {
        String askeIdx;
        String string = askeIdx = this.roomData.get("user.asker") == value ? "user.asker" : "";
        if ("".equals(askeIdx)) {
            String string2 = askeIdx = this.roomData.get("user.asker.1") == value ? "user.asker.1" : "";
        }
        if ("".equals(askeIdx)) {
            String string3 = askeIdx = this.roomData.get("user.asker.2") == value ? "user.asker.2" : "";
        }
        if ("".equals(askeIdx)) {
            askeIdx = this.roomData.get("user.asker.3") == value ? "user.asker.3" : "";
        }
        return askeIdx;
    }

    private void postRecord() {
        if (this.roomHandler != null) {
            this.roomHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (RTLive.this.recordStaus != State.S_RUNNING.getValue()) {
                        RTLive.this.roomRecord(State.S_RUNNING.getValue());
                    }
                }
            }, 1000L);
        }
    }

    public boolean isVideoCameraOpen() {
        return (this.avFlag & 0x40) == 64;
    }

    public boolean isMicOpen() {
        return (this.avFlag & 8) == 8 || (this.avFlag & 4) == 4;
    }

    protected void onVideoStart() {
        this.avFlag |= 0x20;
        this.sendMsg(this.roomHandler, 2000, null);
    }

    protected void onVideoEnd() {
        this.avFlag &= 0xFFFFFFDF;
        this.sendMsg(this.roomHandler, 2001, null);
    }

    public void onJoin(boolean b) {
    }

    public Context onGetContext() {
        return this.context;
    }

    public void onSettingSet(String key, int val) {
        if ("training.user.my.role".equals(key)) {
            this.nInitalRole.set(val);
        } else if ("chat.disable.attendee.private".equals(key)) {
            int nSiteChatMode;
            int n = nSiteChatMode = val == 0 ? 101 : 100;
            if (null != this.onSysMsgListener) {
                this.onSysMsgListener.onSitePrivateChatMode(nSiteChatMode);
            }
        } else if ("dashang.enable".equals(key)) {
            GenseeLog.i((String)TAG, (String)("onSettingSet key:" + key + ",val:" + val));
            this.dashangEnable = val;
            if (null != this.onDashangEnableListener) {
                this.onDashangEnableListener.onDashangEnable(val);
            }
        } else if ("chat.barrage.enable".equals(key)) {
            boolean bl = this.bBarrageEnable = val == 1;
            if (null != this.onBarrageEnableListener) {
                this.onBarrageEnableListener.onBarrageEnabel(this.bBarrageEnable);
            }
        }
        super.onSettingSet(key, val);
    }

    public void onSettingSet(String key, String val) {
        if ("training.class.name".equals(key)) {
            this.sendMsg(this.roomHandler, 1006, val);
        }
    }

    private boolean isHostJoin() {
        int nRole = this.nInitalRole.get();
        return RoleType.isHost((int)nRole);
    }

    private boolean isPanelistEx() {
        int nRole = this.nInitalRole.get();
        if ((nRole & 1) == 1 || (nRole & 2) == 2) {
            return false;
        }
        return (nRole & 4) == 4;
    }

    private void sendMsg(Handler handler, int what, Object obj) {
        if (handler != null) {
            if (obj == null) {
                handler.sendEmptyMessage(what);
                return;
            }
            handler.sendMessage(handler.obtainMessage(what, obj));
        }
    }

    public void chatWithPublic(String text, String rich, String msgId, OnTaskRet ret) {
        this.getRtSdk().chatWithPublic(new ChatMsg(text, rich, 2, msgId), ret);
    }

    public boolean isReconnecting() {
        return this.getStatus() == 4;
    }

    public UserInfo getUserById(long userId) {
        return this.getRtSdk().getUserById(userId);
    }

    public void initResource(Context context, Handler roomHandler) {
        if (context != null) {
            this.context = context;
        }
        this.roomHandler = roomHandler;
    }

    public void onAudioJoinConfirm(boolean ok) {
        if (ok) {
            this.avFlag |= 1;
        }
    }

    public void onAudioSpeakerOpened() {
        super.onAudioSpeakerOpened();
        if (this.isAppBackGround.get()) {
            this.audioCloseSpeaker();
        }
    }

    public void audioCloseSpeaker() {
        if ((this.avFlag & 1) == 1) {
            this.getRtSdk().audioCloseSpeaker(null);
        }
    }

    public void audioOpenSpeaker() {
        if ((this.avFlag & 1) == 1) {
            this.getRtSdk().audioOpenSpeaker(null);
        }
    }

    public void audioCloseMic() {
        this.getRtSdk().audioCloseMic(null);
    }

    public void audioOpenMic() {
        if ((this.avFlag & 4) != 4) {
            this.getRtSdk().audioOpenMic(null);
        }
    }

    public void videoOpenCamera() {
        if ((this.avFlag & 0x40) != 64) {
            this.getRtSdk().videoOpenCamera(null);
        }
    }

    public void videoCloseCamera() {
        this.getRtSdk().videoCloseCamera(null);
    }

    public void onAsData(byte[] data, int width, int height) {
        if (this.lastWidth != width || this.lastHeight != height) {
            this.sendMsg(this.roomHandler, 2006, Float.valueOf((float)width / (float)height));
            this.lastWidth = width;
            this.lastHeight = height;
        }
        super.onAsData(data, width, height);
    }

    public void onVideoCameraOpened() {
        super.onVideoCameraOpened();
        GenseeLog.i((String)"RTLive test video onVideoCameraOpened");
        if (this.bInitHostJoin) {
            this.stopLod();
            this.getRtSdk().videoActive(this.self.getId(), true, null);
            this.onVideoActived(this.self, true);
            if (null != this.onSelfVideoReadyListener) {
                this.onSelfVideoReadyListener.onSelfVideoReady();
            }
            this.avFlag |= 0x40;
            this.sendMsg(this.roomHandler, 2003, null);
        } else {
            this.avFlag |= 0x40;
            if (this.isSelfVideoActiveId()) {
                this.onVideoActived(this.self, true);
            }
        }
    }

    public boolean isSelfVideoActiveId() {
        return null != this.self && this.self.getId() == this.getVideoActiveId();
    }

    public void onVideoCameraClosed() {
        super.onVideoCameraClosed();
        this.avFlag &= 0xFFFFFFBF;
        if (this.isSelfVideoActiveId()) {
            this.onVideoActived(this.self, false);
        }
        this.sendMsg(this.roomHandler, 2002, null);
    }

    public void onAudioMicClosed() {
        if ((this.avFlag & 4) == 4) {
            this.sendMsg(this.roomHandler, 3001, null);
        }
        this.avFlag &= 0xFFFFFFFB;
        this.speakTime = 0L;
    }

    public void onAudioMicOpened() {
        this.avFlag |= 4;
        this.speakTime = System.currentTimeMillis();
        this.sendMsg(this.roomHandler, 3000, null);
    }

    private void reOpenMic() {
        if ((this.avFlag & 8) == 8) {
            this.avFlag &= 0xFFFFFFF7;
            this.audioOpenMic();
        }
    }

    @Override
    public void callRinging() {
        if ((this.avFlag & 4) == 4) {
            this.avFlag |= 8;
            this.avFlag &= 0xFFFFFFFB;
            this.getRtSdk().audioCloseMic(null);
        }
    }

    public void onAsBegin(long owner) {
        super.onAsBegin(owner);
        this.isAsBegin = true;
        if (this.bInitHostJoin && null != this.self && owner != this.self.getId()) {
            this.sendMsg(this.roomHandler, 8000, null);
        }
    }

    public void onAsEnd() {
        super.onAsEnd();
        this.isAsBegin = false;
        if (this.bInitHostJoin) {
            this.sendMsg(this.roomHandler, 8001, null);
        }
    }

    public void onLodStart(LiveodItem liveodItem) {
        super.onLodStart(liveodItem);
        this.isLodStart = true;
        this.liveodId = liveodItem.getId();
    }

    public void onLodStop(LiveodItem liveodItem) {
        super.onLodStop(liveodItem);
        this.isLodStart = false;
        this.liveodId = null;
    }

    @Override
    public void callOffHook() {
        this.reOpenMic();
    }

    public boolean isLiveStart() {
        return this.liveStatus != 0;
    }

    public boolean isLivePause() {
        return this.liveStatus == 3;
    }

    public boolean isInitHostJoin() {
        return this.bInitHostJoin;
    }

    public void roomRecord(byte state) {
        this.getRtSdk().roomRecord(state, null);
    }

    public void roomPublish(byte state) {
        this.getRtSdk().roomPublish(state, new OnTaskRet(){

            public void onTaskRet(boolean ret, int arg1, String arg2) {
                if (ret) {
                    RTLive.this.eventFlag = RTLive.this.eventFlag | 1;
                }
            }
        });
        if (this.isLiveStart()) {
            if (this.isLivePause()) {
                RTLive.getIns().getRtSdk().roomNotifyBroadcastMsg(this.context.getString(ResManager.getStringId("fs_gs_live_resume")), true, null);
            }
        } else {
            RTLive.getIns().getRtSdk().roomNotifyBroadcastMsg(this.context.getString(ResManager.getStringId("fs_gs_chat_activity_start")), true, null);
        }
        this.liveStatus = state;
        this.sendMsg(this.roomHandler, 1007, state);
    }

    public void onRoomUserJoin(UserInfo userInfo) {
        super.onRoomUserJoin(userInfo);
        if (null != this.userCountChangeList && this.userCountChangeList.size() > 0) {
            for (OnUserCountChangeListener temp : this.userCountChangeList) {
                temp.onUserCountChange(UserManager.getIns().getUserCount() + "");
            }
        }
        if (null != this.self && this.isInitHostJoin() && userInfo.getId() != this.self.getId() && userInfo.IsPresentor()) {
            GenseeLog.i((String)("RTLIVe onRoomUserJoin roomGrantPresentor userId = " + this.self.getId()));
            this.getRtSdk().roomGrantPresentor(this.self.getId(), null);
        }
    }

    public void onRoomUserLeave(UserInfo userInfo) {
        super.onRoomUserLeave(userInfo);
        if (null != this.userCountChangeList && this.userCountChangeList.size() > 0) {
            for (OnUserCountChangeListener temp : this.userCountChangeList) {
                temp.onUserCountChange(UserManager.getIns().getUserCount() + "");
            }
        }
    }

    public void activeAndPublish() {
        GenseeLog.i((String)TAG, (String)"activeSelfVideoLive!");
        this.getRtSdk().videoActive(this.self.getId(), true, null);
        this.roomPublish(State.S_RUNNING.getValue());
        this.roomRecord(State.S_RUNNING.getValue());
        this.stopLod();
        this.onVideoActived(this.self, true);
    }

    public void stopLod() {
        if (this.isLodStart && !TextUtils.isEmpty((CharSequence)this.liveodId)) {
            this.getRtSdk().lodStop(this.liveodId, null);
        }
    }

    public void onRoomUserUpdate(UserInfo userInfo) {
        super.onRoomUserUpdate(userInfo);
        if (userInfo != null && this.self != null && this.self.getId() == userInfo.getId()) {
            if (this.bInitHostJoin && this.self.IsHost() && !userInfo.IsHost()) {
                this.bInitHostJoin = false;
                if (this.self.IsHost() && !userInfo.IsHost() && userInfo.IsPresentor()) {
                    this.sendMsg(this.roomHandler, 6005, 6007);
                    GenseeLog.i((String)" onRoomUserUpdate roleHostToPresentor");
                } else if (this.self.IsHost() && !userInfo.IsHost() && !userInfo.IsPresentor() && userInfo.IsPanelist()) {
                    this.sendMsg(this.roomHandler, 6005, 6001);
                    GenseeLog.i((String)" onRoomUserUpdate roleHostToPanelist");
                } else if (!this.self.IsHost() && this.self.IsPresentor() && userInfo.IsHost()) {
                    GenseeLog.i((String)" onRoomUserUpdate rolePresentorToHost");
                    this.sendMsg(this.roomHandler, 6005, 6000);
                } else if (!this.self.IsHost() && !this.self.IsPresentor() && this.self.IsPanelist() && userInfo.IsHost()) {
                    this.sendMsg(this.roomHandler, 6005, 6002);
                    GenseeLog.i((String)" onRoomUserUpdate rolePanelistToHost");
                } else if (!this.self.IsHost() && !this.self.IsPresentor() && this.self.IsPanelist() && !userInfo.IsHost() && userInfo.IsPresentor()) {
                    this.sendMsg(this.roomHandler, 6005, 6003);
                    GenseeLog.i((String)" onRoomUserUpdate rolePanelistToPresentor");
                } else if (!this.self.IsHost() && this.self.IsPresentor() && !userInfo.IsHost() && !userInfo.IsPresentor() && userInfo.IsPanelist()) {
                    this.sendMsg(this.roomHandler, 6005, 6004);
                    GenseeLog.i((String)" onRoomUserUpdate rolePresentorToPanelist");
                }
            }
            this.self = userInfo;
        }
    }

    public void onRoomBroadcastMsg(String msg) {
        if (null != this.onSysMsgListener) {
            this.onSysMsgListener.onBraodcastMsg(msg);
        }
        super.onRoomBroadcastMsg(msg);
    }

    public void onChatMode(int nChatMode) {
        super.onChatMode(nChatMode);
        if (null != this.onSysMsgListener) {
            if (nChatMode == 0) {
                this.onSysMsgListener.onChatMode(nChatMode, this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_publicchat_close")));
            } else if (nChatMode == 1) {
                this.onSysMsgListener.onChatMode(nChatMode, this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_publicchat_open")));
            }
        }
    }

    public void onLodPause(LiveodItem liveodItem) {
        super.onLodPause(liveodItem);
    }

    public IDCInfo[] roomIDCGetList() {
        return this.getRtSdk().getIDCs();
    }

    public String roomIDCGetCurrent() {
        return this.getRtSdk().getCurIDC();
    }

    public void roomIDCSetCurrent(String idcID) {
        this.getRtSdk().setCurIDC(idcID, null);
    }

    public void setLocalTextureVideoView(ILocalVideoView localTextureVideoView) {
        this.getRtSdk().setLocalVideoView(localTextureVideoView);
    }

    public void onVideoDataRender(long userId, int width, int height, int frameFormat, float displayRatio, byte[] data) {
        if (!(this.isAsBegin || this.lastWidth == width && this.lastHeight == height)) {
            this.sendMsg(this.roomHandler, 2006, Float.valueOf((float)width / (float)height));
            this.lastWidth = width;
            this.lastHeight = height;
        }
        if (userId != this.self.getId()) {
            super.onVideoDataRender(userId, width, height, frameFormat, displayRatio, data);
        }
    }

    public void setChatCallBack(IChatCallBack iChatCallBack) {
        this.getRtSdk().setChatCallback(iChatCallBack);
    }

    public boolean isHost() {
        return null != this.self && this.self.IsHost();
    }

    public void addOnUserCountChangeListener(OnUserCountChangeListener onUserCountChangeListener) {
        if (null == this.userCountChangeList) {
            this.userCountChangeList = new ArrayList<OnUserCountChangeListener>();
        }
        if (!this.userCountChangeList.contains(onUserCountChangeListener)) {
            this.userCountChangeList.add(onUserCountChangeListener);
        }
    }

    public static interface OnBarrageEnableListener {
        public void onBarrageEnabel(boolean var1);
    }

    public static interface OnDashangEnableListener {
        public void onDashangEnable(int var1);
    }

    public static interface OnSelfVideoReadyListener {
        public void onSelfVideoReady();
    }

    public static interface OnHostStatusChangeListener {
        public void onHostJoin(String var1);

        public void onHostLeave(String var1);
    }

    public static interface OnUserCountChangeListener {
        public void onUserCountChange(String var1);
    }

    public static interface OnSysMsgListener {
        public void onSysMsg(String var1);

        public void onBraodcastMsg(String var1);

        public void onChatMode(int var1, String var2);

        public void onSitePrivateChatMode(int var1);
    }
}

