/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import com.gensee.entity.LoginResEntity;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.receiver.ConnectionReceiver;
import com.gensee.fastsdk.ui.BaseActivity;
import com.gensee.fastsdk.ui.holder.chat.impl.RTChatImpl;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.routine.LiveodItem;
import com.gensee.routine.State;
import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import java.io.Serializable;

public abstract class BaseLiveActivity
extends BaseActivity
implements ConnectionReceiver.OnNetSwitchListener {
    private static final String APP_START_TYPE = "APP_START_TYPE";
    private static final String APP_LANCHCODE = "APP_LANCHCODE";
    protected int netStatus = 4;
    private String appStartType = "";
    private String lanchCode = "";
    private LoginResEntity loginResEntity = null;
    public boolean isNeedExitApp = false;
    protected RTLive simpleImpl;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ResManager.getIns().init((Context)this);
        this.setContentView(this.getLayoutResID());
        this.chatImpl = new RTChatImpl();
        RTLive.getIns().setChatCallBack((RTChatImpl)this.chatImpl);
        this.initData();
        this.initView(savedInstanceState);
        if (null != savedInstanceState && null != this.simpleImpl.getInitParam()) {
            GenseeLog.d((String)"BaseLiveActivity client api reLogin");
            this.reLogin();
        } else {
            this.joinCheckNetwork();
        }
    }

    private void reLogin() {
        int netClassType;
        this.netStatus = netClassType = ConnectionReceiver.getNetType((Context)this);
        if (netClassType == 4) {
            this.reJoinWeb();
        } else if (netClassType == 5) {
            this.showErrDialog(this.getString(ResManager.getStringId("fs_gs_net_no_network")), this.getString(ResManager.getStringId("fs_gs_i_known")));
        } else {
            this.showDialogByNet(this.getNetTip(netClassType), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    BaseLiveActivity.this.reJoinWeb();
                }
            });
        }
    }

    private void reJoinWeb() {
        RTLive.getIns().initJoin();
    }

    protected abstract int getLayoutResID();

    private void initData() {
        this.simpleImpl = RTLive.getIns();
    }

    protected abstract void initView(Bundle var1);

    protected void joinCheckNetwork() {
        int netClassType;
        if (this.simpleImpl.getStatus() != 1) {
            return;
        }
        this.netStatus = netClassType = ConnectionReceiver.getNetType((Context)this);
        if (netClassType == 4) {
            this.join();
        } else if (netClassType == 5) {
            this.showErrDialog(this.getString(ResManager.getStringId("fs_gs_net_no_network")), this.getString(ResManager.getStringId("fs_gs_i_known")));
        } else {
            this.showDialogByNet(this.getNetTip(netClassType), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    BaseLiveActivity.this.join();
                }
            });
        }
    }

    private void showDialogByNet(String msg, DialogInterface.OnClickListener l) {
        this.showDialog(null, msg, this.getString(ResManager.getStringId("fs_gs_exit")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                BaseLiveActivity.this.exit();
            }
        }, this.getString(ResManager.getStringId("fs_gs_continues")), l, null);
    }

    protected abstract void onDismissClick(String var1);

    public void showDialogByLOD(final LiveodItem liveodItem, final String dismissMsg) {
        this.showDialog(null, this.getString(ResManager.getStringId("fs_gs_lod_is_on")), this.getString(ResManager.getStringId("fs_gs_cancel")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                BaseLiveActivity.this.onDismissClick(dismissMsg);
            }
        }, this.getString(ResManager.getStringId("fs_gs_end")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                RTLive.getIns().getRtSdk().lodStop(liveodItem.getId(), null);
            }
        }, null);
    }

    public void showDialogByAS(final String dismissMsg) {
        this.showDialog(null, this.getString(ResManager.getStringId("fs_gs_as_is_on_msg")), this.getString(ResManager.getStringId("fs_gs_i_known")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                BaseLiveActivity.this.onDismissClick(dismissMsg);
            }
        }, null, null, null);
    }

    protected void joinInitUI(RTLive simpleImpl) {
    }

    private void join() {
        this.joinInitUI(this.simpleImpl);
        if (this.simpleImpl.getStatus() == 1) {
            RTLive.getIns().initJoin();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(APP_START_TYPE, this.appStartType);
        outState.putString(APP_LANCHCODE, this.lanchCode);
        outState.putSerializable("APP_LUNACH_ENTITY", (Serializable)this.loginResEntity);
    }

    protected void onStop() {
        RTLive.getIns().audioCloseSpeaker();
        RTLive.getIns().setAppBackGround(true);
        super.onStop();
    }

    protected void onResume() {
        RTLive.getIns().audioOpenSpeaker();
        RTLive.getIns().setAppBackGround(false);
        RTLive.getIns().setRefreshVideo(true);
        super.onResume();
    }

    @Override
    public void onSwitchMobile(int netClass) {
        GenseeLog.d((String)this.TAG, (String)("onSwitchMobile netStatus:" + this.netStatus));
        if (netClass != this.netStatus) {
            this.netStatus = netClass;
            if (this.netStatus != 4) {
                if (this.netStatus == 5) {
                    this.showReconnectText(this.netStatus);
                    return;
                }
                if (RTLive.getIns().isLiveStart()) {
                    this.showReconnectText(this.netStatus);
                }
                this.showDialogByNet(this.getNetTip(netClass), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            } else {
                this.showReconnectView(false);
                this.cancelCustomDialog();
            }
        }
    }

    protected void showReconnectView(boolean isShow) {
    }

    protected void showReconnectText(int netStatus) {
    }

    protected void exit() {
        this.finish();
    }

    private String getNetTip(int netClassType) {
        if (RTLive.getIns().isHost()) {
            return this.getString(ResManager.getStringId("fs_gs_net_x_g_host"));
        }
        switch (netClassType) {
            case 1: {
                return this.getString(ResManager.getStringId("fs_gs_net_2g"));
            }
            case 2: {
                return this.getString(ResManager.getStringId("fs_gs_net_3g"));
            }
            case 3: {
                return this.getString(ResManager.getStringId("fs_gs_net_4g"));
            }
            case 5: {
                return this.getString(ResManager.getStringId("fs_gs_net_disconnect"));
            }
        }
        return this.getString(ResManager.getStringId("fs_gs_net_2g"));
    }

    protected void release() {
        UserInfo self = RTLive.getIns().getSelf();
        if (null != self && self.IsHost()) {
            RTLive.getIns().getRtSdk().roomNotifyBroadcastMsg(GenseeUtils.formatText(self.getName(), 12) + this.getString(ResManager.getStringId("fs_gs_chat_host_leave")), true, null);
        }
        this.stopLogService();
        if (null != this.simpleImpl) {
            if (null != self && self.IsHost() && RTLive.getIns().isSelfOnRostrum()) {
                RTLive.getIns().roomRecord(State.S_STOPPED.getValue());
                this.simpleImpl.leave(true);
            } else {
                this.simpleImpl.leave(false);
            }
        }
    }

    public void onError(final int errorCode) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String errStr = "";
                errStr = errorCode == -108 ? BaseLiveActivity.this.getString(ResManager.getStringId("fs_gs_join_webcast_err_third_auth")) : BaseLiveActivity.this.getErrStr(errorCode);
                BaseLiveActivity.this.showErrDialog(errStr, BaseLiveActivity.this.getString(ResManager.getStringId("fs_gs_i_known")));
            }
        });
    }

    public void onRoleHostDowngrade() {
        this.release();
    }

    public byte getDanmakuPriority(UserInfo userInfo) {
        int level = 0;
        if (userInfo.IsHost()) {
            level = 3;
        } else if (userInfo.IsPresentor()) {
            level = 2;
        } else if (userInfo.IsPanelist()) {
            level = 1;
        }
        return (byte)level;
    }
}

