/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.widget.TextView;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.ui.BaseLiveActivity;
import com.gensee.fastsdk.ui.BasePubFragment;
import com.gensee.fastsdk.ui.holder.chat.impl.RTChatImpl;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;

public abstract class BasePubLiveActivity
extends BaseLiveActivity {
    protected BasePubFragment basePubFragment;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            Object obj = msg.obj;
            switch (msg.what) {
                case 3000: {
                    GenseeLog.i((String)"UIMsg.AUDIO_ON_AUDIO_MIC_OPEN");
                    if (null == BasePubLiveActivity.this.basePubFragment) break;
                    BasePubLiveActivity.this.basePubFragment.onAudioMicOpen();
                    break;
                }
                case 3001: {
                    GenseeLog.i((String)"UIMsg.AUDIO_ON_AUDIO_MIC_CLOSE");
                    if (null == BasePubLiveActivity.this.basePubFragment) break;
                    BasePubLiveActivity.this.basePubFragment.onAudioMicClose();
                    break;
                }
                case 9000: {
                    GenseeLog.i((String)BasePubLiveActivity.this.TAG, (String)"UIMsg.CHAT_FORBID");
                    BasePubLiveActivity.this.showDialog("", BasePubLiveActivity.this.getString(ResManager.getStringId("fs_gs_chat_forbid")), BasePubLiveActivity.this.getString(ResManager.getStringId("fs_gs_i_known")), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                        }
                    });
                    break;
                }
                case 1000: {
                    GenseeLog.i((String)BasePubLiveActivity.this.TAG, (String)"UIMsg.publish UIMsg.ROOM_ON_ROOM_JOIN");
                    BasePubLiveActivity.this.showLoadingView(false);
                    BasePubLiveActivity.this.onRoomJoin((Integer)obj);
                    GenseeUtils.autoSendCrashLog((Context)BasePubLiveActivity.this);
                    break;
                }
                case 1008: {
                    GenseeLog.i((String)BasePubLiveActivity.this.TAG, (String)"UIMsg.ROOM_ON_ROOM_LEAVE");
                    BasePubLiveActivity.this.onRoomLeave((Integer)obj);
                    break;
                }
                case 1009: {
                    GenseeLog.i((String)BasePubLiveActivity.this.TAG, (String)"UIMsg.ROOM_ON_ROOM_RECONNENT");
                    BasePubLiveActivity.this.showReconnectText(BasePubLiveActivity.this.netStatus);
                    if (null == BasePubLiveActivity.this.basePubFragment) break;
                    BasePubLiveActivity.this.basePubFragment.onRoomReconnect();
                    break;
                }
                case 1007: {
                    GenseeLog.i((String)BasePubLiveActivity.this.TAG, (String)("UIMsg.ROOM_ON_ROOM_PUBLISH state=" + obj));
                    if (null == BasePubLiveActivity.this.basePubFragment) break;
                    BasePubLiveActivity.this.basePubFragment.onRoomPublish(obj);
                    break;
                }
                case 1006: {
                    if (null == obj || null == BasePubLiveActivity.this.basePubFragment) break;
                    BasePubLiveActivity.this.basePubFragment.updateTitle((String)obj);
                    break;
                }
                case 8000: {
                    if (null == BasePubLiveActivity.this.basePubFragment) break;
                    BasePubLiveActivity.this.basePubFragment.showAsDialog();
                    break;
                }
                case 8001: {
                    if (null == BasePubLiveActivity.this.basePubFragment) break;
                    BasePubLiveActivity.this.cancelCustomDialog();
                    BasePubLiveActivity.this.basePubFragment.endAs();
                    break;
                }
                case 6005: {
                    if (null == BasePubLiveActivity.this.basePubFragment) break;
                    BasePubLiveActivity.this.onRoleHostDowngrade();
                    break;
                }
            }
        }
    };

    public Handler getHandler() {
        return this.mHandler;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.simpleImpl = RTLive.getIns();
        this.simpleImpl.initResource((Context)this, this.mHandler);
        super.onCreate(savedInstanceState);
        PreferUtil.getIns().putInt("MIC_STATUS", -1);
        this.replaceFragment();
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        this.linLoadView = this.findViewById(ResManager.getId("gs_linLoadView"));
        this.linloadPb = this.findViewById(ResManager.getId("gs_linLoadPro"));
        this.linLoadNetDisconnected = this.findViewById(ResManager.getId("gs_linLoadNetDisconnected"));
        this.relExit = this.findViewById(ResManager.getId("gs_exit_rel"));
        this.lyLoadText = this.findViewById(ResManager.getId("gs_lyLoadText"));
        this.loadText = (TextView)this.findViewById(ResManager.getId("gs_loadText"));
    }

    @Override
    protected void onDismissClick(String dismissMsg) {
    }

    @Override
    protected void joinInitUI(RTLive simpleImpl) {
        this.linLoadView.setVisibility(0);
        this.linloadPb.setVisibility(0);
        this.linLoadNetDisconnected.setVisibility(8);
        ((RTChatImpl)this.chatImpl).setHandler(this.mHandler);
    }

    @Override
    public void onRoleHostDowngrade() {
        this.relExit.setVisibility(0);
        super.onRoleHostDowngrade();
    }

    protected abstract void replaceFragment();

    private void onRoomJoin(int result) {
        int resId = 0;
        switch (result) {
            case -1: {
                resId = ResManager.getStringId("fs_gs_join_webcast_err_param");
                break;
            }
            case 5: {
                resId = ResManager.getStringId("fs_gs_join_webcast_err_codec");
                break;
            }
            case 3: {
                resId = ResManager.getStringId("fs_gs_join_webcast_err_host");
                break;
            }
            case 4: {
                resId = ResManager.getStringId("fs_gs_join_webcast_err_license");
                break;
            }
            case 2: {
                resId = ResManager.getStringId("fs_gs_join_webcast_err_locked");
                break;
            }
            case 7: {
                resId = ResManager.getStringId("fs_gs_join_webcast_err_ip");
                break;
            }
            case 8: {
                resId = ResManager.getStringId("fs_gs_join_webcast_err_too_early");
                break;
            }
            case 6: {
                break;
            }
            case 1011: {
                resId = ResManager.getStringId("fs_gs_join_panelist");
                break;
            }
            case 0: {
                this.basePubFragment.onRoomJoinSuccess();
                this.registerAppReceiver();
                break;
            }
        }
        if (resId != 0) {
            this.showErrDialog(this.getString(resId), this.getString(ResManager.getStringId("fs_gs_i_known")));
        }
    }

    private void onRoomLeave(int result) {
        this.unRegisterReceiver();
        int resId = 0;
        if (result == 0) {
            this.relExit.setVisibility(8);
            this.exit();
            return;
        }
        String sTip = this.getString(ResManager.getStringId("fs_gs_i_known"));
        if (result == 1) {
            resId = ResManager.getStringId("fs_gs_leave_err_eject_tip");
        } else if (result == 2) {
            resId = ResManager.getStringId("fs_gs_leave_webcast_err_timeup");
        } else if (result == 3) {
            resId = ResManager.getStringId("fs_gs_leave_err_close_tip");
        } else if (result == 4) {
            resId = ResManager.getStringId("fs_gs_leave_err_ip_deny");
        } else {
            return;
        }
        this.showErrDialog(this.getString(resId), sTip);
    }

    public void onBackPressed() {
        String title = this.getString(ResManager.getStringId("fs_gs_end_webcast"));
        this.showDialog("", title, this.getString(ResManager.getStringId("fs_gs_end")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                BasePubLiveActivity.this.release();
                BasePubLiveActivity.this.relExit.setVisibility(0);
            }
        }, this.getString(ResManager.getStringId("fs_gs_continues")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, null, 2);
    }

    @Override
    protected void showReconnectText(int netStatus) {
        this.showReconnectView(true);
        if (netStatus == 5) {
            this.loadText.setText((CharSequence)this.getString(ResManager.getStringId("fs_gs_net_have_disconnect")));
        } else if (RTLive.getIns().isReconnecting()) {
            this.loadText.setText((CharSequence)this.getString(ResManager.getStringId("fs_gs_net_connecting")));
        } else {
            this.showReconnectView(false);
        }
    }

    @Override
    protected void showReconnectView(boolean isShow) {
        this.lyLoadText.setVisibility(isShow ? 0 : 8);
    }

    protected void showLoadingView(boolean isShow) {
        this.linLoadView.setVisibility(isShow ? 0 : 8);
        this.showReconnectView(isShow);
    }

    @Override
    protected void exit() {
        this.removeCache();
        super.exit();
    }

    private void removeCache() {
        if (null != this.chatImpl) {
            this.chatImpl.release();
        }
        this.deleteDatabase("GsPlayerChat.db");
        if (null != this.basePubFragment) {
            this.basePubFragment.showTime(false);
        }
    }
}

