/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.gensee.entity.InitParam;
import com.gensee.fastsdk.core.VodPlayerImp;
import com.gensee.fastsdk.entity.OfflinePlayParam;
import com.gensee.fastsdk.ui.NetStatusActivity;
import com.gensee.fastsdk.ui.holder.chat.VodChatHolder;
import com.gensee.fastsdk.ui.holder.doc.VodDocHolder;
import com.gensee.fastsdk.ui.holder.midtab.VodMidTabsHolder;
import com.gensee.fastsdk.ui.holder.qa.VodQaHolder;
import com.gensee.fastsdk.ui.holder.topfloat.VodTopFloatHolder;
import com.gensee.fastsdk.ui.holder.video.VodVideoHolder;
import com.gensee.fastsdk.ui.holder.vod.VodChapterHolder;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.utils.GenseeLog;

public class VodActivity
extends NetStatusActivity
implements View.OnClickListener,
VodPlayerImp.OnVodInfoListener {
    private VodVideoHolder mVodVideoHolder;
    private VodDocHolder mVodDocHolder;
    private VodChatHolder mVodChatHolder;
    private VodQaHolder mVodQaHolder;
    private VodMidTabsHolder mVodMidTabsHolder;
    private VodTopFloatHolder mVodTopFloatHolder;
    private VodChapterHolder mVodChapterHolder;
    private View linLoadView;
    private View linLoadPro;
    private View linLoadNetDisconnected;
    private View linloadPb;
    private RelativeLayout relExit;
    private VodPlayerImp mVodPlayerImp;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.getWindow().setFlags(128, 128);
        super.onCreate(savedInstanceState);
        ResManager.getIns().init((Context)this);
        ResManager.setIsSkinTypeNight(true);
        this.setContentView(ResManager.getLayoutId("fs_activity_vod_layout"));
        this.initData(savedInstanceState);
        this.initView(savedInstanceState);
        this.layout(savedInstanceState);
        this.update();
        if (this.mVodPlayerImp.isParamValid()) {
            this.shareAddr();
            this.joinCheckNetwork();
        } else {
            GenseeLog.e((String)this.TAG, (String)"mInitParam is NULL");
        }
        MsgQueue.getIns().initMsgDb(this.getApplicationContext());
        QaMsgQueue.getIns().initMsgDb(this.getApplicationContext());
    }

    protected void onResume() {
        super.onResume();
        if (null != this.mVodTopFloatHolder) {
            this.mVodTopFloatHolder.registerPowerReceiver(this);
            this.mVodTopFloatHolder.layoutRestore();
            this.mVodTopFloatHolder.onResume();
        }
        if (null != this.mVodPlayerImp) {
            this.mVodPlayerImp.onResume();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mVodTopFloatHolder != null) {
            this.mVodTopFloatHolder.unregisterPowerReceiver(this);
        }
    }

    protected void onStop() {
        if (null != this.mVodPlayerImp) {
            this.mVodPlayerImp.onStop();
        }
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    protected void showLoadingView(boolean isShow) {
        this.linLoadView.setVisibility(isShow ? 0 : 8);
    }

    private void initData(Bundle savedInstanceState) {
        Bundle bundle = this.getIntent().getExtras();
        this.mVodPlayerImp = new VodPlayerImp((InitParam)bundle.getSerializable("VOD_JOIN_ONLINE_PARAM"), (OfflinePlayParam)bundle.getSerializable("VOD_JOIN_OFFLINE_PARAM"));
        this.mVodPlayerImp.setOnVodInfoListener(this);
        this.mVodPlayerImp.onRestoreInstanceState(savedInstanceState);
    }

    private void initView(Bundle savedInstanceState) {
        this.relExit = (RelativeLayout)this.findViewById(ResManager.getId("exit_rel"));
        this.mVodTopFloatHolder = new VodTopFloatHolder(this.findViewById(ResManager.getId("topFloatView")), this.mVodPlayerImp);
        this.mVodVideoHolder = new VodVideoHolder(this.findViewById(ResManager.getId("videoLayout")), null);
        this.mVodPlayerImp.setOnVodVideoListener(this.mVodVideoHolder);
        this.mVodDocHolder = new VodDocHolder(this.findViewById(ResManager.getId("docLayout")), null);
        this.mVodPlayerImp.setOnVodDocListener(this.mVodDocHolder);
        this.mVodMidTabsHolder = new VodMidTabsHolder(this.findViewById(ResManager.getId("midTabs")), this);
        this.mVodChapterHolder = new VodChapterHolder(this.findViewById(ResManager.getId("vod_chapter_ly")), this.mVodPlayerImp);
        this.mVodPlayerImp.setOnVodChapterListener(this.mVodChapterHolder);
        this.mVodChatHolder = new VodChatHolder(this.findViewById(ResManager.getId("vod_chat_ly")), null);
        this.mVodPlayerImp.setOnVodChatListener(this.mVodChatHolder);
        this.mVodPlayerImp.setOnVodRecordInfoListener(this.mVodChatHolder);
        this.mVodQaHolder = new VodQaHolder(this.findViewById(ResManager.getId("vod_qa_ly")), this.mVodPlayerImp);
        this.mVodPlayerImp.setOnVodQaHistoryListener(this.mVodQaHolder);
        if (null == savedInstanceState) {
            this.mVodQaHolder.release();
        }
        this.linLoadView = this.findViewById(ResManager.getId("linLoadView"));
        this.linLoadPro = this.linLoadView.findViewById(ResManager.getId("linLoadPro"));
        this.linloadPb = this.linLoadView.findViewById(ResManager.getId("progress_bar"));
        this.linLoadNetDisconnected = this.linLoadView.findViewById(ResManager.getId("linLoadNetDisconnected"));
        this.mVodTopFloatHolder.setVodDocHolder(this.mVodDocHolder);
        this.mVodTopFloatHolder.setVodVideoHolder(this.mVodVideoHolder);
        this.mVodTopFloatHolder.layout(savedInstanceState);
    }

    @Override
    public void exit() {
        if (null != this.mVodPlayerImp) {
            this.mVodPlayerImp.release();
        }
        this.removeCache();
        this.finish();
    }

    @Override
    protected void join() {
        this.linLoadView.setVisibility(0);
        this.linloadPb.setVisibility(0);
        this.linLoadNetDisconnected.setVisibility(8);
        this.mVodPlayerImp.initVod((Context)this);
    }

    @Override
    public void onSwitchMobile(int netClass) {
        if (netClass != this.netStatus) {
            this.netStatus = netClass;
            if (this.netStatus != 4) {
                if (this.netStatus == 5) {
                    return;
                }
                if (this.mVodPlayerImp.isOnPlaying()) {
                    this.showDialogByNet(this.getNetTip(netClass), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                        }
                    });
                }
            } else {
                this.cancelCustomDialog();
            }
        }
    }

    private void layout(Bundle savedInstanceState) {
        this.mVodMidTabsHolder.layout(savedInstanceState);
        int uimode = this.mVodTopFloatHolder.getUIMode();
        if ((uimode & 1) == 1) {
            this.linLoadPro.setLayoutParams((ViewGroup.LayoutParams)this.mVodTopFloatHolder.getFullParam());
        } else {
            this.linLoadPro.setLayoutParams((ViewGroup.LayoutParams)this.mVodTopFloatHolder.getTopLayoutParam());
        }
    }

    private void update() {
        boolean isTopVideo = 4 == (this.mVodTopFloatHolder.getUIMode() & 4);
        this.mVodMidTabsHolder.updateTabText(1, this.getString(isTopVideo ? ResManager.getStringId("fs_doc") : ResManager.getStringId("fs_video")));
    }

    public void onClick(View v) {
        int uimode = this.mVodTopFloatHolder.getUIMode();
        if (v.getId() == ResManager.getId("lyTab1")) {
            if ((uimode & 4) == 4) {
                this.mVodDocHolder.show(true);
            } else {
                this.mVodVideoHolder.show(true);
            }
            this.mVodChatHolder.show(false);
            this.mVodQaHolder.show(false);
            this.mVodChapterHolder.show(false);
        } else if (v.getId() == ResManager.getId("lyTab2")) {
            if ((uimode & 4) == 4) {
                this.mVodDocHolder.show(false);
            } else {
                this.mVodVideoHolder.show(false);
            }
            this.mVodChatHolder.show(true);
            this.mVodQaHolder.show(false);
            this.mVodChapterHolder.show(false);
        } else if (v.getId() == ResManager.getId("lyTab3")) {
            if ((uimode & 4) == 4) {
                this.mVodDocHolder.show(false);
            } else {
                this.mVodVideoHolder.show(false);
            }
            this.mVodQaHolder.show(true);
            this.mVodChatHolder.show(false);
            this.mVodChapterHolder.show(false);
        } else if (v.getId() == ResManager.getId("lyTab4")) {
            if ((uimode & 4) == 4) {
                this.mVodDocHolder.show(false);
            } else {
                this.mVodVideoHolder.show(false);
            }
            this.mVodQaHolder.show(false);
            this.mVodChatHolder.show(false);
            this.mVodChapterHolder.show(true);
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        GenseeLog.i((String)this.TAG, (String)"onConfigurationChanged");
        int uimode = this.mVodTopFloatHolder.getUIMode();
        if (newConfig.orientation == 2) {
            this.showFullScreen(uimode);
        } else if (newConfig.orientation == 1) {
            this.showNorScreen(uimode);
        }
    }

    public void showFullScreen(int uimode) {
        this.mVodTopFloatHolder.updateUIMode(1, true);
        this.getWindow().addFlags(1024);
        this.mVodTopFloatHolder.showFullScreen(true);
        this.mVodDocHolder.showDocFloatBtn(3);
        this.mVodVideoHolder.showVideoFloatBtn(3);
        this.linLoadPro.setLayoutParams((ViewGroup.LayoutParams)this.mVodTopFloatHolder.getFullParam());
        if ((uimode & 2) == 2) {
            this.mVodVideoHolder.showFullScreen();
            this.mVodDocHolder.show(false);
            this.mVodVideoHolder.continueShowBtn();
            this.mVodVideoHolder.delayDismissFloatBtns();
            this.mVodDocHolder.dismissOwnBtn();
        } else {
            this.mVodDocHolder.showFullScreen();
            this.mVodVideoHolder.show(false);
            this.mVodDocHolder.continueShowBtn();
            this.mVodDocHolder.delayDismissFloatBtns();
            this.mVodVideoHolder.dismissOwnBtn();
        }
        this.mVodMidTabsHolder.show(false);
    }

    public void showNorScreen(int uimode) {
        if ((uimode & 1) == 1) {
            if ((uimode & 2) == 2) {
                this.mVodTopFloatHolder.showFullScreen(true);
                this.mVodVideoHolder.continueShowBtn();
                this.mVodVideoHolder.delayDismissFloatBtns();
            } else {
                this.mVodTopFloatHolder.showFullScreen(true);
                this.mVodDocHolder.showPortraitDocFullScreen();
                this.mVodDocHolder.continueShowBtn();
                this.mVodDocHolder.delayDismissFloatBtns();
            }
            return;
        }
        this.mVodDocHolder.showPortraitDocNorScreen();
        this.mVodMidTabsHolder.show(true);
        this.mVodTopFloatHolder.updateUIMode(1, false);
        this.getWindow().clearFlags(1024);
        this.mVodTopFloatHolder.showFullScreen(false);
        this.linLoadPro.setLayoutParams((ViewGroup.LayoutParams)this.mVodTopFloatHolder.getTopLayoutParam());
        if ((uimode & 4) == 4) {
            this.mVodDocHolder.layout(this.mVodDocHolder.getLayoutParam());
            this.mVodVideoHolder.layout(this.mVodTopFloatHolder.getTopLayoutParam());
            this.mVodVideoHolder.show(true);
            this.mVodVideoHolder.showVideoFloatBtn(1);
            this.mVodDocHolder.showDocFloatBtn(2);
            if (this.mVodMidTabsHolder.getAcitiveId() == ResManager.getId("lyTab1")) {
                this.mVodDocHolder.show(true);
            }
        } else {
            this.mVodDocHolder.layout(this.mVodTopFloatHolder.getTopLayoutParam());
            this.mVodVideoHolder.layout(this.mVodDocHolder.getLayoutParam());
            this.mVodVideoHolder.showVideoFloatBtn(2);
            this.mVodDocHolder.showDocFloatBtn(1);
            this.mVodDocHolder.show(true);
            if (this.mVodMidTabsHolder.getAcitiveId() == ResManager.getId("lyTab1")) {
                this.mVodVideoHolder.show(true);
            }
        }
        this.mVodVideoHolder.continueShowBtn();
        this.mVodVideoHolder.delayDismissFloatBtns();
        this.mVodDocHolder.continueShowBtn();
        this.mVodDocHolder.delayDismissFloatBtns();
    }

    public int getUIMode() {
        return this.mVodTopFloatHolder.getUIMode();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mVodMidTabsHolder.onSaveInstence(outState);
        this.mVodDocHolder.onSaveInstence(outState);
        this.mVodTopFloatHolder.onSaveInstence(outState);
        this.mVodPlayerImp.onSaveInstanceState(outState);
    }

    public void onBackPressed() {
        if (!this.mVodTopFloatHolder.onBackNorScreen()) {
            this.showErrMsg("", this.getString(ResManager.getStringId("fs_vod_play_exit")), this.getString(ResManager.getStringId("fs_gs_cancel")), this.getResources().getColor(ResManager.getColorId("fs_dialog_btn_text2")), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }, this.getString(ResManager.getStringId("fs_gs_end")), this.getResources().getColor(ResManager.getColorId("fs_dialog_btn_text1")), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    VodActivity.this.exit();
                }
            }, null);
        }
    }

    @Override
    public void onInitVodSuccess() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (null != VodActivity.this.mVodPlayerImp) {
                    VodActivity.this.mVodPlayerImp.setGSVideoView(VodActivity.this.mVodVideoHolder.getVideoView());
                    VodActivity.this.mVodPlayerImp.setGSDocView(VodActivity.this.mVodDocHolder.getDocView());
                    VodActivity.this.mVodPlayerImp.playVod();
                    if (VodActivity.this.mVodPlayerImp.isOnlinePlay()) {
                        VodActivity.this.mVodQaHolder.refreshQaHistory();
                    }
                }
                VodActivity.this.mVodVideoHolder.delayDismissFloatBtns();
                VodActivity.this.mVodDocHolder.delayDismissFloatBtns();
                VodActivity.this.registerAppReceiver();
                GenseeUtils.autoSendCrashLog((Context)VodActivity.this);
            }
        });
    }

    @Override
    public void onCaching(final boolean isCaching) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VodActivity.this.showLoadingView(isCaching);
            }
        });
    }

    @Override
    public void onVodInitPlayer() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VodActivity.this.showLoadingView(false);
            }
        });
    }

    @Override
    public void onVodSubject(final String subject) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (null != VodActivity.this.mVodTopFloatHolder) {
                    VodActivity.this.mVodTopFloatHolder.setTitle(subject);
                }
            }
        });
    }

    @Override
    public void onVodErr(final int err) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String msg = VodActivity.this.getErrMsg(err);
                if (!"".equals(msg)) {
                    VodActivity.this.showErrMsg("", msg, VodActivity.this.getString(ResManager.getStringId("fs_gs_i_known")), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            VodActivity.this.exit();
                        }
                    });
                }
            }
        });
    }

    private String getErrMsg(int errCode) {
        String msg = "";
        switch (errCode) {
            case -100: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_domain"));
                break;
            }
            case -101: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_time_out"));
                break;
            }
            case -103: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_site_unused"));
                break;
            }
            case -104: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_un_net"));
                break;
            }
            case -105: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_data_timeout"));
                break;
            }
            case -106: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_service"));
                break;
            }
            case -107: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_param"));
                break;
            }
            case -201: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_un_invoke_getobject"));
                break;
            }
            case 14: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_vod_init_fail"));
                break;
            }
            case 15: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_vod_num_unexist"));
                break;
            }
            case 16: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_vod_pwd_err"));
                break;
            }
            case 17: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_vod_acc_pwd_err"));
                break;
            }
            case 18: {
                msg = this.getString(ResManager.getStringId("fs_vod_err_unsupport_mobile"));
                break;
            }
            case -108: {
                msg = this.getString(ResManager.getStringId("fs_live_err_third_certification_authourity"));
                break;
            }
            default: {
                msg = this.getString(ResManager.getStringId("fs_vod_play_failure"));
            }
        }
        return msg;
    }

    public void dismissVideoFloatButtons() {
        if (null != this.mVodVideoHolder) {
            this.mVodVideoHolder.dismisssFloatBtns();
        }
    }

    public void dismissDocFloatButtons() {
        if (null != this.mVodDocHolder) {
            this.mVodDocHolder.dismisssFloatBtns();
        }
    }

    private void shareAddr() {
        PreferUtil.getIns().putSubject(this.getIntent().getStringExtra("VOD_PLAYER_SUBJECT"));
        PreferUtil.getIns().putShareAddr(this.getIntent().getStringExtra("VOD_PLAYER_URL"));
    }

    private void removeCache() {
        if (null != this.mVodChatHolder) {
            this.mVodChatHolder.release();
        }
        if (null != this.mVodQaHolder) {
            this.mVodQaHolder.release();
        }
    }
}

