/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.view.xlistview.XListView;
import com.gensee.fastsdk.util.ResManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class LvHolder
extends BaseHolder
implements XListView.IXListViewListener,
AbsListView.OnScrollListener {
    protected String TAG = this.getClass().getSimpleName();
    protected XListView lvChat;
    private AtomicBoolean bLvBottom;
    protected boolean bRefreshing = false;
    private AtomicBoolean bLvIdle = new AtomicBoolean(true);
    private PopupWindow popupWindow;

    public XListView getLvChat() {
        return this.lvChat;
    }

    public LvHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initComp(Object value) {
        this.lvChat = (XListView)this.findViewById(ResManager.getId("gs_chat_lv"));
        this.lvChat.setXListViewListener(this);
        this.lvChat.setOnScrollListener(this);
        this.lvChat.setPullLoadEnable(false);
        this.lvChat.setHeaderDividersEnabled(false);
        this.lvChat.setFooterDividersEnabled(false);
        this.bLvBottom = new AtomicBoolean(true);
    }

    public void updateXListViewUi(boolean bLatest) {
        if (!bLatest) {
            this.lvChat.addFootView();
            this.lvChat.setPullLoadEnable(true);
        } else {
            this.unEnableFootView();
        }
    }

    private void unEnableFootView() {
        this.lvChat.removeFootView();
        this.lvChat.setPullLoadEnable(false);
    }

    public void onLvReLoad() {
        this.lvChat.stopRefresh();
        this.onRefreshTime();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.lvChat.getLastVisiblePosition() == this.lvChat.getCount() - 1) {
            this.bLvBottom.set(true);
            this.onScrollToBottom(true);
        } else {
            this.bLvBottom.set(false);
            this.onScrollToBottom(false);
        }
        switch (scrollState) {
            case 0: {
                this.bLvIdle.set(true);
                break;
            }
            case 1: {
                this.bLvBottom.set(false);
                this.onScrollToBottom(false);
                break;
            }
            case 2: {
                this.bLvBottom.set(false);
                this.onScrollToBottom(false);
            }
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (!this.bLvIdle.get()) {
            if (firstVisibleItem + visibleItemCount == totalItemCount) {
                this.bLvBottom.set(true);
                this.onScrollToBottom(true);
            } else {
                this.bLvBottom.set(false);
                this.onScrollToBottom(false);
            }
        }
    }

    protected void onRefreshTime() {
        this.lvChat.setRefreshTime(LvHolder.getStringDate());
    }

    public static String getStringDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public boolean getLvBottom() {
        return this.bLvBottom.get();
    }

    protected void setLvBottom(boolean bTrue) {
        this.bLvBottom.set(bTrue);
        this.onScrollToBottom(bTrue);
    }

    @Override
    public void onRefresh() {
        if (this.bRefreshing) {
            this.onLvReLoad();
            return;
        }
        this.bRefreshing = true;
        this.refresh();
    }

    @Override
    public void onLoadMore() {
        if (this.bRefreshing) {
            this.lvChat.stopLoadMore();
            return;
        }
        this.bRefreshing = true;
        this.loadMore();
    }

    protected abstract void refresh();

    protected abstract void loadMore();

    public String replaceGifToText(String richText) {
        if (richText.startsWith("<SPAN>") && richText.endsWith("</SPAN>")) {
            richText = richText.substring(6, richText.length() - 7);
        }
        String startStr = "<IMG src=";
        String endStr = "custom=\"false\">";
        if (richText.indexOf(startStr) != -1) {
            String leftPart = richText.substring(0, richText.indexOf(startStr));
            String rightPart = richText.substring(richText.indexOf(endStr) + endStr.length(), richText.length());
            richText = leftPart + " [Emoji] " + rightPart;
            richText = this.replaceGifToText(richText);
        }
        return richText;
    }

    public void showCopyPopupWindow(final View anchor, final boolean isHongbaoItem, int xOffset, int yOffset, final String text) {
        LinearLayout layout = new LinearLayout(this.getContext());
        TextView tv = new TextView(this.getContext());
        tv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        tv.setText((CharSequence)this.getString(ResManager.getStringId("fs_chat_copy")));
        tv.setBackgroundResource(ResManager.getDrawableId("fs_ic_chat_copy_bg"));
        tv.setGravity(17);
        tv.setTextColor(-1);
        tv.setTextSize(12.0f);
        tv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LvHolder.this.popupWindow.dismiss();
                ClipboardManager clipboard = (ClipboardManager)LvHolder.this.getContext().getSystemService("clipboard");
                ClipData textCd = ClipData.newPlainText((CharSequence)"copy", (CharSequence)text);
                clipboard.setPrimaryClip(textCd);
            }
        });
        layout.addView((View)tv);
        int width = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        int height = (int)TypedValue.applyDimension((int)1, (float)35.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        this.popupWindow = new PopupWindow((View)layout, width, height, true);
        this.popupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.popupWindow.setOutsideTouchable(true);
        int[] location = new int[2];
        anchor.getLocationOnScreen(location);
        int[] loc2 = new int[2];
        anchor.getLocationInWindow(loc2);
        int x = 0;
        x = xOffset > location[0] + anchor.getWidth() || xOffset < location[0] ? location[0] + anchor.getWidth() / 2 - this.popupWindow.getWidth() / 2 : xOffset - this.popupWindow.getWidth() / 2;
        this.popupWindow.showAtLocation(anchor, 0, x, location[1] - this.popupWindow.getHeight());
        anchor.setBackgroundColor(Color.parseColor((String)"#070707"));
        anchor.setAlpha(0.4f);
        this.popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                anchor.setBackgroundColor(0);
                if (isHongbaoItem) {
                    anchor.setBackgroundResource(ResManager.getDrawableId("fs_ic_chat_hb_bg"));
                }
                anchor.setAlpha(1.0f);
            }
        });
    }

    protected void onScrollToBottom(boolean bScroolBottom) {
    }
}

