/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.entity.RewardResult;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.holder.chat.impl.RTChatImpl;
import com.gensee.fastsdk.ui.view.xlistview.XListView;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.hongbao.TipInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class TipBoardHolder
extends BaseHolder
implements XListView.IXListViewListener {
    private final RTChatImpl chatImpl;
    private View ivBack;
    private TextView tvTotalMoney;
    private XListView lvTipBoard;
    private View tvEmptyView;
    private TipBoardAdapter adapter;
    private boolean isFirst;
    private View llTipListContent;
    private boolean bRefreshing;
    private View rlTipLoading;

    public TipBoardHolder(View rootView, Object value) {
        super(rootView, value);
        this.chatImpl = (RTChatImpl)value;
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.ivBack = this.findViewById(ResManager.getId("gs_tip_borad_back"));
        this.ivBack.setOnClickListener((View.OnClickListener)this);
        this.tvTotalMoney = (TextView)this.findViewById(ResManager.getId("gs_tip_total_money"));
        this.lvTipBoard = (XListView)this.findViewById(ResManager.getId("gs_lv_tip_board"));
        this.lvTipBoard.setXListViewListener(this);
        this.tvEmptyView = this.findViewById(ResManager.getId("tip_empty_view"));
        this.llTipListContent = this.findViewById(ResManager.getId("gs_ll_tip_content"));
        this.lvTipBoard.setEmptyView(this.tvEmptyView);
        this.adapter = new TipBoardAdapter();
        this.lvTipBoard.setAdapter((ListAdapter)this.adapter);
        this.isFirst = true;
        this.rlTipLoading = this.findViewById(ResManager.getId("rl_tip_loading"));
        this.rootView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
    }

    @Override
    public void show(boolean isShow) {
        super.show(isShow);
        if (isShow && RTLive.getIns().isJoin()) {
            RTLive.getIns().getRtSdk().tipQueryTotalAmount(null);
            if (this.isFirst) {
                this.llTipListContent.setVisibility(8);
                this.showLoadingView(true);
                this.isFirst = false;
            }
            RTLive.getIns().getRtSdk().tipQueryTopList(50, null);
        }
    }

    private void showLoadingView(boolean isShow) {
        this.rlTipLoading.setVisibility(isShow ? 0 : 8);
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("gs_tip_borad_back")) {
            this.show(false);
        }
    }

    public void onTipQueryTotalAmount(int totalAmount) {
        this.setTotalMoneyText(totalAmount);
    }

    public void onTipQueryTopList(TipInfo[] tips) {
        this.post(new Runnable(){

            @Override
            public void run() {
                TipBoardHolder.this.llTipListContent.setVisibility(0);
                TipBoardHolder.this.showLoadingView(false);
                TipBoardHolder.this.onLvReLoad();
                TipBoardHolder.this.bRefreshing = false;
            }
        });
        if (null == tips) {
            return;
        }
        HashMap<Long, TipInfo> map = new HashMap<Long, TipInfo>();
        for (int i = 0; i < tips.length; ++i) {
            if (null == tips[i]) continue;
            long key = tips[i].getUserId();
            if (map.containsKey(key)) {
                TipInfo mergeTipInfo = new TipInfo();
                mergeTipInfo.setUserId(key);
                mergeTipInfo.setUserName(tips[i].getUserName());
                mergeTipInfo.setTotal(((TipInfo)map.get(key)).getTotal() + tips[i].getTotal());
                map.put(key, mergeTipInfo);
                continue;
            }
            map.put(key, tips[i]);
        }
        if (map.size() <= 0) {
            return;
        }
        final ArrayList list = new ArrayList(map.values());
        Collections.sort(list, new Comparator<TipInfo>(){

            @Override
            public int compare(TipInfo tipInfo, TipInfo t1) {
                return new Integer(t1.getTotal()).compareTo(new Integer(tipInfo.getTotal()));
            }
        });
        this.post(new Runnable(){

            @Override
            public void run() {
                TipBoardHolder.this.adapter.notifyData(list);
            }
        });
    }

    public void setTotalMoneyText(final int totalAmount) {
        this.post(new Runnable(){

            @Override
            public void run() {
                String rmb = GenseeUtils.getRMBText(totalAmount);
                if (null != TipBoardHolder.this.tvTotalMoney) {
                    TipBoardHolder.this.tvTotalMoney.setText((CharSequence)rmb);
                }
            }
        });
    }

    public void onTipComingNotify(RewardResult tip, int totalAmount) {
        String msg = tip.getName() + this.getString(ResManager.getStringId("fs_gs_tip_tiped"));
        this.setTotalMoneyText(totalAmount);
        this.chatImpl.addTipMessage(msg);
    }

    @Override
    public void onRefresh() {
        if (this.bRefreshing) {
            this.onLvReLoad();
            return;
        }
        this.bRefreshing = true;
        RTLive.getIns().getRtSdk().tipQueryTopList(50, null);
    }

    public void onLvReLoad() {
        this.lvTipBoard.stopRefresh();
        this.onRefreshTime();
    }

    protected void onRefreshTime() {
        this.lvTipBoard.setRefreshTime(TipBoardHolder.getStringDate());
    }

    public static String getStringDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    @Override
    public void onLoadMore() {
    }

    private class TipBoardAdapter
    extends AbstractAdapter {
        private TipBoardAdapter() {
        }

        protected View createView(Context context) {
            return LayoutInflater.from((Context)context).inflate(ResManager.getLayoutId("fs_gs_tip_board_item"), null);
        }

        protected AbstractViewHolder createViewHolder(View view) {
            return new TipBoardViewHolder(view);
        }

        private class TipBoardViewHolder
        extends AbstractViewHolder {
            private ImageView gs_iv_medal;
            private TextView gs_tv_tip_name;
            private TextView gs_tv_tip_mount;
            private TextView gs_tv_rank;

            public TipBoardViewHolder(View view) {
                super(view);
            }

            public void initView(View view) {
                this.gs_iv_medal = (ImageView)view.findViewById(ResManager.getId("gs_iv_medal"));
                this.gs_tv_tip_name = (TextView)view.findViewById(ResManager.getId("gs_tv_tip_name"));
                this.gs_tv_tip_mount = (TextView)view.findViewById(ResManager.getId("gs_tv_tip_mount"));
                this.gs_tv_rank = (TextView)view.findViewById(ResManager.getId("gs_tv_rank"));
            }

            public void initValue(int positon) {
                TipInfo tipInfo = (TipInfo)TipBoardAdapter.this.getItem(positon);
                if (tipInfo.getTotal() >= 10000) {
                    this.gs_iv_medal.setImageResource(ResManager.getDrawableId("fs_gs_ic_rank_gold"));
                    this.gs_tv_rank.setTextColor(Color.parseColor((String)"#cfac35"));
                } else if (tipInfo.getTotal() >= 1000 && tipInfo.getTotal() < 10000) {
                    this.gs_iv_medal.setImageResource(ResManager.getDrawableId("fs_gs_ic_rank_silver"));
                    this.gs_tv_rank.setTextColor(Color.parseColor((String)"#a6a6a6"));
                } else if (tipInfo.getTotal() > 0 && tipInfo.getTotal() < 1000) {
                    this.gs_iv_medal.setImageResource(ResManager.getDrawableId("fs_gs_ic_rank_bronze"));
                    this.gs_tv_rank.setTextColor(Color.parseColor((String)"#a58e64"));
                }
                this.gs_tv_tip_name.setText((CharSequence)GenseeUtils.formatText(tipInfo.getUserName(), 12));
                String rmb = GenseeUtils.getRMBText(tipInfo.getTotal());
                this.gs_tv_tip_mount.setText((CharSequence)rmb);
                this.gs_tv_rank.setText((CharSequence)(positon + 1 + ""));
            }
        }
    }
}

