/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat;

import android.os.Bundle;
import android.view.View;
import android.widget.AbsListView;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.entity.chat.PublicMessage;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.LvHolder;
import com.gensee.fastsdk.ui.holder.chat.AbsChatImpl;
import com.gensee.fastsdk.ui.view.xlistview.XListView;
import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import java.util.List;

public abstract class ChatHolder
extends LvHolder
implements XListView.IXListViewListener,
AbsListView.OnScrollListener {
    protected String TAG = this.getClass().getSimpleName();
    protected AbsChatImpl chatImpl;
    protected AbstractAdapter adapter;
    private OnCalcLVHeightAfterNewMsgListener calcLVListener;

    public ChatHolder(View rootView, Object value) {
        super(rootView, value);
        this.chatImpl = (AbsChatImpl)value;
    }

    public void setCalcLVHeightAfterNewMsgListener(OnCalcLVHeightAfterNewMsgListener l) {
        this.calcLVListener = l;
    }

    protected void notifyData(final List<AbsChatMessage> msgList) {
        if (null != this.adapter) {
            this.adapter.notifyData(msgList);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ChatHolder.this.getLvBottom()) {
                        ChatHolder.this.lvChat.setSelection(msgList.size());
                    }
                }
            }, 200L);
        }
    }

    @Override
    public void onMessage(int what, Object obj, Bundle bundle) {
        super.onMessage(what, obj, bundle);
        switch (what) {
            case 10003: 
            case 10006: 
            case 30003: {
                this.lvChat.stopLoadMore();
                this.notifyData((List)obj);
                boolean bLatest = bundle.getBoolean("LATEST");
                this.updateXListViewUi(bLatest);
                this.bRefreshing = false;
                break;
            }
            case 10000: 
            case 10004: 
            case 30000: {
                boolean bLatestNewMsg = bundle.getBoolean("LATEST");
                if (null != this.calcLVListener) {
                    this.calcLVListener.calcLVHeightAfterNewMsg();
                }
                this.notifyData((List)obj);
                this.updateXListViewUi(bLatestNewMsg);
                break;
            }
            case 10002: 
            case 10005: 
            case 30002: {
                boolean bLatest1 = bundle.getBoolean("LATEST");
                this.updateXListViewUi(bLatest1);
                this.notifyData((List)obj);
                this.onLvReLoad();
                this.bRefreshing = false;
                break;
            }
            case 10001: 
            case 10007: {
                this.notifyData((List)obj);
                if (what == 10001) {
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (ChatHolder.this.lvChat.getFirstVisiblePosition() + ChatHolder.this.lvChat.getChildCount() == ChatHolder.this.lvChat.getCount()) {
                                ChatHolder.this.setLvBottom(true);
                                ChatHolder.this.onScrollToBottom(true);
                            }
                        }
                    }, 200L);
                }
                this.updateXListViewUi(bundle.getBoolean("LATEST"));
            }
        }
    }

    protected UserInfo onChatItemClick(int position, long id) {
        if (null == this.adapter || null == this.chatImpl) {
            return null;
        }
        AbsChatMessage absChatMessage = (AbsChatMessage)this.adapter.getItem(position - 1);
        UserInfo toUser = null;
        if (absChatMessage instanceof PrivateMessage) {
            UserInfo self = PlayerLive.getIns().getSelf();
            if (null != self) {
                if (absChatMessage.getSendUserId() == self.getId()) {
                    toUser = new UserInfo();
                    toUser.setId(absChatMessage.getReceiveUserId());
                    toUser.setName(((PrivateMessage)absChatMessage).getReceiveName());
                    toUser.setRole(((PrivateMessage)absChatMessage).getReceiverRole());
                } else if (absChatMessage.getReceiveUserId() == self.getId()) {
                    toUser = new UserInfo();
                    toUser.setId(absChatMessage.getSendUserId());
                    toUser.setName(absChatMessage.getSendUserName());
                    toUser.setRole(absChatMessage.getSenderRole());
                }
            } else {
                GenseeLog.e((String)this.TAG, (String)("onChatItemClick self is null abschatmessage = " + absChatMessage));
            }
        } else if (absChatMessage instanceof PublicMessage) {
            UserInfo self = PlayerLive.getIns().getSelf();
            if (null != self) {
                if (absChatMessage.getSendUserId() != self.getId()) {
                    toUser = new UserInfo();
                    toUser.setId(absChatMessage.getSendUserId());
                    toUser.setName(absChatMessage.getSendUserName());
                    toUser.setRole(absChatMessage.getSenderRole());
                }
            } else {
                GenseeLog.e((String)this.TAG, (String)("onChatItemClick self is null abschatmessage = " + absChatMessage));
            }
        }
        if (null == toUser) {
            GenseeLog.e((String)this.TAG, (String)("onChatItemClick to user is null abschatmessage = " + absChatMessage));
            return null;
        }
        if (!(this.chatImpl.isSutPriChatEnable() || toUser.isAssistant() || toUser.isPresenter() || toUser.isHost())) {
            return null;
        }
        toUser.setChatId(absChatMessage.getChatId());
        return toUser;
    }

    public static interface OnCalcLVHeightAfterNewMsgListener {
        public void calcLVHeightAfterNewMsg();
    }
}

