/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.gensee.chat.gif.SpanResource;
import com.gensee.fastsdk.adapter.ChatViewPageAdapter;
import com.gensee.fastsdk.adapter.GridViewAvatarAdapter;
import com.gensee.fastsdk.ui.BaseActivity;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.InputBottomHolder;
import com.gensee.fastsdk.ui.holder.chat.SimpleChatHolder;
import com.gensee.fastsdk.ui.holder.chat.impl.RTChatImpl;
import com.gensee.fastsdk.ui.view.CustomInputDialog;
import com.gensee.fastsdk.util.ResManager;
import java.util.ArrayList;
import java.util.List;

public class DialogInputHolder
extends InputBottomHolder
implements GridViewAvatarAdapter.SelectAvatarInterface,
ViewPager.OnPageChangeListener,
RTChatImpl.OnChatModeChangeListener {
    public static final int MEXPRESSIONNUM = 18;
    private CustomInputDialog mDialog;
    private ChatViewPageAdapter mChatViewPageAdapter;
    private ViewPager mViewPage;
    private GridView mGridViewlayout;
    private int mPageExpresion;
    private LinearLayout mLinearLayoutCourse;
    protected LinearLayout mLinearLayoutExpLin;
    private List<ImageView> mListImageViewExp;
    private List<LinearLayout> mListLinearLayoutExp;
    private GridViewAvatarAdapter mGridViewAvatarAdapter;
    private SimpleChatHolder simpleChatHolder;

    public DialogInputHolder(View rootView, Object value) {
        super(rootView, value);
        this.mDialog = (CustomInputDialog)((Object)value);
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.lyBottomTop.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 1) {
                    DialogInputHolder.this.mDialog.dismiss();
                }
                return false;
            }
        });
        this.simpleChatHolder = ((BaseActivity)this.getContext()).getSimpleChatHolder();
        int roomChatMode = 1;
        ((BaseActivity)this.getContext()).getChatImpl().setOnChatModeChangeListener(this);
        roomChatMode = ((BaseActivity)this.getContext()).getChatImpl().getChatMode();
        this.onChatModeChage(roomChatMode);
        if (roomChatMode != 0) {
            this.onSelfChatEnable(((BaseActivity)this.getContext()).getChatImpl().getChatEnable());
        }
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (v.getId() == ResManager.getId("gs_chat_avatar_iv")) {
            this.selectAvatar();
        } else if (v.getId() == ResManager.getId("gs_chat_content_edt")) {
            this.emotionPanel(false);
        }
    }

    @Override
    protected void send(String text, String rich) {
        if (null != this.simpleChatHolder) {
            this.simpleChatHolder.sendPublicMsg(text, rich);
        } else if (this.getContext() instanceof LiveActivity) {
            ((LiveActivity)this.getContext()).getmChatHolder().sendPublicMsg(text, rich);
        }
    }

    @Override
    public void hide() {
        this.ivAvatar.setSelected(false);
        this.mLinearLayoutExpLin.setVisibility(8);
        this.hideDialog();
        super.hide();
    }

    protected void selectAvatar() {
        this.ivAvatar.setSelected(!this.ivAvatar.isSelected());
        if (this.ivAvatar.isSelected()) {
            this.hideKeyBoard();
        } else {
            this.showKeyBoard();
        }
        if (this.keyBoradStatus == 0) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    DialogInputHolder.this.mLinearLayoutExpLin.setVisibility(DialogInputHolder.this.ivAvatar.isSelected() ? 0 : 8);
                }
            }, 150L);
        }
    }

    @Override
    protected void keyBoardShow(boolean bVisible) {
        if (!bVisible) {
            if (this.ivAvatar.isSelected()) {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        DialogInputHolder.this.mLinearLayoutExpLin.setVisibility(0);
                    }
                }, 150L);
            } else {
                this.hideDialog();
            }
        }
    }

    private void hideDialog() {
        if (null != this.mDialog && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    @Override
    protected void initAvatar(View view) {
        this.mListImageViewExp = new ArrayList<ImageView>();
        ArrayList<View> mListGridView = new ArrayList<View>();
        this.mListLinearLayoutExp = new ArrayList<LinearLayout>();
        this.mLinearLayoutExpLin = (LinearLayout)view.findViewById(ResManager.getId("gs_viewpageexpressionlinear"));
        int mSumExpresion = SpanResource.getBrowMap((Context)this.getContext()).keySet().toArray().length;
        this.mPageExpresion = mSumExpresion % 18 == 0 ? mSumExpresion / 18 : mSumExpresion / 18 + 1;
        this.mLinearLayoutCourse = (LinearLayout)view.findViewById(ResManager.getId("gs_chatexpressaddimg"));
        for (int i = 0; i < this.mPageExpresion * 2; ++i) {
            View mGridViewLayoutExp = LayoutInflater.from((Context)this.getContext()).inflate(ResManager.getLayoutId("fs_gs_chat_gridview_expression_layout"), null);
            if (i < this.mPageExpresion) {
                ImageView mImageView = new ImageView(this.getContext());
                if (i == 0) {
                    mImageView.setBackgroundResource(ResManager.getDrawableId("fs_gs_chat_viewpage_fource"));
                } else {
                    mImageView.setBackgroundResource(ResManager.getDrawableId("fs_gs_chat_viewpage_unfource"));
                }
                LinearLayout.LayoutParams mPlayout = new LinearLayout.LayoutParams(-2, -2);
                mPlayout.setMargins(0, 10, 10, 10);
                mImageView.setLayoutParams((ViewGroup.LayoutParams)mPlayout);
                this.mLinearLayoutCourse.addView((View)mImageView);
                this.mListImageViewExp.add(mImageView);
            }
            int index = i % this.mPageExpresion;
            this.mGridViewAvatarAdapter = new GridViewAvatarAdapter(this.getContext(), this, index * 18, mSumExpresion - index * 18);
            this.mGridViewlayout = (GridView)mGridViewLayoutExp.findViewById(ResManager.getId("gs_allexpressionGrid"));
            this.mGridViewlayout.setAdapter((ListAdapter)this.mGridViewAvatarAdapter);
            mListGridView.add(mGridViewLayoutExp);
            LinearLayout mLExpressionLinearlayout = (LinearLayout)view.findViewById(ResManager.getId("gs_expr_tran_linearlayout"));
            this.mListLinearLayoutExp.add(mLExpressionLinearlayout);
        }
        this.mChatViewPageAdapter = new ChatViewPageAdapter(mListGridView);
        this.mViewPage = (ViewPager)view.findViewById(ResManager.getId("gs_viewpager"));
        this.mViewPage.setVisibility(0);
        this.mViewPage.setAdapter((PagerAdapter)this.mChatViewPageAdapter);
        this.mViewPage.setCurrentItem(mListGridView.size() * 100);
        this.mViewPage.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
    }

    @Override
    protected boolean processPublicChatDisable() {
        return false;
    }

    @Override
    public void selectAvatar(String sAvatar, Drawable drawable) {
        this.insertValue(sAvatar);
    }

    public void onPageScrolled(int i, float v, int i1) {
    }

    public void onPageSelected(int i) {
    }

    public void onPageScrollStateChanged(int i) {
    }

    @Override
    protected void emotionPanel(boolean bVisible) {
        this.mLinearLayoutExpLin.setVisibility(bVisible ? 0 : 8);
        if (!bVisible) {
            this.ivAvatar.setSelected(false);
        }
    }

    @Override
    public void onChatModeChage(final int nChatMode) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (nChatMode == 0) {
                    DialogInputHolder.this.chatEnable(false, ResManager.getStringId("fs_gs_chat_unenable"));
                } else if (nChatMode == 1) {
                    boolean isSelfChatEnable = ((BaseActivity)DialogInputHolder.this.getContext()).getChatImpl().getChatEnable();
                    if (isSelfChatEnable) {
                        DialogInputHolder.this.chatEnable(true, 0);
                    } else {
                        DialogInputHolder.this.chatEnable(false, ResManager.getStringId("fs_gs_user_disable_chat"));
                    }
                }
            }
        });
    }

    @Override
    public void onSelfChatEnable(final boolean enable) {
        this.post(new Runnable(){

            @Override
            public void run() {
                int nChatMode = ((BaseActivity)DialogInputHolder.this.getContext()).getChatImpl().getChatMode();
                if (enable) {
                    if (nChatMode == 0) {
                        DialogInputHolder.this.chatEnable(false, ResManager.getStringId("fs_gs_chat_unenable"));
                    } else {
                        DialogInputHolder.this.chatEnable(true, 0);
                    }
                } else if (nChatMode == 1) {
                    DialogInputHolder.this.chatEnable(false, ResManager.getStringId("fs_gs_user_disable_chat"));
                }
            }
        });
    }
}

