/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gensee.fastsdk.core.GSLive;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.routine.IDCInfo;

public class LandIdcHolder
extends BaseHolder {
    private ImageView ivClose;
    private LinearLayout lyIdcContent;
    private LinearLayout lyIdcNoData;
    private Button btnSure;
    private String selectIdc = "";

    public LandIdcHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("gs_idc_close_iv")) {
            this.close();
        } else if (v.getId() == ResManager.getId("gs_idc_sure_btn")) {
            this.sure();
        }
    }

    private void sure() {
        if (!"".equals(this.selectIdc) && !this.selectIdc.equals(GSLive.getIns().roomIDCGetCurrent())) {
            GSLive.getIns().roomIDCSetCurrent(this.selectIdc);
        }
        this.close();
    }

    private void close() {
        if (this.rootView.getVisibility() != 8) {
            this.rootView.setVisibility(8);
        }
    }

    public void selectIdc() {
        if (this.rootView.getVisibility() != 0) {
            this.rootView.setVisibility(0);
            this.rootView.bringToFront();
        }
        final IDCInfo[] idcs = RTLive.getIns().roomIDCGetList();
        this.lyIdcContent.removeAllViews();
        if (null == idcs || idcs.length <= 0) {
            this.lyIdcNoData.setVisibility(0);
            this.btnSure.setVisibility(8);
        } else {
            this.lyIdcNoData.setVisibility(8);
            this.btnSure.setVisibility(0);
            String sCurIdc = GSLive.getIns().roomIDCGetCurrent();
            this.selectIdc = null == sCurIdc ? "" : sCurIdc;
            int nsize = idcs.length;
            int i = 0;
            while (i < nsize) {
                TextView tv = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(ResManager.getLayoutId("fs_gs_idc_item_layout"), null);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
                if (i > 0) {
                    lp.topMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("fs_gs_idc_content_item"));
                }
                tv.setText((CharSequence)idcs[i].getName());
                tv.setTag((Object)i);
                tv.setSelected(!"".equals(this.selectIdc) && this.selectIdc.equals(idcs[i].getId()));
                final int nItemIndex = i++;
                tv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int nChildView = LandIdcHolder.this.lyIdcContent.getChildCount();
                        for (int j = 0; j < nChildView; ++j) {
                            TextView itemView = (TextView)LandIdcHolder.this.lyIdcContent.getChildAt(j);
                            if (nItemIndex == j) {
                                itemView.setSelected(true);
                                LandIdcHolder.this.selectIdc = idcs[j].getId();
                                continue;
                            }
                            itemView.setSelected(false);
                        }
                    }
                });
                this.lyIdcContent.addView((View)tv, (ViewGroup.LayoutParams)lp);
            }
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.ivClose = (ImageView)this.findViewById(ResManager.getId("gs_idc_close_iv"));
        this.ivClose.setOnClickListener((View.OnClickListener)this);
        this.lyIdcContent = (LinearLayout)this.findViewById(ResManager.getId("gs_idc_content_ly"));
        this.lyIdcNoData = (LinearLayout)this.findViewById(ResManager.getId("gs_idc_no_data_ly"));
        this.btnSure = (Button)this.findViewById(ResManager.getId("gs_idc_sure_btn"));
        this.btnSure.setOnClickListener((View.OnClickListener)this);
    }
}

