/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat;

import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Message;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.ListAdapter;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.fastsdk.adapter.GridViewAvatarAdapter;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.ui.holder.chat.ChatHolder;
import com.gensee.fastsdk.ui.holder.chat.impl.PlayerChatAdapter;
import com.gensee.fastsdk.ui.holder.chat.impl.RTChatAdapter;
import com.gensee.fastsdk.ui.holder.chat.impl.RTLandChatAdapter;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.utils.ThreadPool;
import java.util.List;

public class SimpleChatHolder
extends ChatHolder
implements MsgQueue.OnPublicChatHolderListener,
ViewPager.OnPageChangeListener,
GridViewAvatarAdapter.SelectAvatarInterface,
RTLive.OnHostStatusChangeListener,
ChatHolder.OnCalcLVHeightAfterNewMsgListener {
    public SimpleChatHolder(View rootView, Object value) {
        super(rootView, value);
        MsgQueue.getIns().setOnPublicChatHolderListener((MsgQueue.OnPublicChatHolderListener)this);
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        if (RTLive.getIns().isPublishMode()) {
            if (RTLive.getIns().getPublishMode() == 0) {
                this.adapter = new RTChatAdapter();
            } else if (RTLive.getIns().getPublishMode() == 1) {
                this.adapter = new RTLandChatAdapter();
            }
        } else {
            this.adapter = new PlayerChatAdapter();
        }
        this.lvChat.setAdapter((ListAdapter)this.adapter);
        RTLive.getIns().setOnHostStatusChangeListener(this);
    }

    @Override
    protected void initData(Object value) {
    }

    public void onClick(View v) {
    }

    private void refreshMsg(int what, List<AbsChatMessage> msgList, boolean bLatest) {
        Message message = new Message();
        message.obj = msgList;
        message.what = what;
        Bundle bundle = new Bundle();
        bundle.putBoolean("LATEST", bLatest);
        message.setData(bundle);
        this.sendMessage(message);
    }

    public void sendPublicMsg(String text, String rich) {
        if (null != this.chatImpl) {
            this.chatImpl.sendPublicMsg(text, rich);
        }
        if (!this.getLvBottom() || !MsgQueue.getIns().isPublicLatest()) {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    SimpleChatHolder.this.setLvBottom(true);
                    MsgQueue.getIns().getLatestMsgsList();
                }
            });
        }
    }

    public boolean isLvBottom() {
        return this.getLvBottom();
    }

    public boolean isSelfLvBottom() {
        return false;
    }

    public void refreshSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
    }

    public void onPullSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
    }

    public void onLoadSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
    }

    public void refreshMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10000, msgList, bLatest);
    }

    public void onPullMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10002, msgList, bLatest);
    }

    public void onLoadMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10003, msgList, bLatest);
    }

    @Override
    protected void refresh() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                MsgQueue.getIns().onMessageFresh();
            }
        });
    }

    @Override
    protected void loadMore() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                MsgQueue.getIns().onMessageLoadMore();
            }
        });
    }

    public void onPageScrollStateChanged(int arg0) {
    }

    public void onPageScrolled(int arg0, float arg1, int arg2) {
    }

    public void onPageSelected(int arg0) {
    }

    @Override
    public void selectAvatar(String sAvatar, Drawable drawable) {
    }

    @Override
    public void onHostJoin(String hostName) {
    }

    @Override
    public void onHostLeave(String hostName) {
    }

    @Override
    public void calcLVHeightAfterNewMsg() {
        if (this.lvChat.getCount() > 5) {
            GenseeUtils.setListViewHeightBasedOnChildren(this.lvChat, 5);
        }
    }

    public void onNewMsgCount(int nMsgCount) {
    }

    public void onCancelMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10001, msgList, bLatest);
    }

    public void onSelfCancelMsg(List<AbsChatMessage> msgList, boolean bLatest) {
    }
}

