/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat;

import android.view.View;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.entity.chat.VodChatMessage;
import com.gensee.fastsdk.ui.holder.chat.impl.PublicChatAdapter;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.routine.UserInfo;

public class VodChatAdapter
extends PublicChatAdapter {
    private long startTimeLocal;

    @Override
    protected AbstractViewHolder createViewHolder(View view) {
        return new VodChatViewHolder(view);
    }

    public void setStartTimeLocal(long startTimeLocal) {
        this.startTimeLocal = startTimeLocal;
    }

    class VodChatViewHolder
    extends PublicChatAdapter.PublicChatViewHolder {
        public VodChatViewHolder(View view) {
            super(view);
        }

        @Override
        public void initValue(int positon) {
            VodChatMessage chatMessage = (VodChatMessage)VodChatAdapter.this.getItem(positon);
            this.tvTitle.setText((CharSequence)chatMessage.getSendUserName());
            this.tvContent.setText((CharSequence)chatMessage.getText());
            this.tvContent.setChatContent(chatMessage.getText(), chatMessage.getRich());
            this.ivBottomLine.setVisibility(positon == VodChatAdapter.this.getCount() - 1 ? 8 : 0);
            long mCurrentTime = (chatMessage.getRelativeTime() + VodChatAdapter.this.startTimeLocal) / 1000L;
            this.tvTime.setText((CharSequence)(String.format("%02d", (mCurrentTime / 3600L % 24L + 8L) % 24L) + ":" + String.format("%02d", mCurrentTime % 3600L / 60L) + ":" + String.format("%02d", mCurrentTime % 3600L % 60L)));
            this.normalItemLy.setVisibility(0);
            this.hongbaoItemLy.setVisibility(8);
            this.tvTitle.setText((CharSequence)GenseeUtils.filterNickName(chatMessage.getSendUserName()));
            UserInfo sendUser = new UserInfo();
            sendUser.setName(chatMessage.getSendUserName());
            sendUser.setRole(chatMessage.getSendRole());
            this.tvContent.setTextColor(GenseeUtils.getActivityFromView((View)this.tvContent).getResources().getColor(ResManager.getColorId("fs_public_chat_item_default_content")));
            if (null != sendUser) {
                boolean bHost = sendUser.IsHost();
                if (bHost) {
                    this.ivTitle.setBackgroundResource(ResManager.getDrawableId("fs_chat_host_iv"));
                    this.tvTitle.setTextColor(GenseeUtils.getActivityFromView((View)this.tvTitle).getResources().getColor(ResManager.getColorId("fs_public_chat_item_host_tip")));
                } else {
                    this.ivTitle.setBackgroundResource(ResManager.getDrawableId("fs_chat_default_iv"));
                    this.tvTitle.setTextColor(GenseeUtils.getActivityFromView((View)this.tvTitle).getResources().getColor(ResManager.getColorId("fs_public_chat_item_host_tip")));
                }
            } else {
                this.ivTitle.setBackgroundResource(ResManager.getDrawableId("fs_chat_default_iv"));
                this.tvTitle.setTextColor(GenseeUtils.getActivityFromView((View)this.tvTitle).getResources().getColor(ResManager.getColorId("fs_public_chat_item_default_tip")));
            }
        }
    }
}

