/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat;

import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.widget.ListAdapter;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.fastsdk.core.VodPlayerImp;
import com.gensee.fastsdk.ui.holder.chat.ChatHolder;
import com.gensee.fastsdk.ui.holder.chat.VodChatAdapter;
import com.gensee.fastsdk.ui.holder.chat.VodChatImpl;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.utils.ThreadPool;
import java.util.List;

public class VodChatHolder
extends ChatHolder
implements MsgQueue.OnPublicChatHolderListener,
VodPlayerImp.OnVodChatListener,
VodPlayerImp.OnVodRecordInfoListener {
    private VodChatImpl mVodChatImpl;

    public VodChatHolder(View rootView, Object value) {
        super(rootView, value);
        MsgQueue.getIns().setOnPublicChatHolderListener((MsgQueue.OnPublicChatHolderListener)this);
        this.mVodChatImpl = new VodChatImpl();
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.adapter = new VodChatAdapter();
        this.lvChat.setAdapter((ListAdapter)this.adapter);
    }

    public void onClick(View v) {
    }

    @Override
    protected void refresh() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                MsgQueue.getIns().onMessageFresh();
            }
        });
    }

    @Override
    protected void loadMore() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                MsgQueue.getIns().onMessageLoadMore();
            }
        });
    }

    public boolean isLvBottom() {
        return this.getLvBottom();
    }

    public boolean isSelfLvBottom() {
        return false;
    }

    public void refreshSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
    }

    public void onPullSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
    }

    public void onLoadSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
    }

    public void onSelfCancelMsg(List<AbsChatMessage> msgList, boolean bLatest) {
    }

    public void refreshMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10000, msgList, bLatest);
    }

    public void onPullMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10002, msgList, bLatest);
    }

    public void onLoadMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10003, msgList, bLatest);
    }

    public void onCancelMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10001, msgList, bLatest);
    }

    private void refreshMsg(int what, List<AbsChatMessage> msgList, boolean bLatest) {
        Message message = new Message();
        message.obj = msgList;
        message.what = what;
        Bundle bundle = new Bundle();
        bundle.putBoolean("LATEST", bLatest);
        message.setData(bundle);
        this.sendMessage(message);
    }

    @Override
    public void onVodChatMsg(List<ChatMsg> chatMsgs) {
        if (null != this.mVodChatImpl) {
            this.mVodChatImpl.onVodChatMsg(chatMsgs);
        }
    }

    public void release() {
        if (null != this.mVodChatImpl) {
            this.mVodChatImpl.release();
        }
    }

    @Override
    protected void onScrollToBottom(boolean bScroolBottom) {
        super.onScrollToBottom(bScroolBottom);
        MsgQueue.getIns().setMsgCount(0);
    }

    public void onNewMsgCount(int nMsgCount) {
    }

    @Override
    public void onRecordInfo(String startTime) {
        if (null != this.adapter) {
            ((VodChatAdapter)this.adapter).setStartTimeLocal(GenseeUtils.utcTimeToUnix(startTime));
        }
    }
}

