/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat.impl;

import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.entity.chat.PublicMessage;
import com.gensee.entity.chat.SysMessage;
import com.gensee.entity.chat.TipMessage;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import com.gensee.view.MyTextViewEx;

public class RTChatAdapter
extends AbstractAdapter {
    public static final String TAG = "RTChatAdapter";
    private Context context;
    private int paddingH;
    private int paddingV;

    protected View createView(Context context) {
        this.context = context;
        this.paddingH = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.paddingV = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        return LayoutInflater.from((Context)context).inflate(ResManager.getLayoutId("fs_gs_public_chat_item"), null);
    }

    protected AbstractViewHolder createViewHolder(View view) {
        return new PublicChatViewHolder(view);
    }

    private class PublicChatViewHolder
    extends AbstractViewHolder {
        private MyTextViewEx tv_msg_content;

        public PublicChatViewHolder(View view) {
            super(view);
        }

        public void initView(View view) {
            this.tv_msg_content = (MyTextViewEx)view.findViewById(ResManager.getId("gs_tv_msg_content"));
        }

        public void initValue(int positon) {
            AbsChatMessage chatMessage = (AbsChatMessage)RTChatAdapter.this.getItem(positon);
            String msgRole = "";
            String msg = chatMessage.getRich();
            String color2 = "#ffe661";
            this.tv_msg_content.setBackgroundColor(RTChatAdapter.this.context.getResources().getColor(17170445));
            this.tv_msg_content.setPadding(0, 0, 0, 0);
            if (chatMessage instanceof TipMessage) {
                msgRole = "";
                this.tv_msg_content.setBackgroundResource(ResManager.getDrawableId("fs_gs_pure_video_chat_item_bg"));
                this.tv_msg_content.setPadding(RTChatAdapter.this.paddingH, RTChatAdapter.this.paddingV, RTChatAdapter.this.paddingH, RTChatAdapter.this.paddingV);
            } else if (chatMessage instanceof SysMessage) {
                color2 = "#fe526e";
                msgRole = RTChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_sys"));
            } else if (chatMessage instanceof PublicMessage) {
                msgRole = GenseeUtils.formatText(chatMessage.getSendUserName(), 12);
                UserInfo sendUser = RTLive.getIns().getUserById(chatMessage.getSendUserId());
                UserInfo self = RTLive.getIns().getSelf();
                if (null != sendUser) {
                    if (sendUser.IsHost()) {
                        color2 = "#a071fc";
                    }
                    if (null != self && self.getId() == sendUser.getId()) {
                        msgRole = RTChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_me"));
                    }
                }
            } else if (chatMessage instanceof PrivateMessage) {
                UserInfo self = RTLive.getIns().getSelf();
                if (null != self) {
                    String sTitle = "";
                    UserInfo sendUser = RTLive.getIns().getUserById(chatMessage.getSendUserId());
                    if (null != sendUser && sendUser.getId() == self.getId()) {
                        sTitle = RTChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_me")) + " ";
                        sTitle = sTitle + RTChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_to")) + " ";
                        sTitle = sTitle + GenseeUtils.formatText(chatMessage.getSendUserName(), 12) + " ";
                        sTitle = sTitle + RTChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_say")) + " ";
                    } else {
                        sTitle = GenseeUtils.formatText(chatMessage.getSendUserName(), 12) + " ";
                        sTitle = sTitle + RTChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_to")) + " ";
                        sTitle = sTitle + RTChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_me")) + " ";
                        sTitle = sTitle + RTChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_say")) + " ";
                    }
                    msgRole = sTitle;
                } else {
                    GenseeLog.d((String)RTChatAdapter.TAG, (String)("privatemsg error = " + chatMessage));
                }
            } else {
                GenseeLog.d((String)RTChatAdapter.TAG, (String)("privatemsg error = " + chatMessage));
            }
            if (chatMessage instanceof PublicMessage && msg.equals(chatMessage.getText()) && (msg.startsWith("<span>") && msg.endsWith("</span>") || msg.startsWith("<SPAN>") && msg.endsWith("</SPAN>"))) {
                msg = msg.substring(6, msg.length() - 7);
            }
            if (!TextUtils.isEmpty((CharSequence)msgRole)) {
                msgRole = "<font color=\"" + color2 + "\">" + msgRole + " " + "</font>";
            }
            String rich = "<font color=\"white\">" + msg + "</font>";
            this.tv_msg_content.setRichText(msgRole + rich);
        }
    }
}

