/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat.impl;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.entity.chat.PublicMessage;
import com.gensee.entity.chat.SysMessage;
import com.gensee.entity.chat.TipMessage;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import com.gensee.view.MyTextViewEx;

public class RTLandChatAdapter
extends AbstractAdapter {
    private Context context;

    protected View createView(Context context) {
        this.context = context;
        return LayoutInflater.from((Context)context).inflate(ResManager.getLayoutId("fs_gs_land_chat_item"), null);
    }

    protected AbstractViewHolder createViewHolder(View view) {
        return new PureVideoChatViewHolder(view);
    }

    private class PureVideoChatViewHolder
    extends AbstractViewHolder {
        private View ly_msg_item;
        private MyTextViewEx tv_msg_content;

        public PureVideoChatViewHolder(View view) {
            super(view);
        }

        public void initView(View view) {
            this.ly_msg_item = view.findViewById(ResManager.getId("gs_ly_msg_item"));
            this.tv_msg_content = (MyTextViewEx)view.findViewById(ResManager.getId("gs_tv_msg_content"));
        }

        public void initValue(int positon) {
            AbsChatMessage chatMessage = (AbsChatMessage)RTLandChatAdapter.this.getItem(positon);
            String msgRole = "";
            String msg = "";
            String color2 = "";
            if (chatMessage instanceof TipMessage) {
                msgRole = "";
                this.ly_msg_item.setBackgroundResource(ResManager.getDrawableId("fs_gs_pure_video_chat_item_bg"));
            } else if (chatMessage instanceof SysMessage) {
                this.ly_msg_item.setBackgroundResource(ResManager.getDrawableId("fs_gs_pure_video_chat_item_red"));
                msgRole = "";
            } else if (chatMessage instanceof PublicMessage) {
                msgRole = GenseeUtils.formatText(chatMessage.getSendUserName(), 12);
                this.ly_msg_item.setBackgroundResource(ResManager.getDrawableId("fs_gs_pure_video_chat_item_bg"));
                UserInfo sendUser = RTLive.getIns().getUserById(chatMessage.getSendUserId());
                UserInfo self = RTLive.getIns().getSelf();
                if (null != sendUser) {
                    boolean bHost = sendUser.IsHost();
                    boolean bSelf = false;
                    if (null != self && self.getId() == sendUser.getId()) {
                        bSelf = true;
                    }
                    if (bSelf) {
                        msgRole = RTLandChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_me"));
                        color2 = "#ff9508";
                    } else {
                        color2 = "#229ff7";
                    }
                } else {
                    color2 = "#229ff7";
                }
            } else if (chatMessage instanceof PrivateMessage) {
                UserInfo self = RTLive.getIns().getSelf();
                this.ly_msg_item.setBackgroundResource(ResManager.getDrawableId("fs_gs_pure_video_chat_item_bg"));
                if (null != self) {
                    String sTitle = "";
                    UserInfo sendUser = RTLive.getIns().getUserById(chatMessage.getSendUserId());
                    if (null != sendUser && sendUser.getId() == self.getId()) {
                        sTitle = RTLandChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_me")) + " ";
                        sTitle = sTitle + RTLandChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_to")) + " ";
                        sTitle = sTitle + GenseeUtils.formatText(chatMessage.getSendUserName(), 12) + " ";
                        sTitle = sTitle + RTLandChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_say")) + " ";
                    } else {
                        sTitle = GenseeUtils.formatText(chatMessage.getSendUserName(), 12) + " ";
                        sTitle = sTitle + RTLandChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_to")) + " ";
                        sTitle = sTitle + RTLandChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_me")) + " ";
                        sTitle = sTitle + RTLandChatAdapter.this.context.getResources().getString(ResManager.getStringId("fs_gs_chat_say")) + " ";
                    }
                    msgRole = sTitle;
                    color2 = "#229ff7";
                } else {
                    GenseeLog.d((String)"RTLandChatAdapter", (String)("privatemsg error = " + chatMessage));
                }
            }
            if (TextUtils.isEmpty((CharSequence)msg)) {
                msg = chatMessage.getRich();
            }
            if ((chatMessage instanceof PrivateMessage || chatMessage instanceof PublicMessage) && msg.equals(chatMessage.getText())) {
                if (msg.startsWith("<span>") && msg.endsWith("</span>") || msg.startsWith("<SPAN>") && msg.endsWith("</SPAN>")) {
                    msg = msg.substring(6, msg.length() - 7);
                }
                String chatText = msgRole + " " + msg;
                SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)chatText);
                if (!TextUtils.isEmpty((CharSequence)msgRole)) {
                    ForegroundColorSpan colorSpanRole = new ForegroundColorSpan(Color.parseColor((String)color2));
                    builder.setSpan((Object)colorSpanRole, 0, msgRole.length(), 0);
                }
                ForegroundColorSpan colorSpanMsg = new ForegroundColorSpan(this.tv_msg_content.getResources().getColor(ResManager.getColorId("fs_gs_white")));
                builder.setSpan((Object)colorSpanMsg, msgRole.length(), chatText.length(), 0);
                this.tv_msg_content.setText((CharSequence)builder);
            } else {
                if (!TextUtils.isEmpty((CharSequence)msgRole)) {
                    msgRole = "<font color=\"" + color2 + "\">" + msgRole + " " + "</font>";
                }
                String rich = "<font color=\"white\">" + msg + "</font>";
                this.tv_msg_content.setRichText(msgRole + rich);
            }
        }
    }
}

