/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.doc;

import android.graphics.drawable.BitmapDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.gensee.doc.OnDocViewEventListener;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.holder.IVDClickListener;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.pdu.AnnoFreepenEx;
import com.gensee.pdu.AnnoPointerEx;
import com.gensee.pdu.IGSDocView;
import com.gensee.view.GSDocViewGx;
import java.util.Calendar;

public abstract class AbstractDocHolder
extends BaseHolder
implements OnDocViewEventListener {
    public long nLastTime = Calendar.getInstance().getTimeInMillis();
    public final int DOUBLE_CLICK_TIME_INTERVAL = 500;
    private RelativeLayout.LayoutParams bottomParam;
    protected GSDocViewGx docViewGx;
    protected IVDClickListener listener;

    public AbstractDocHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public boolean onBackPressed() {
        return true;
    }

    public void layout(RelativeLayout.LayoutParams params) {
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public RelativeLayout.LayoutParams getLayoutParam() {
        if (this.bottomParam == null) {
            this.bottomParam = (RelativeLayout.LayoutParams)this.rootView.getTag();
        }
        return this.bottomParam;
    }

    public GSDocViewGx getDocView() {
        return this.docViewGx;
    }

    public void setVDLisener(IVDClickListener l) {
        this.listener = l;
    }

    @Override
    public void show(boolean isShow) {
        super.show(isShow);
    }

    @Override
    protected void initComp(Object value) {
        this.bottomParam = (RelativeLayout.LayoutParams)this.rootView.getLayoutParams();
        this.rootView.setTag((Object)this.bottomParam);
        this.docViewGx = (GSDocViewGx)this.findViewById(ResManager.getId("docView"));
        this.docViewGx.showAdaptViewWidthAlignTop();
        this.docViewGx.setOnDocViewClickedListener((OnDocViewEventListener)this);
        this.docViewGx.setBackgroundColor(this.getContext().getResources().getColor(ResManager.getColorId("fs_doc_default_bg")));
        AnnoPointerEx.setPointerCircleDrawable((BitmapDrawable)((BitmapDrawable)this.getContext().getResources().getDrawable(ResManager.getDrawableId("fs_anno_pointer"))));
        AnnoPointerEx.setPointerCrossDrawable((BitmapDrawable)((BitmapDrawable)this.getContext().getResources().getDrawable(ResManager.getDrawableId("fs_anno_pointer_cross"))));
        AnnoFreepenEx.setFreepenExDrawable((BitmapDrawable)((BitmapDrawable)this.getContext().getResources().getDrawable(ResManager.getDrawableId("fs_freepen_ex"))));
    }

    public void onClick(View v) {
    }

    public boolean onDoubleClicked(IGSDocView arg0) {
        this.processDocDoubleClicked(arg0);
        return true;
    }

    private void processDocDoubleClicked(IGSDocView arg0) {
        long nCurrentTime = Calendar.getInstance().getTimeInMillis();
        if (nCurrentTime - this.nLastTime >= 500L) {
            if (arg0.isDragScale()) {
                if (this.getContext().getResources().getConfiguration().orientation == 1) {
                    arg0.showAdaptViewWidthAlignTop();
                } else {
                    arg0.showAdaptViewHeightAlignLeft();
                }
            } else {
                this.onSwitchToFullScreen();
            }
            this.nLastTime = nCurrentTime;
        }
    }

    public boolean onEndHDirection(IGSDocView arg0, int arg1, int arg2) {
        return false;
    }

    public boolean onSingleClicked(IGSDocView arg0) {
        this.dismissVideoFloatButtons();
        return true;
    }

    public void release() {
        this.docViewGx.onPause();
        this.docViewGx.closeDoc();
        this.docViewGx.destroy();
    }

    public abstract void onSwitchToFullScreen();

    public abstract void showFullScreen();

    public abstract void showNormalScreen();

    public abstract void showPortraitDocFullScreen();

    public abstract void showLandScapeDocFullScreen();

    public abstract void showPortraitDocNorScreen();

    public abstract void dismisssFloatBtns();

    public abstract void delayDismissFloatBtns();

    public abstract void continueShowBtn();

    public abstract void dismissOwnBtn();

    public abstract void dismissVideoFloatButtons();

    public void showDocFloatBtn(int type) {
    }
}

