/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.qa;

import android.os.Bundle;
import android.os.Message;
import android.text.Html;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.gensee.entity.qa.RtQaMsg;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.InputBottomHolder;
import com.gensee.fastsdk.ui.holder.bottom.QcInputBottomHolder;
import com.gensee.fastsdk.ui.holder.chat.NewMsgHolder;
import com.gensee.fastsdk.ui.holder.qa.BaseQaHolder;
import com.gensee.fastsdk.ui.holder.qa.QaSelfHolder;
import com.gensee.fastsdk.ui.holder.qa.impl.QaAdapter;
import com.gensee.fastsdk.ui.holder.qa.impl.QaImpl;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.routine.UserInfo;
import com.gensee.utils.ThreadPool;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QaHolder
extends BaseQaHolder
implements QaMsgQueue.OnQaHolderListener,
InputBottomHolder.OnQaBottomListener,
QaAdapter.OnQaAdapterListener,
QaSelfHolder.OnQaSelfListener,
AdapterView.OnItemLongClickListener,
View.OnTouchListener,
NewMsgHolder.OnNewMsgListener {
    private QaImpl qaImpl;
    private QcInputBottomHolder mInputBottomHolder;
    private QaSelfHolder mSelfHolder;
    private Map<String, Boolean> answerExpandMap;
    private int nowRawX;
    private int nowRawY;
    private NewMsgHolder mNewMsgHolder;

    public QaHolder(View rootView, Object value) {
        super(rootView, value);
        this.findViewById(ResManager.getId("qa_view_layout_root")).setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("fs_chat_bg")));
        this.qaImpl = (QaImpl)((Object)value);
        QaMsgQueue.getIns().setOnQaHolderListener((QaMsgQueue.OnQaHolderListener)this);
        this.answerExpandMap = new HashMap<String, Boolean>();
        this.clear();
    }

    public void onClick(View v) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        View view = this.findViewById(ResManager.getId("ly_qa_empty"));
        view.setVisibility(0);
        view.setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("fs_chat_bg")));
        this.lvChat.setEmptyView(view);
        this.adapter = new QaAdapter();
        this.lvChat.setAdapter((ListAdapter)this.adapter);
        this.adapter.setOnQaAdapterListener(this);
        this.lvChat.setOnItemLongClickListener(this);
        this.lvChat.setOnTouchListener(this);
        this.mSelfHolder = new QaSelfHolder(this.findViewById(ResManager.getId("public_qa_my_ly")), null);
        this.mSelfHolder.setOnQaSelfListener(this);
        this.mNewMsgHolder = new NewMsgHolder(this.findViewById(ResManager.getId("new_msg_ly")), null);
        this.mNewMsgHolder.setOnNewMsgListener(this);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    public void show(boolean bVisible) {
        this.rootView.setVisibility(bVisible ? 0 : 8);
    }

    @Override
    public boolean isLvBottom() {
        return this.getLvBottom();
    }

    private void refreshMsg(int what, List<RtQaMsg> msgList, boolean bLatest) {
        Message message = new Message();
        message.obj = msgList;
        message.what = what;
        Bundle bundle = new Bundle();
        bundle.putBoolean("QALATEST", bLatest);
        message.setData(bundle);
        this.sendMessage(message);
    }

    public void refreshMsg(List<RtQaMsg> msgList, boolean bLatest) {
        this.refreshMsg(20000, msgList, bLatest);
    }

    public void onPullMsg(List<RtQaMsg> msgList, boolean bLatest) {
        this.refreshMsg(20004, msgList, bLatest);
    }

    public void onLoadMsg(List<RtQaMsg> msgList, boolean bLatest) {
        this.refreshMsg(20005, msgList, bLatest);
        if (bLatest) {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    QaMsgQueue.getIns().updateRtQaMsgReadFlag(Calendar.getInstance().getTimeInMillis());
                }
            });
        }
    }

    public void setQcInputBottomHolder(QcInputBottomHolder mInputBottomHolder) {
        this.mInputBottomHolder = mInputBottomHolder;
        if (null != mInputBottomHolder) {
            mInputBottomHolder.setOnQaBottomListener(this);
        }
    }

    @Override
    public void sendQaMsg(String text) {
        if (null != this.qaImpl) {
            this.qaImpl.sendQaMsg(text);
        }
        if (null == this.mInputBottomHolder) {
            return;
        }
        if (this.mInputBottomHolder.isSelfSelected()) {
            UserInfo self;
            if (!(null == this.mSelfHolder || this.isSelfLvBottom() && QaMsgQueue.getIns().isSelfQaLatest() || null == (self = PlayerLive.getIns().getSelf()))) {
                ThreadPool.getInstance().execute(new Runnable(){

                    @Override
                    public void run() {
                        QaHolder.this.mSelfHolder.resetLvBottom(true);
                        QaMsgQueue.getIns().getSelfQaLatestMsg(self.getId());
                    }
                });
            }
        } else if (!this.getLvBottom() || !QaMsgQueue.getIns().isQaLatest()) {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    QaHolder.this.setLvBottom(true);
                    QaMsgQueue.getIns().getLatestQaMsgsList();
                }
            });
        }
    }

    @Override
    public void refresh() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                QaMsgQueue.getIns().onMessageFresh();
            }
        });
    }

    @Override
    public void loadMore() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                QaMsgQueue.getIns().onMessageLoadMore();
            }
        });
    }

    public void refreshSelfMsg(final List<RtQaMsg> msgList, boolean bLatest) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (msgList.size() <= 0 && null != QaHolder.this.mInputBottomHolder) {
                    QaHolder.this.mInputBottomHolder.onlyMeMsg(QaHolder.this.getString(ResManager.getStringId("fs_qa_only_me")));
                }
            }
        });
        if (null != this.mSelfHolder) {
            this.mSelfHolder.refreshMsg(20002, msgList, bLatest);
        }
    }

    public void onPullSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
        if (null != this.mSelfHolder) {
            this.mSelfHolder.refreshMsg(20006, msgList, bLatest);
        }
    }

    public void onLoadSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
        if (null != this.mSelfHolder) {
            this.mSelfHolder.refreshMsg(20007, msgList, bLatest);
        }
    }

    @Override
    public void querySelfMsg(boolean bSelected) {
        if (null != this.mSelfHolder) {
            this.mSelfHolder.show(bSelected);
        }
        if (bSelected) {
            this.showQaNewMsgs(false, 0);
            final UserInfo self = PlayerLive.getIns().getSelf();
            if (null != self) {
                ThreadPool.getInstance().execute(new Runnable(){

                    @Override
                    public void run() {
                        QaMsgQueue.getIns().getSelfQaLatestMsg(self.getId());
                    }
                });
            }
        } else {
            this.showQaNewMsgs(true, QaMsgQueue.getIns().getMsgCount());
            QaMsgQueue.getIns().getMsgList();
            QaMsgQueue.getIns().resetSelfList();
        }
    }

    public void onCancelSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
        if (null != this.mSelfHolder) {
            this.mSelfHolder.refreshMsg(20008, msgList, bLatest);
        }
    }

    public void onCancelMsg(List<RtQaMsg> msgList, boolean bLatest) {
        this.refreshMsg(20001, msgList, bLatest);
    }

    @Override
    public int getLvWidth() {
        return this.lvChat.getWidth();
    }

    @Override
    public boolean isAnswerExpand(String answerId) {
        return null == this.answerExpandMap.get(answerId) ? false : this.answerExpandMap.get(answerId);
    }

    @Override
    public void setAnswerExpand(String answerId, boolean isExpand) {
        this.answerExpandMap.put(answerId, isExpand);
    }

    @Override
    public boolean isSelfLvBottom() {
        return null != this.mSelfHolder && this.mSelfHolder.getLvBottom();
    }

    @Override
    public void notifyView(int position, final int nHeight) {
        if (position + 1 == this.lvChat.getLastVisiblePosition()) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    QaHolder.this.lvChat.smoothScrollByOffset(nHeight);
                }
            }, 200L);
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
        RtQaMsg rtQaMsg = (RtQaMsg)this.adapter.getItem(position - 1);
        String text = rtQaMsg.getAnswer();
        View anchor = view.findViewById(ResManager.getId("qa_answer_content_tv"));
        if (TextUtils.isEmpty((CharSequence)text)) {
            text = rtQaMsg.getQuestion();
            anchor = view.findViewById(ResManager.getId("qa_only_question_content_tv"));
        }
        text = Html.fromHtml((String)text).toString();
        this.showCopyPopupWindow(anchor, false, this.nowRawX, this.nowRawY, text);
        return false;
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.nowRawX = (int)event.getRawX();
        this.nowRawY = (int)event.getRawY();
        return false;
    }

    @Override
    protected void onScrollToBottom(boolean bScroolBottom) {
        super.onScrollToBottom(bScroolBottom);
        if (bScroolBottom && QaMsgQueue.getIns().isQaLatest() && QaMsgQueue.getIns().getMsgCount() != 0) {
            QaMsgQueue.getIns().setMsgCount(0);
            this.showQaNewMsgs(false, 0);
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    QaMsgQueue.getIns().updateRtQaMsgReadFlag(Calendar.getInstance().getTimeInMillis());
                }
            });
        }
    }

    public void showQaNewMsgs(boolean bShow, int nMsgCount) {
        this.mNewMsgHolder.setNewMsg(bShow, nMsgCount);
    }

    public void onNewMsgCount(int nMsgCount) {
        this.showQaNewMsgs(true, nMsgCount);
    }

    public long getSelfUserId() {
        UserInfo userInfo = PlayerLive.getIns().getSelf();
        return null != userInfo ? userInfo.getId() : 0L;
    }

    public void clear() {
    }

    @Override
    public void onNewMsgClick() {
        this.setLvBottom(true);
        QaMsgQueue.getIns().getLatestQaMsgsList();
    }

    @Override
    public UserInfo getSelf() {
        return PlayerLive.getIns().getSelf();
    }
}

