/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.qa;

import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.widget.ListAdapter;
import com.gensee.entity.QAMsg;
import com.gensee.entity.qa.RtQaMsg;
import com.gensee.fastsdk.core.VodPlayerImp;
import com.gensee.fastsdk.ui.holder.qa.BaseQaHolder;
import com.gensee.fastsdk.ui.holder.qa.impl.QaAdapter;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.offline.OnHistoryErrCodeListener;
import com.gensee.routine.UserInfo;
import com.gensee.utils.ThreadPool;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VodQaHolder
extends BaseQaHolder
implements QaAdapter.OnQaAdapterListener,
VodPlayerImp.OnVodQaHistoryListener,
QaMsgQueue.OnQaHolderListener {
    private Map<String, Boolean> answerExpandMap;
    private VodPlayerImp mVodPlayerImp;
    private long nTempTime = Calendar.getInstance().getTimeInMillis();

    public VodQaHolder(View rootView, Object value) {
        super(rootView, value);
        QaMsgQueue.getIns().setOnQaHolderListener((QaMsgQueue.OnQaHolderListener)this);
        this.answerExpandMap = new HashMap<String, Boolean>();
        this.mVodPlayerImp = (VodPlayerImp)value;
    }

    @Override
    public void onMessage(int what, Object obj, Bundle bundle) {
        switch (what) {
            case 20009: {
                this.lvChat.stopLoadMore();
                this.onLvReLoad();
                this.bRefreshing = false;
                boolean bLatest0 = bundle.getBoolean("QALATEST");
                this.updateXListViewUi(bLatest0 && PreferUtil.getIns().getBoolean("VOD_QA_LOADED"));
                break;
            }
            case 20005: {
                this.lvChat.stopLoadMore();
                this.notifyData((List)obj);
                boolean bLatest = bundle.getBoolean("QALATEST");
                this.updateXListViewUi(bLatest && PreferUtil.getIns().getBoolean("VOD_QA_LOADED"));
                this.bRefreshing = false;
                break;
            }
            case 20004: {
                boolean bLatest1 = bundle.getBoolean("QALATEST");
                this.updateXListViewUi(bLatest1 && PreferUtil.getIns().getBoolean("VOD_QA_LOADED"));
                this.notifyData((List)obj);
                this.onLvReLoad();
                this.bRefreshing = false;
                break;
            }
            case 20000: {
                this.lvChat.stopLoadMore();
                boolean bLatestNewMsg = bundle.getBoolean("QALATEST");
                this.notifyData((List)obj);
                this.updateXListViewUi(bLatestNewMsg && PreferUtil.getIns().getBoolean("VOD_QA_LOADED"));
                this.bRefreshing = false;
            }
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        View view = this.findViewById(ResManager.getId("ly_qa_empty"));
        view.setVisibility(0);
        this.lvChat.setEmptyView(view);
        this.adapter = new QaAdapter();
        this.lvChat.setAdapter((ListAdapter)this.adapter);
        this.adapter.setOnQaAdapterListener(this);
    }

    public void onClick(View v) {
    }

    public void refreshQaHistory() {
        if (PreferUtil.getIns().getInt("VOD_QA_PAGE_INDEX") < 1) {
            this.qaHistory(1);
        } else {
            QaMsgQueue.getIns().getMsgList();
        }
    }

    private void qaHistory(int pageIndex) {
        this.mVodPlayerImp.getQatHistory(pageIndex, new OnHistoryErrCodeListener(){

            public void onErrCode(int errCode) {
                VodQaHolder.this.refreshMsg(20009, null, QaMsgQueue.getIns().isQaLatest());
            }
        });
    }

    @Override
    protected void refresh() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (PreferUtil.getIns().getInt("VOD_QA_PAGE_INDEX") < 1) {
                    VodQaHolder.this.refreshQaHistory();
                } else {
                    QaMsgQueue.getIns().onMessageFresh();
                }
            }
        });
    }

    @Override
    protected void loadMore() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (QaMsgQueue.getIns().isQaLatest()) {
                    if (null != VodQaHolder.this.mVodPlayerImp && !PreferUtil.getIns().getBoolean("VOD_QA_LOADED")) {
                        VodQaHolder.this.qaHistory(PreferUtil.getIns().getInt("VOD_QA_PAGE_INDEX") + 1);
                    }
                } else {
                    QaMsgQueue.getIns().onMessageLoadMore();
                }
            }
        });
    }

    @Override
    public int getLvWidth() {
        return this.lvChat.getWidth();
    }

    @Override
    public UserInfo getSelf() {
        return null;
    }

    @Override
    public boolean isAnswerExpand(String answerId) {
        return null == this.answerExpandMap.get(answerId) ? false : this.answerExpandMap.get(answerId);
    }

    @Override
    public void setAnswerExpand(String answerId, boolean isExpand) {
        this.answerExpandMap.put(answerId, isExpand);
    }

    @Override
    public void notifyView(int position, final int nHeight) {
        if (position + 1 == this.lvChat.getLastVisiblePosition()) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    VodQaHolder.this.lvChat.smoothScrollByOffset(nHeight);
                }
            }, 200L);
        }
    }

    @Override
    public void onVodQaHistory(List<QAMsg> chatMsgs, int pageIndex, boolean more) {
        PreferUtil.getIns().putBoolean("VOD_QA_LOADED", !more);
        PreferUtil.getIns().putInt("VOD_QA_PAGE_INDEX", pageIndex);
        ArrayList<RtQaMsg> msgs = new ArrayList<RtQaMsg>();
        for (QAMsg qaMsg : chatMsgs) {
            RtQaMsg msg = new RtQaMsg();
            msg.setAnswer(qaMsg.getAnswer());
            msg.setAnswerId(qaMsg.getAnswerId());
            msg.setAnswerOwner(qaMsg.getAnswerOwner());
            msg.setAnswerTimestamp(qaMsg.getAnswerTimestamp());
            msg.setQuestId(qaMsg.getQuestId());
            msg.setQuestion(qaMsg.getQuestion());
            msg.setQuestOwnerId(qaMsg.getQuestOwnerId());
            msg.setQuestOwnerName(qaMsg.getQuestOwnerName());
            msg.setQuestTimgstamp(qaMsg.getQuestTimgstamp());
            msg.setTimestamp(this.nTempTime);
            ++this.nTempTime;
            msgs.add(msg);
        }
        QaMsgQueue.getIns().addQaMsgList(msgs);
    }

    public boolean isLvBottom() {
        return this.getLvBottom();
    }

    public boolean isSelfLvBottom() {
        return false;
    }

    private void refreshMsg(int what, List<RtQaMsg> msgList, boolean bLatest) {
        Message message = new Message();
        message.obj = msgList;
        message.what = what;
        Bundle bundle = new Bundle();
        bundle.putBoolean("QALATEST", bLatest);
        message.setData(bundle);
        this.sendMessage(message);
    }

    public void refreshMsg(List<RtQaMsg> msgList, boolean bLatest) {
        this.refreshMsg(20000, msgList, bLatest);
    }

    public void onPullMsg(List<RtQaMsg> msgList, boolean bLatest) {
        this.refreshMsg(20004, msgList, bLatest);
    }

    public void onLoadMsg(List<RtQaMsg> msgList, boolean bLatest) {
        this.refreshMsg(20005, msgList, bLatest);
    }

    public void refreshSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
    }

    public void onPullSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
    }

    public void onLoadSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
    }

    public void onCancelMsg(List<RtQaMsg> msgList, boolean bLatest) {
    }

    public void onCancelSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
    }

    public void release() {
        QaMsgQueue.getIns().clear();
        QaMsgQueue.getIns().closedb();
        PreferUtil.getIns().putBoolean("VOD_QA_LOADED", false);
        PreferUtil.getIns().putInt("VOD_QA_PAGE_INDEX", -1);
    }

    @Override
    protected void notifyData(final List<RtQaMsg> msgList) {
        if (null != this.adapter) {
            this.adapter.notifyData(msgList);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (VodQaHolder.this.getLvBottom()) {
                        VodQaHolder.this.lvChat.setSelection(msgList.size() - 200);
                    }
                }
            }, 200L);
        }
    }

    public void onNewMsgCount(int nMsgCount) {
    }

    public long getSelfUserId() {
        return 0L;
    }

    public void clear() {
    }
}

