/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.video;

import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.core.VodPlayerImp;
import com.gensee.fastsdk.ui.VodActivity;
import com.gensee.fastsdk.ui.holder.IVDClickListener;
import com.gensee.fastsdk.ui.holder.video.AbstractVideoHolder;
import com.gensee.fastsdk.ui.holder.video.VodVideoPlayBarHolder;
import com.gensee.fastsdk.ui.holder.video.VodVideoVdBarHolder;
import com.gensee.fastsdk.ui.holder.video.VodVideoViewTouchHolder;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSVideoView;
import java.util.Calendar;

public class VodVideoHolder
extends AbstractVideoHolder
implements VodVideoVdBarHolder.OnVodVideoVdBarListener,
VodPlayerImp.OnVodVideoListener,
VodVideoViewTouchHolder.OnVodVideoViewTouchListener,
VodVideoPlayBarHolder.OnVodVideoPlayTouchListener {
    protected static final String TAG = "VodVideoHolder";
    private IVDClickListener listener;
    private GSVideoView mGsVideoView;
    private VodVideoVdBarHolder mVodVideoVdBarHolder;
    private VodVideoViewTouchHolder mVideoViewTouchHolder;
    private VodVideoPlayBarHolder mVodVideoPlayBarHolder;
    private RelativeLayout rlNoVideoTip;

    public VodVideoHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    public void setVDListener(IVDClickListener listener) {
        this.listener = listener;
        if (null != this.mVodVideoVdBarHolder) {
            this.mVodVideoVdBarHolder.setVDListener(listener);
        }
    }

    @Override
    public void showFullScreen() {
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
    }

    @Override
    public void showNormalScreen() {
    }

    public GSVideoView getVideoView() {
        return this.mGsVideoView;
    }

    public void setVodVideoPlayBarHolder(VodVideoPlayBarHolder mVodVideoPlayBarHolder) {
        this.mVodVideoPlayBarHolder = mVodVideoPlayBarHolder;
        this.mVodVideoPlayBarHolder.setOnVodVideoPlayTouchListener(this);
        this.mVodVideoVdBarHolder = new VodVideoVdBarHolder(this.findViewById(ResManager.getId("rightRl")), null);
        this.mVodVideoVdBarHolder.setOnVodVideoVdBarListener(this);
        if (null != this.listener) {
            this.mVodVideoVdBarHolder.setVDListener(this.listener);
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.mGsVideoView = (GSVideoView)this.findViewById(ResManager.getId("videoView"));
        this.rlNoVideoTip = (RelativeLayout)this.findViewById(ResManager.getId("relDef"));
    }

    public void initVodVideoTouchHolder(View view) {
        this.mVideoViewTouchHolder = new VodVideoViewTouchHolder(view, null);
        this.mVideoViewTouchHolder.setOnVideoViewTouchListener(this);
        view.findViewById(ResManager.getId("touch_rl")).setOnTouchListener((View.OnTouchListener)this.mVideoViewTouchHolder);
    }

    @Override
    public void onVideoStart() {
        this.post(new Runnable(){

            @Override
            public void run() {
                GenseeLog.d((String)VodVideoHolder.TAG, (String)"onVideoStart");
                VodVideoHolder.this.rlNoVideoTip.setVisibility(8);
            }
        });
    }

    @Override
    public void onVodInitPlayer() {
        this.post(new Runnable(){

            @Override
            public void run() {
                GenseeLog.d((String)VodVideoHolder.TAG, (String)"onVodInitPlayer");
                VodVideoHolder.this.rlNoVideoTip.setVisibility(0);
            }
        });
    }

    public void onClick(View v) {
    }

    @Override
    public void delayDismissFloatBtns() {
        this.mVodVideoVdBarHolder.delayDismissFloatBtns();
    }

    @Override
    public void continueShowBtn() {
        this.mVodVideoVdBarHolder.continueShowBtn();
    }

    @Override
    public void dismissOwnBtn() {
        this.mVodVideoVdBarHolder.dismissOwnBtn();
    }

    @Override
    public void show(boolean isShow) {
        super.show(isShow);
        this.mGsVideoView.setVisibility(isShow ? 0 : 8);
    }

    @Override
    public void onShowFloatTitle(int visibility) {
        if (null != this.listener) {
            this.listener.onFloatBtnShow(1, visibility);
        }
    }

    @Override
    public void dismisssFloatBtns() {
        this.mVodVideoVdBarHolder.dismisssFloatBtns();
    }

    @Override
    public boolean isTouch() {
        int uiMode = ((VodActivity)this.getContext()).getUIMode();
        return (uiMode & 1) != 1 || (uiMode & 2) == 2;
    }

    @Override
    public void onVideoViewSingleClick() {
        this.mVodVideoVdBarHolder.showFloatBtns();
        ((VodActivity)this.getContext()).dismissDocFloatButtons();
    }

    @Override
    public void onVideoViewDoubleClick() {
        long nCurrentTime = Calendar.getInstance().getTimeInMillis();
        long l = nCurrentTime - this.mVodVideoVdBarHolder.nLastTime;
        ((Object)((Object)this.mVodVideoVdBarHolder)).getClass();
        if (l >= 500L) {
            this.listener.onSwitchToFull(1);
            this.mVodVideoVdBarHolder.nLastTime = nCurrentTime;
        }
    }

    @Override
    public void onVodSeekTouchRate(double rate) {
        if (null != this.mVodVideoPlayBarHolder) {
            this.mVodVideoPlayBarHolder.onVodSeekTouchRate(rate);
        }
    }

    @Override
    public void onVodSeekTouchBegin() {
        if (null != this.mVodVideoPlayBarHolder) {
            this.mVodVideoPlayBarHolder.onVodSeekTouchBegin();
        }
    }

    @Override
    public void onVodSeekTouchEnd() {
        if (null != this.mVodVideoPlayBarHolder) {
            this.mVodVideoPlayBarHolder.onVodSeekTouchEnd();
        }
    }

    @Override
    public void onVodVideoPlayTime(String haveTime, String allTime) {
        this.mVideoViewTouchHolder.onVodVideoPlayTime(haveTime, allTime);
    }

    @Override
    public void onStartTrackingTouch() {
        this.mVideoViewTouchHolder.onStartTrackingTouch();
    }

    @Override
    public void onStopTrackingTouch() {
        this.mVideoViewTouchHolder.onStopTrackingTouch();
    }

    @Override
    public void onStartTrackingDirection(boolean bRight) {
        this.mVideoViewTouchHolder.onStartTrackingDirection(bRight);
    }

    @Override
    public void delayDismissFloatBottomBtns() {
    }

    @Override
    public void continueShowBottomBtns() {
    }
}

