/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.video;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.gensee.fastsdk.core.VodPlayerImp;
import com.gensee.fastsdk.ui.BaseActivity;
import com.gensee.fastsdk.ui.VodActivity;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.holder.IVDClickListener;
import com.gensee.fastsdk.ui.view.VodSpeedPopMore;
import com.gensee.fastsdk.util.AnimationUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.media.PlaySpeed;

public class VodVideoPlayBarHolder
extends BaseHolder
implements SeekBar.OnSeekBarChangeListener,
VodPlayerImp.OnVodPlayerBarListener,
VodSpeedPopMore.OnMoreItemClick {
    private ImageView ivPause;
    private SeekBar mSeekBarPlayViedo;
    private TextView tvPlayerAllTime;
    private TextView tvPlayerHaveTime;
    private ImageView ivFullScreen;
    private ImageView ivSpeedRateSelect;
    private ImageView ivSullScreenTmp;
    private VodPlayerImp mVodPlayerImp;
    private boolean isTouch = false;
    private boolean isSeekBarTouch = false;
    private IVDClickListener listener;
    private OnVodVideoPlayBarListener mOnVodVideoPlayBarListener;
    private int nCurSelectSpeedRate = 0;
    private VodSpeedPopMore mPopMore;
    private int nBeginSeekTouchProgress = 0;
    private OnVodVideoPlayTouchListener mOnVodVideoPlayTouchListener;
    private boolean bInitPlayer = false;
    private boolean bThreeSelection = false;
    private boolean bPlayBarClick = true;

    public void setOnVodVideoPlayBarListener(OnVodVideoPlayBarListener mOnVodVideoPlayBarListener) {
        this.mOnVodVideoPlayBarListener = mOnVodVideoPlayBarListener;
    }

    public void setOnVodVideoPlayTouchListener(OnVodVideoPlayTouchListener mOnVodVideoPlayTouchListener) {
        this.mOnVodVideoPlayTouchListener = mOnVodVideoPlayTouchListener;
    }

    public VodVideoPlayBarHolder(View rootView, Object value) {
        super(rootView, value);
        this.mVodPlayerImp = (VodPlayerImp)value;
        this.mVodPlayerImp.setOnVodPlayerBarListener(this);
    }

    public void setVDListener(IVDClickListener listener) {
        this.listener = listener;
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.ivPause = (ImageView)this.findViewById(ResManager.getId("pause_play_iv"));
        this.ivPause.setOnClickListener((View.OnClickListener)this);
        this.mSeekBarPlayViedo = (SeekBar)this.findViewById(ResManager.getId("player_seekbar_sk"));
        this.mSeekBarPlayViedo.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.tvPlayerAllTime = (TextView)this.findViewById(ResManager.getId("player_all_time_tv"));
        this.tvPlayerHaveTime = (TextView)this.findViewById(ResManager.getId("player_have_time_tv"));
        this.ivFullScreen = (ImageView)this.findViewById(ResManager.getId("full_screen_play_iv"));
        this.ivFullScreen.setOnClickListener((View.OnClickListener)this);
        this.ivSpeedRateSelect = (ImageView)this.findViewById(ResManager.getId("speed_rate_iv"));
        this.ivSpeedRateSelect.setOnClickListener((View.OnClickListener)this);
        this.ivSullScreenTmp = (ImageView)this.findViewById(ResManager.getId("full_screen_tmp_iv"));
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("pause_play_iv")) {
            if (!this.bInitPlayer) {
                return;
            }
            this.mVodPlayerImp.pause();
        } else if (v.getId() == ResManager.getId("full_screen_play_iv")) {
            if (null != this.listener) {
                this.listener.onSwitchToFull(1);
            }
        } else if (v.getId() == ResManager.getId("speed_rate_iv")) {
            if (!this.bInitPlayer) {
                return;
            }
            if (!this.bPlayBarClick) {
                return;
            }
            this.speedRate();
        }
    }

    public void dismissSpeedPopMore() {
        if (null != this.mPopMore && this.mPopMore.isShowing()) {
            this.mPopMore.dismiss();
        }
    }

    private void speedRate() {
        this.mPopMore = new VodSpeedPopMore(this.getContext(), this);
        this.mPopMore.showWindow(this.rootView, (View)this.ivSpeedRateSelect, this.nCurSelectSpeedRate);
        this.mPopMore.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (null != VodVideoPlayBarHolder.this.mOnVodVideoPlayBarListener) {
                    VodVideoPlayBarHolder.this.mOnVodVideoPlayBarListener.onDelayDismissShowBtns();
                }
            }
        });
        if (null != this.mOnVodVideoPlayBarListener) {
            this.mOnVodVideoPlayBarListener.onContinueShowBtns();
        }
    }

    @Override
    public void onVodSpeedSelect(int speedRateSelect) {
        if (speedRateSelect == this.nCurSelectSpeedRate) {
            return;
        }
        if (speedRateSelect == 0) {
            this.ivSpeedRateSelect.setBackgroundResource(ResManager.getDrawableId("fs_play_bar_speed_rate_10"));
            this.mVodPlayerImp.setSpeedRate(PlaySpeed.SPEED_NORMAL);
        } else if (speedRateSelect == 1) {
            this.ivSpeedRateSelect.setBackgroundResource(ResManager.getDrawableId("fs_play_bar_speed_rate_15"));
            this.mVodPlayerImp.setSpeedRate(PlaySpeed.SPEED_150);
        } else if (speedRateSelect == 2) {
            this.ivSpeedRateSelect.setBackgroundResource(ResManager.getDrawableId("fs_play_bar_speed_rate_20"));
            this.mVodPlayerImp.setSpeedRate(PlaySpeed.SPEED_200);
        }
        this.nCurSelectSpeedRate = speedRateSelect;
    }

    public void onVodSeekTouchBegin() {
        this.nBeginSeekTouchProgress = this.mSeekBarPlayViedo.getProgress();
        this.isTouch = true;
    }

    public void onVodSeekTouchEnd() {
        this.isTouch = false;
        this.mVodPlayerImp.seekTo(this.mSeekBarPlayViedo.getProgress());
    }

    public void onVodSeekTouchRate(double rate) {
        this.mSeekBarPlayViedo.setProgress(this.nBeginSeekTouchProgress + (int)(rate * (double)this.mSeekBarPlayViedo.getMax()));
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (this.isTouch) {
            this.onTime(progress);
            if (this.isSeekBarTouch && null != this.mOnVodVideoPlayTouchListener) {
                this.mOnVodVideoPlayTouchListener.onStartTrackingDirection(progress > this.nBeginSeekTouchProgress);
            }
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.nBeginSeekTouchProgress = seekBar.getProgress();
        this.isTouch = true;
        this.isSeekBarTouch = true;
        if (null != this.mOnVodVideoPlayBarListener) {
            this.mOnVodVideoPlayBarListener.onContinueShowBtns();
        }
        if (null != this.mOnVodVideoPlayTouchListener) {
            this.mOnVodVideoPlayTouchListener.onStartTrackingTouch();
        }
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        this.isTouch = false;
        this.isSeekBarTouch = false;
        if (this.bInitPlayer) {
            this.mVodPlayerImp.seekTo(seekBar.getProgress());
        }
        if (null != this.mOnVodVideoPlayBarListener) {
            this.mOnVodVideoPlayBarListener.onDelayDismissShowBtns();
        }
        if (null != this.mOnVodVideoPlayTouchListener) {
            this.mOnVodVideoPlayTouchListener.onStopTrackingTouch();
        }
    }

    @Override
    public void onVodPlayInit(final int duration) {
        this.post(new Runnable(){

            @Override
            public void run() {
                VodVideoPlayBarHolder.this.bThreeSelection = duration >= 3600000;
                VodVideoPlayBarHolder.this.ivPause.setSelected(false);
                int max = duration;
                VodVideoPlayBarHolder.this.mSeekBarPlayViedo.setMax(max);
                VodVideoPlayBarHolder.this.tvPlayerAllTime.setText((CharSequence)VodVideoPlayBarHolder.this.getTime(max /= 1000));
                VodVideoPlayBarHolder.this.ivPause.setSelected(false);
                VodVideoPlayBarHolder.this.bInitPlayer = true;
            }
        });
    }

    @Override
    public void onVodPlayStop() {
        this.post(new Runnable(){

            @Override
            public void run() {
                VodVideoPlayBarHolder.this.ivPause.setSelected(true);
                VodVideoPlayBarHolder.this.onTime(VodVideoPlayBarHolder.this.mSeekBarPlayViedo.getMax());
                VodVideoPlayBarHolder.this.mSeekBarPlayViedo.setProgress(VodVideoPlayBarHolder.this.mSeekBarPlayViedo.getMax());
            }
        });
    }

    @Override
    public void onVodPlayPause() {
        this.post(new Runnable(){

            @Override
            public void run() {
                VodVideoPlayBarHolder.this.ivPause.setSelected(true);
            }
        });
    }

    @Override
    public void onVodPlayResume() {
        this.post(new Runnable(){

            @Override
            public void run() {
                VodVideoPlayBarHolder.this.ivPause.setSelected(false);
            }
        });
    }

    @Override
    public void onVodPlayPosition(final int position) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (VodVideoPlayBarHolder.this.isTouch) {
                    return;
                }
                VodVideoPlayBarHolder.this.mVodPlayerImp.setPrePosition(position);
                VodVideoPlayBarHolder.this.mSeekBarPlayViedo.setProgress(position);
                VodVideoPlayBarHolder.this.onTime(position);
                VodVideoPlayBarHolder.this.isTouch = false;
            }
        });
    }

    @Override
    public void onVodPlayerSpeedRate(final PlaySpeed mPlaySpeed) {
        this.post(new Runnable(){

            @Override
            public void run() {
                int speedRateSelect = 0;
                VodVideoPlayBarHolder.this.ivSpeedRateSelect.setBackgroundResource(ResManager.getDrawableId("fs_play_bar_speed_rate_10"));
                if (mPlaySpeed == PlaySpeed.SPEED_NORMAL) {
                    speedRateSelect = 0;
                    VodVideoPlayBarHolder.this.ivSpeedRateSelect.setBackgroundResource(ResManager.getDrawableId("fs_play_bar_speed_rate_10"));
                } else if (mPlaySpeed == PlaySpeed.SPEED_150) {
                    speedRateSelect = 1;
                    VodVideoPlayBarHolder.this.ivSpeedRateSelect.setBackgroundResource(ResManager.getDrawableId("fs_play_bar_speed_rate_15"));
                } else if (mPlaySpeed == PlaySpeed.SPEED_200) {
                    speedRateSelect = 2;
                    VodVideoPlayBarHolder.this.ivSpeedRateSelect.setBackgroundResource(ResManager.getDrawableId("fs_play_bar_speed_rate_20"));
                }
                VodVideoPlayBarHolder.this.nCurSelectSpeedRate = speedRateSelect;
            }
        });
    }

    @Override
    public void onVodPlayerSeek(final int position) {
        this.post(new Runnable(){

            @Override
            public void run() {
                VodVideoPlayBarHolder.this.mSeekBarPlayViedo.setProgress(position);
                VodVideoPlayBarHolder.this.onTime(position);
                VodVideoPlayBarHolder.this.isTouch = false;
            }
        });
    }

    @Override
    public void onVodPlayerError(final int errCode) {
        this.post(new Runnable(){

            @Override
            public void run() {
                VodVideoPlayBarHolder.this.msgOnError(errCode);
            }
        });
    }

    private void onTime(int position) {
        int anyPosition = position;
        this.tvPlayerHaveTime.setText((CharSequence)this.getTime(anyPosition /= 1000));
        if (null != this.mOnVodVideoPlayTouchListener) {
            this.mOnVodVideoPlayTouchListener.onVodVideoPlayTime(this.tvPlayerHaveTime.getText().toString(), this.tvPlayerAllTime.getText().toString());
        }
    }

    private String getTime(int time) {
        if (this.bThreeSelection) {
            return String.format("%02d", time / 3600) + ":" + String.format("%02d", time % 3600 / 60) + ":" + String.format("%02d", time % 3600 % 60);
        }
        return String.format("%02d", time % 3600 / 60) + ":" + String.format("%02d", time % 3600 % 60);
    }

    private void msgOnError(int errorCode) {
        switch (errorCode) {
            case 12: {
                ((BaseActivity)this.getContext()).showErrMsg("", this.getString(ResManager.getStringId("fs_vod_err_lisence")), this.getString(ResManager.getStringId("fs_gs_i_known")), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        ((VodActivity)VodVideoPlayBarHolder.this.getContext()).exit();
                    }
                });
                break;
            }
            case 7: {
                ((BaseActivity)this.getContext()).showErrMsg("", this.getString(ResManager.getStringId("fs_vod_play_init_failure")), this.getString(ResManager.getStringId("fs_gs_i_known")), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        ((VodActivity)VodVideoPlayBarHolder.this.getContext()).exit();
                    }
                });
                break;
            }
            case 2: {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(ResManager.getStringId("fs_vod_pause_failure")), (int)0).show();
                break;
            }
            case 1: {
                Toast.makeText((Context)this.getContext(), (int)ResManager.getStringId("fs_vod_play_failure"), (int)0).show();
                break;
            }
            case 3: {
                Toast.makeText((Context)this.getContext(), (int)ResManager.getStringId("fs_vod_resume_failure"), (int)0).show();
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                Toast.makeText((Context)this.getContext(), (int)ResManager.getStringId("fs_vod_stop_failure"), (int)0).show();
            }
        }
    }

    public void setIvFullScreenVisibility(boolean bVisible) {
        this.ivFullScreen.setVisibility(bVisible ? 0 : 8);
        this.ivSullScreenTmp.setVisibility(bVisible ? 8 : 0);
    }

    public void setIvFullScreenSelected(boolean isSelect) {
        this.ivFullScreen.setSelected(isSelect);
    }

    public void onVodPlayBarShow(boolean bVisible) {
        if (bVisible) {
            this.bPlayBarClick = true;
            this.rootView.setVisibility(0);
            AnimationUtils.fromBottomToUp(this.rootView);
        } else {
            this.bPlayBarClick = false;
            AnimationUtils.fromUpToBottom(this.rootView);
        }
    }

    public void onResume() {
    }

    public static interface OnVodVideoPlayTouchListener {
        public void onVodVideoPlayTime(String var1, String var2);

        public void onStartTrackingTouch();

        public void onStopTrackingTouch();

        public void onStartTrackingDirection(boolean var1);
    }

    public static interface OnVodVideoPlayBarListener {
        public void onContinueShowBtns();

        public void onDelayDismissShowBtns();
    }
}

