/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.video;

import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gensee.fastsdk.ui.holder.video.VideoViewTouchHolder;
import com.gensee.fastsdk.util.ResManager;

public class VodVideoViewTouchHolder
extends VideoViewTouchHolder {
    private LinearLayout seekTouchLy;
    private ImageView seekDirectionIv;
    private TextView haveTimeTv;
    private TextView allTimeTv;

    public VodVideoViewTouchHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.seekTouchLy = (LinearLayout)this.findViewById(ResManager.getId("seek_pop_ly"));
        this.seekDirectionIv = (ImageView)this.findViewById(ResManager.getId("seek_pop_iv"));
        this.haveTimeTv = (TextView)this.findViewById(ResManager.getId("seek_have_time_pop_tv"));
        this.allTimeTv = (TextView)this.findViewById(ResManager.getId("seek_all_time_pop_tv"));
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 1: 
            case 3: {
                if (this.nScrollState != 2) break;
                this.seekTouchLy.setVisibility(8);
                if (null == this.mOnVideoViewTouchListener) break;
                ((OnVodVideoViewTouchListener)this.mOnVideoViewTouchListener).onVodSeekTouchEnd();
            }
        }
        super.onTouch(v, event);
        return null != this.mOnVideoViewTouchListener && this.mOnVideoViewTouchListener.isTouch();
    }

    @Override
    protected void horizonralScroll(MotionEvent event) {
        if (null == this.mOnVideoViewTouchListener || !this.mOnVideoViewTouchListener.isTouch()) {
            return;
        }
        if (this.seekTouchLy.getVisibility() != 0) {
            this.seekTouchLy.setVisibility(0);
            if (null != this.mOnVideoViewTouchListener) {
                ((OnVodVideoViewTouchListener)this.mOnVideoViewTouchListener).onVodSeekTouchBegin();
            }
        }
        if (null != this.mOnVideoViewTouchListener) {
            this.seekDirectionIv.setSelected(event.getRawX() > this.downEvent.getRawX());
            ((OnVodVideoViewTouchListener)this.mOnVideoViewTouchListener).onVodSeekTouchRate((double)(event.getRawX() - this.downEvent.getRawX()) / (double)this.rootView.getWidth());
        }
    }

    public void onVodVideoPlayTime(String haveTime, String allTime) {
        this.haveTimeTv.setText((CharSequence)haveTime);
        this.allTimeTv.setText((CharSequence)allTime);
    }

    public void onStartTrackingTouch() {
        if (this.seekTouchLy.getVisibility() != 0) {
            this.seekTouchLy.setVisibility(0);
        }
    }

    public void onStopTrackingTouch() {
        this.seekTouchLy.setVisibility(8);
    }

    public void onStartTrackingDirection(boolean bRight) {
        this.seekDirectionIv.setSelected(bRight);
    }

    public static interface OnVodVideoViewTouchListener
    extends VideoViewTouchHolder.OnVideoViewTouchListener {
        public void onVodSeekTouchBegin();

        public void onVodSeekTouchRate(double var1);

        public void onVodSeekTouchEnd();
    }
}

